/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.core.server;

import io.netty.channel.ServerChannel;
import io.netty.util.concurrent.AbstractEventExecutorGroup;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyNativeTransportLoader {
    @Generated
    private static final Logger log;
    private static Class<? extends AbstractEventExecutorGroup> eventExecutorGroupClazz;
    private static Class<? extends ServerChannel> serverSocketChannelClazz;

    public static Platform detectPlatformOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return Platform.WINDOWS;
        }
        if (osName.contains("mac")) {
            return Platform.MAC;
        }
        if (osName.contains("solaris") || osName.contains("sunos")) {
            return Platform.SOLARIS;
        }
        if (osName.contains("linux")) {
            return Platform.LINUX;
        }
        if (osName.contains("unix")) {
            return Platform.UNIX;
        }
        return Platform.UNKNOWN;
    }

    public static boolean isPlatformX86() {
        return System.getProperty("os.arch").contains("x86");
    }

    public static boolean loadDefault() {
        try {
            eventExecutorGroupClazz = Class.forName("io.netty.channel.nio.NioEventLoopGroup").asSubclass(AbstractEventExecutorGroup.class);
            serverSocketChannelClazz = Class.forName("io.netty.channel.socket.nio.NioServerSocketChannel").asSubclass(ServerChannel.class);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean loadKqueue() {
        try {
            eventExecutorGroupClazz = Class.forName("io.netty.channel.kqueue.KQueueEventLoopGroup").asSubclass(AbstractEventExecutorGroup.class);
            serverSocketChannelClazz = Class.forName("io.netty.channel.kqueue.KQueueServerSocketChannel").asSubclass(ServerChannel.class);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean loadEpoll() {
        try {
            eventExecutorGroupClazz = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup").asSubclass(AbstractEventExecutorGroup.class);
            serverSocketChannelClazz = Class.forName("io.netty.channel.epoll.EpollServerSocketChannel").asSubclass(ServerChannel.class);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Generated
    public static Class<? extends AbstractEventExecutorGroup> getEventExecutorGroupClazz() {
        return eventExecutorGroupClazz;
    }

    @Generated
    public static Class<? extends ServerChannel> getServerSocketChannelClazz() {
        return serverSocketChannelClazz;
    }

    static {
        boolean result;
        log = LoggerFactory.getLogger(NettyNativeTransportLoader.class);
        Platform os = NettyNativeTransportLoader.detectPlatformOS();
        boolean isPlatformX86 = NettyNativeTransportLoader.isPlatformX86();
        if (!isPlatformX86 || os == Platform.WINDOWS || os == Platform.SOLARIS || os == Platform.UNIX || os == Platform.UNKNOWN) {
            result = NettyNativeTransportLoader.loadDefault();
            log.info("Loaded default library for {}", (Object)os);
        } else if (os == Platform.LINUX) {
            result = NettyNativeTransportLoader.loadEpoll();
            log.info("Loaded epoll native library for {}", (Object)os);
        } else {
            result = NettyNativeTransportLoader.loadKqueue();
            log.info("Loaded kqueue native library for {}", (Object)os);
        }
        if (!result) {
            log.error("Failed to load native library for {}", (Object)os);
            result = NettyNativeTransportLoader.loadDefault();
            if (!result) {
                log.error("Failed to load default library for {}", (Object)os);
                System.exit(1);
            }
            log.info("Loaded default library for {}", (Object)os);
        }
    }

    public static enum Platform {
        LINUX,
        MAC,
        WINDOWS,
        SOLARIS,
        UNIX,
        UNKNOWN;

    }
}

