/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp;

import dev.keva.protocol.resp.ByteUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Recycler;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public class Command {
    private static final byte LOWER_DIFF = 32;
    private static final Recycler<Command> RECYCLER = new Recycler<Command>(){

        protected Command newObject(Recycler.Handle<Command> handle) {
            return new Command(handle);
        }
    };
    private final Recycler.Handle<Command> handle;
    private byte[][] objects;

    private Command(Recycler.Handle<Command> handle) {
        this.handle = handle;
    }

    public static Command newInstance(byte[][] objects, boolean inline) {
        if (objects == null) {
            throw new IllegalArgumentException("objects must not be null");
        }
        if (((byte[][])objects).length == 0) {
            throw new IllegalArgumentException("objects must not be empty");
        }
        Command command = (Command)RECYCLER.get();
        if (inline) {
            byte[] objs = objects[0];
            String[] strings = new String(objs, StandardCharsets.UTF_8).trim().split("\\s+");
            objects = new byte[strings.length][];
            for (int i = 0; i < strings.length; ++i) {
                objects[i] = ByteUtil.getBytes(strings[i]);
            }
        }
        command.objects = objects;
        for (int i = 0; i < objects[0].length; ++i) {
            byte b = objects[0][i];
            if (b < 65 || b > 90) continue;
            objects[0][i] = (byte)(b + 32);
        }
        return command;
    }

    public int getLength() {
        int length = 0;
        if (this.objects != null) {
            length += this.objects.length;
        }
        return length;
    }

    public byte[] getName() {
        return this.objects[0];
    }

    public void toArguments(Object[] arguments, Class<?>[] types, ChannelHandlerContext ctx) {
        int position = 0;
        for (Class<?> type : types) {
            if (type == ChannelHandlerContext.class) {
                arguments[position] = ctx;
            } else if (type == byte[].class) {
                if (position >= arguments.length) {
                    throw new IllegalArgumentException("wrong number of arguments for '" + new String(this.getName()).toLowerCase() + "' command");
                }
                if (this.objects.length - 1 > position) {
                    arguments[position] = this.objects[1 + position];
                }
            } else {
                boolean isFirstVararg = position == 0;
                int left = isFirstVararg ? this.objects.length - position - 1 : this.objects.length - 1;
                byte[][] lastArgument = new byte[left][];
                for (int i = 0; i < left; ++i) {
                    lastArgument[i] = isFirstVararg ? this.objects[i + position + 1] : this.objects[i + position];
                }
                arguments[position] = lastArgument;
            }
            ++position;
        }
    }

    public void recycle() {
        this.objects = null;
        this.handle.recycle((Object)this);
    }

    @Generated
    public byte[][] getObjects() {
        return this.objects;
    }
}

