/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp;

public class Encoding {
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final byte[] NEG_ONE;
    public static final byte[] NEG_ONE_WITH_CRLF;
    private static final int NUM_MAP_LENGTH = 256;
    private static final byte[][] numMap;
    private static final byte[][] numMapWithCRLF;

    public static byte[] numToBytes(long value) {
        return Encoding.numToBytes(value, false);
    }

    public static byte[] numToBytes(long value, boolean withCRLF) {
        if (value >= 0L && value < 256L) {
            int index = (int)value;
            return withCRLF ? numMapWithCRLF[index] : numMap[index];
        }
        if (value == -1L) {
            return withCRLF ? NEG_ONE_WITH_CRLF : NEG_ONE;
        }
        return Encoding.convert(value, withCRLF);
    }

    private static byte[] convert(long value, boolean withCRLF) {
        boolean negative = value < 0L;
        long abs = Math.abs(value);
        int index = (value == 0L ? 0 : (int)Math.log10(abs)) + (negative ? 2 : 1);
        byte[] bytes = new byte[withCRLF ? index + 2 : index];
        if (withCRLF) {
            bytes[index] = 13;
            bytes[index + 1] = 10;
        }
        if (negative) {
            bytes[0] = 45;
        }
        long next = abs;
        while ((next /= 10L) > 0L) {
            bytes[--index] = (byte)(48L + abs % 10L);
            abs = next;
        }
        bytes[--index] = (byte)(48L + abs);
        return bytes;
    }

    static {
        int i;
        NEG_ONE = Encoding.convert(-1L, false);
        NEG_ONE_WITH_CRLF = Encoding.convert(-1L, true);
        numMap = new byte[256][];
        numMapWithCRLF = new byte[256][];
        for (i = 0; i < 256; ++i) {
            Encoding.numMap[i] = Encoding.convert(i, false);
        }
        for (i = 0; i < 256; ++i) {
            Encoding.numMapWithCRLF[i] = Encoding.convert(i, true);
        }
    }
}

