/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp;

import dev.keva.protocol.resp.Command;
import dev.keva.protocol.resp.RedisReplyDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;

public class RedisCommandDecoder
extends ReplayingDecoder<Void> {
    private byte[][] bytes;
    private int arguments = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.bytes != null) {
            int numArgs = this.bytes.length;
            for (int i = this.arguments; i < numArgs; ++i) {
                if (in.readByte() == 36) {
                    long l = RedisReplyDecoder.readLong(in);
                    if (l > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
                    }
                    int size = (int)l;
                    this.bytes[i] = new byte[size];
                    in.readBytes(this.bytes[i]);
                    if (in.bytesBefore((byte)13) != 0) {
                        throw new IllegalArgumentException("Argument doesn't end in CRLF");
                    }
                    in.skipBytes(2);
                    ++this.arguments;
                } else {
                    throw new IllegalArgumentException("Unexpected character");
                }
                this.checkpoint();
            }
            try {
                out.add(Command.newInstance(this.bytes, false));
            }
            finally {
                this.bytes = null;
                this.arguments = 0;
            }
        } else if (in.readByte() == 42) {
            long l = RedisReplyDecoder.readLong(in);
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
            }
            int numArgs = (int)l;
            if (numArgs < 0) {
                throw new IllegalArgumentException("Invalid size: " + numArgs);
            }
            this.bytes = new byte[numArgs][];
            this.checkpoint();
            this.decode(ctx, in, out);
        } else {
            in.readerIndex(in.readerIndex() - 1);
            byte[][] b = new byte[1][];
            boolean isCRLF = in.indexOf(0, in.readerIndex(), (byte)13) != -1;
            ByteBuf buf = isCRLF ? in.readBytes(in.bytesBefore((byte)13)) : in.readBytes(in.bytesBefore((byte)10));
            b[0] = new byte[buf.readableBytes()];
            buf.getBytes(0, b[0]);
            in.skipBytes(isCRLF ? 2 : 1);
            out.add(Command.newInstance(b, true));
        }
    }
}

