/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp;

import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.ErrorReply;
import dev.keva.protocol.resp.reply.IntegerReply;
import dev.keva.protocol.resp.reply.MultiBulkReply;
import dev.keva.protocol.resp.reply.Reply;
import dev.keva.protocol.resp.reply.StatusReply;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class RedisReplyDecoder
extends ReplayingDecoder<Void> {
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final char ZERO = '0';
    private final boolean checkpointEnabled;
    private MultiBulkReply reply;

    public RedisReplyDecoder(boolean checkpointEnabled) {
        this.checkpointEnabled = checkpointEnabled;
    }

    public static long readLong(ByteBuf is) throws IOException {
        long size = 0L;
        int sign = 1;
        byte read = is.readByte();
        if (read == 45) {
            read = is.readByte();
            sign = -1;
        }
        while (read != 13 || is.readByte() != 10) {
            int value = read - 48;
            if (value >= 0 && value < 10) {
                size *= 10L;
                size += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.readByte();
        }
        return size * (long)sign;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> objects) throws Exception {
        objects.add(this.receive(byteBuf));
    }

    public ByteBuf readBytes(ByteBuf is) throws IOException {
        long l = RedisReplyDecoder.readLong(is);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        int size = (int)l;
        if (size == -1) {
            return null;
        }
        ByteBuf buffer = is.readSlice(size);
        byte cr = is.readByte();
        byte lf = is.readByte();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return buffer;
    }

    public Reply<?> receive(ByteBuf is) throws IOException {
        if (this.reply != null) {
            return this.decodeMultiBulkReply(is);
        }
        return this.readReply(is);
    }

    public Reply<?> readReply(ByteBuf is) throws IOException {
        byte code = is.readByte();
        switch (code) {
            case 43: {
                String status = is.readBytes(is.bytesBefore((byte)13)).toString(StandardCharsets.UTF_8);
                is.skipBytes(2);
                return new StatusReply(status);
            }
            case 45: {
                String error = is.readBytes(is.bytesBefore((byte)13)).toString(StandardCharsets.UTF_8);
                is.skipBytes(2);
                return new ErrorReply(error);
            }
            case 58: {
                return new IntegerReply(RedisReplyDecoder.readLong(is));
            }
            case 36: {
                return new BulkReply(this.readBytes(is));
            }
            case 42: {
                if (this.reply == null) {
                    return this.decodeMultiBulkReply(is);
                }
                return new RedisReplyDecoder(false).decodeMultiBulkReply(is);
            }
        }
        throw new IOException("Unexpected character in stream: " + code);
    }

    public void checkpoint() {
        if (this.checkpointEnabled) {
            super.checkpoint();
        }
    }

    public MultiBulkReply decodeMultiBulkReply(ByteBuf is) throws IOException {
        try {
            if (this.reply == null) {
                this.reply = new MultiBulkReply();
                this.checkpoint();
            }
            this.reply.read(this, is);
            MultiBulkReply multiBulkReply = this.reply;
            return multiBulkReply;
        }
        finally {
            this.reply = null;
        }
    }
}

