/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp.reply;

import dev.keva.protocol.resp.Encoding;
import dev.keva.protocol.resp.reply.Reply;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BulkReply
implements Reply<ByteBuf> {
    public static final BulkReply NIL_REPLY = new BulkReply();
    public static final BulkReply POSITIVE_INFINITY_REPLY = new BulkReply("inf");
    public static final BulkReply NEGATIVE_INFINITY_REPLY = new BulkReply("-inf");
    public static final char MARKER = '$';
    private final ByteBuf bytes;
    private final int capacity;

    private BulkReply() {
        this.bytes = null;
        this.capacity = -1;
    }

    public BulkReply(byte[] bytes) {
        this.bytes = Unpooled.wrappedBuffer((byte[])bytes);
        this.capacity = bytes.length;
    }

    public BulkReply(String str) {
        this(str.getBytes(StandardCharsets.UTF_8));
    }

    public BulkReply(ByteBuf bytes) {
        this.bytes = bytes;
        this.capacity = bytes.capacity();
    }

    @Override
    public ByteBuf data() {
        return this.bytes;
    }

    public String asUTF8String() {
        if (this.bytes == null) {
            return null;
        }
        return this.bytes.toString(StandardCharsets.UTF_8);
    }

    public String asString(Charset charset) {
        if (this.bytes == null) {
            return null;
        }
        return this.bytes.toString(charset);
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(36);
        os.writeBytes(Encoding.numToBytes(this.capacity, true));
        if (this.capacity > 0) {
            os.writeBytes(this.bytes.array());
            os.writeBytes(CRLF);
        }
        if (this.capacity == 0) {
            os.writeBytes(CRLF);
        }
    }

    public String toString() {
        return this.asUTF8String();
    }
}

