/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp.reply;

import dev.keva.protocol.resp.Encoding;
import dev.keva.protocol.resp.reply.Reply;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class IntegerReply
implements Reply<Long> {
    public static final char MARKER = ':';
    private static final IntegerReply[] replies = new IntegerReply[512];
    private final long integer;

    public IntegerReply(long integer) {
        this.integer = integer;
    }

    public static IntegerReply integer(long integer) {
        if (integer > -256L && integer < 256L) {
            return replies[(int)(integer + 255L)];
        }
        return new IntegerReply(integer);
    }

    @Override
    public Long data() {
        return this.integer;
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(58);
        os.writeBytes(Encoding.numToBytes(this.integer, true));
    }

    public String toString() {
        return this.data().toString();
    }

    static {
        for (int i = -255; i < 256; ++i) {
            IntegerReply.replies[i + 255] = new IntegerReply(i);
        }
    }
}

