/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp.reply;

import dev.keva.protocol.resp.Encoding;
import dev.keva.protocol.resp.RedisReplyDecoder;
import dev.keva.protocol.resp.reply.BulkReply;
import dev.keva.protocol.resp.reply.Reply;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class MultiBulkReply
implements Reply<Reply<?>[]> {
    public static final char MARKER = '*';
    public static final MultiBulkReply EMPTY = new MultiBulkReply(new Reply[0]);
    private Reply<?>[] replies;
    private int size = -2;
    private int index = 0;

    public MultiBulkReply() {
    }

    public MultiBulkReply(Reply<?>[] replies) {
        this.replies = replies;
        this.size = replies.length;
    }

    public void read(RedisReplyDecoder rd, ByteBuf is) throws IOException {
        if (this.size == -2) {
            long l = RedisReplyDecoder.readLong(is);
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
            }
            this.size = (int)l;
            if (this.size == -1) {
                this.replies = null;
            } else {
                if (this.size < 0) {
                    throw new IllegalArgumentException("Invalid size: " + this.size);
                }
                this.replies = new Reply[this.size];
            }
            rd.checkpoint();
        }
        for (int i = this.index; i < this.size; ++i) {
            this.replies[i] = rd.readReply(is);
            this.index = i + 1;
            rd.checkpoint();
        }
    }

    @Override
    public Reply<?>[] data() {
        return this.replies;
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(42);
        if (this.replies == null) {
            os.writeBytes(Encoding.NEG_ONE_WITH_CRLF);
        } else {
            os.writeBytes(Encoding.numToBytes(this.replies.length, true));
            for (Reply<?> reply : this.replies) {
                reply.write(os);
            }
        }
    }

    public List<String> asStringList(Charset charset) {
        if (this.replies == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(this.replies.length);
        for (Reply<?> reply : this.replies) {
            if (!(reply instanceof BulkReply)) {
                throw new IllegalArgumentException("Could not convert " + reply + " to a string");
            }
            strings.add(((BulkReply)reply).asString(charset));
        }
        return strings;
    }

    public String toString() {
        return this.asStringList(StandardCharsets.UTF_8).toString();
    }
}

