/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.protocol.resp.reply;

import dev.keva.protocol.resp.reply.Reply;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class StatusReply
implements Reply<String> {
    public static final char MARKER = '+';
    public static final StatusReply OK = new StatusReply("OK");
    private final String status;
    private final byte[] statusBytes;

    public StatusReply(String status) {
        this.status = status;
        this.statusBytes = status.getBytes(StandardCharsets.UTF_8);
    }

    public StatusReply(byte[] status) {
        this.status = null;
        this.statusBytes = status;
    }

    @Override
    public String data() {
        return this.status;
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        os.writeByte(43);
        os.writeBytes(this.statusBytes);
        os.writeBytes(CRLF);
    }

    public String toString() {
        return this.status;
    }
}

