/*
 * Decompiled with CFR 0.152.
 */
package dev.keva.util.hashbytes;

import dev.keva.util.hashbytes.BytesKey;
import java.io.Serializable;

public class BytesValue
implements Serializable {
    protected final byte[] bytes;

    public BytesValue(byte[] bytes) {
        this.bytes = bytes;
    }

    public static boolean equals(byte[] thisBytes, byte[] otherBytes) {
        int length = thisBytes.length;
        if (length != otherBytes.length) {
            return false;
        }
        int half = length / 2;
        for (int i = 0; i < half; ++i) {
            int end = length - i - 1;
            if (thisBytes[end] != otherBytes[end]) {
                return false;
            }
            if (thisBytes[i] == otherBytes[i]) continue;
            return false;
        }
        if (half != length - half) {
            return thisBytes[half] == otherBytes[half];
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (byte aByte : this.bytes) {
            hashCode += 43 * aByte;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        return o instanceof BytesKey && BytesValue.equals(this.bytes, ((BytesKey)o).bytes);
    }

    public String toString() {
        return new String(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

