/*
 * Decompiled with CFR 0.152.
 */
package dev.kord.rest.request;

import dev.kord.common.entity.Snowflake;
import dev.kord.rest.NamedFile;
import dev.kord.rest.request.JsonRequest;
import dev.kord.rest.request.MultipartRequest;
import dev.kord.rest.request.Request;
import dev.kord.rest.request.RequestBody;
import dev.kord.rest.route.Route;
import io.ktor.client.request.forms.ChannelProvider;
import io.ktor.http.CodecsKt;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.util.StringValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J+\u0010\u000e\u001a\u00020\u001e\"\b\b\u0001\u0010\u001f*\u00020\u00022\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\u000e\u001a\u0002H\u001f\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000$J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0012J\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0002J\u0016\u0010-\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u0016\u0010.\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ)\u0010/\u001a\u00020\u001e*\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0086\u0002J)\u0010/\u001a\u00020\u001e*\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\tH\u0086\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00060"}, d2={"Ldev/kord/rest/request/RequestBuilder;", "T", "", "route", "Ldev/kord/rest/route/Route;", "keySize", "", "(Ldev/kord/rest/route/Route;I)V", "baseUrl", "", "getBaseUrl", "()Ljava/lang/String;", "setBaseUrl", "(Ljava/lang/String;)V", "body", "Ldev/kord/rest/request/RequestBody;", "files", "", "Ldev/kord/rest/NamedFile;", "headers", "Lio/ktor/http/HeadersBuilder;", "keys", "", "Ldev/kord/rest/route/Route$Key;", "getKeys", "()Ljava/util/Map;", "parameters", "Lio/ktor/http/ParametersBuilder;", "getRoute", "()Ldev/kord/rest/route/Route;", "", "E", "strategy", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "build", "Ldev/kord/rest/request/Request;", "file", "name", "contentProvider", "Lio/ktor/client/request/forms/ChannelProvider;", "parameter", "key", "value", "Ldev/kord/common/entity/Snowflake;", "unencodedHeader", "urlEncodedHeader", "set", "rest"})
public final class RequestBuilder<T> {
    @NotNull
    private final Route<T> route;
    @NotNull
    private String baseUrl;
    @NotNull
    private final Map<Route.Key, String> keys;
    @NotNull
    private final HeadersBuilder headers;
    @NotNull
    private final ParametersBuilder parameters;
    @Nullable
    private RequestBody<?> body;
    @NotNull
    private final List<NamedFile> files;

    public RequestBuilder(@NotNull Route<T> route, int keySize) {
        Intrinsics.checkNotNullParameter(route, (String)"route");
        this.route = route;
        this.baseUrl = Route.Companion.getBaseUrl();
        this.keys = new HashMap(keySize, 1.0f);
        this.headers = new HeadersBuilder(0, 1, null);
        this.parameters = ParametersKt.ParametersBuilder$default((int)0, (int)1, null);
        this.files = new ArrayList();
    }

    public /* synthetic */ RequestBuilder(Route route, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        this(route, n);
    }

    @NotNull
    public final Route<T> getRoute() {
        return this.route;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public final void setBaseUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.baseUrl = string2;
    }

    @NotNull
    public final Map<Route.Key, String> getKeys() {
        return this.keys;
    }

    public final void set(@NotNull Map<Route.Key, String> $this$set, @NotNull Route.Key key, @NotNull Snowflake value2) {
        Intrinsics.checkNotNullParameter($this$set, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        $this$set.put(key, value2.toString());
    }

    public final void set(@NotNull Map<String, String> $this$set, @NotNull Route.Key key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter($this$set, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        $this$set.put(key.getIdentifier(), value2);
    }

    public final <E> void body(@NotNull SerializationStrategy<? super E> strategy, @NotNull E body) {
        Intrinsics.checkNotNullParameter(strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.body = new RequestBody<E>(strategy, body);
    }

    public final void parameter(@NotNull String key, @NotNull Snowflake value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.parameters.append(key, Long.toUnsignedString(value2.getValue-s-VKNKU()));
    }

    public final void parameter(@NotNull String key, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.parameters.append(key, value2.toString());
    }

    public final void urlEncodedHeader(@NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.headers.append(key, CodecsKt.encodeURLQueryComponent$default((String)value2, (boolean)false, (boolean)false, null, (int)7, null));
    }

    public final void unencodedHeader(@NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.headers.append(key, value2);
    }

    public final void file(@NotNull String name2, @NotNull ChannelProvider contentProvider) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)contentProvider, (String)"contentProvider");
        this.files.add(new NamedFile(name2, contentProvider));
    }

    public final void file(@NotNull NamedFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.files.add(file2);
    }

    @NotNull
    public final Request<?, T> build() {
        return this.files.isEmpty() ? (Request)new JsonRequest(this.route, this.keys, (StringValues)this.parameters.build(), (StringValues)this.headers.build(), this.body, this.baseUrl) : (Request)new MultipartRequest(this.route, this.keys, (StringValues)this.parameters.build(), (StringValues)this.headers.build(), this.body, this.files, this.baseUrl);
    }
}

