/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime;
import dev.kosrat.muslimdata.models.AzkarCategory;
import dev.kosrat.muslimdata.models.AzkarChapter;
import dev.kosrat.muslimdata.models.AzkarItem;
import dev.kosrat.muslimdata.models.Location;
import dev.kosrat.muslimdata.models.NameOfAllah;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\ba\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H'J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005H'J+\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH'\u00a2\u0006\u0002\u0010\u0010J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000fH'J \u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H'J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\n\u001a\u00020\u0005H'J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H'J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH'J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0005H'\u00a8\u0006\u001f"}, d2={"Ldev/kosrat/muslimdata/database/MuslimDataDao;", "", "geocoder", "Ldev/kosrat/muslimdata/models/Location;", "countryCode", "", "city", "getAzkarCategories", "", "Ldev/kosrat/muslimdata/models/AzkarCategory;", "language", "getAzkarChapters", "Ldev/kosrat/muslimdata/models/AzkarChapter;", "azkarIds", "", "", "(Ljava/lang/String;[Ljava/lang/Integer;)Ljava/util/List;", "categoryId", "getAzkarItems", "Ldev/kosrat/muslimdata/models/AzkarItem;", "chapterId", "getNames", "Ldev/kosrat/muslimdata/models/NameOfAllah;", "getPrayerTimes", "Ldev/kosrat/muslimdata/database/tables/prayertimes/FixedPrayerTime;", "date", "reverseGeocoder", "latitude", "", "longitude", "searchLocation", "muslim-data_release"})
@Dao
public interface MuslimDataDao {
    @Transaction
    @Query(value="SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code WHERE city_name like :city")
    @Nullable
    public List<Location> searchLocation(@NotNull String var1);

    @Transaction
    @Query(value="SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code WHERE city.country_code= :countryCode  COLLATE NOCASE and city_name= :city COLLATE NOCASE")
    @Nullable
    public Location geocoder(@NotNull String var1, @NotNull String var2);

    @Transaction
    @Query(value="SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code ORDER BY abs(latitude - :latitude) + abs(longitude - :longitude) LIMIT 1")
    @Nullable
    public Location reverseGeocoder(double var1, double var3);

    @Query(value="SELECT * FROM prayer_time WHERE city = :city AND country_code = :countryCode AND date = :date")
    @NotNull
    public FixedPrayerTime getPrayerTimes(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @Transaction
    @Query(value="SELECT name._id AS number, name.name , tr.name AS translation FROM name INNER JOIN name_translation as tr on tr.name_id = name._id and tr.language = :language")
    @NotNull
    public List<NameOfAllah> getNames(@NotNull String var1);

    @Transaction
    @Query(value="SELECT category._id AS categoryId, category_name AS categoryName FROM azkar_category AS category INNER JOIN azkar_category_translation as tr on tr.category_id = category._id WHERE language = :language")
    @NotNull
    public List<AzkarCategory> getAzkarCategories(@NotNull String var1);

    @Transaction
    @Query(value="SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation as tr on tr.chapter_id = chapter._id WHERE language = :language and (:categoryId = -1 OR category_id = :categoryId)")
    @Nullable
    public List<AzkarChapter> getAzkarChapters(@NotNull String var1, int var2);

    @Transaction
    @Query(value="SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation as tr on tr.chapter_id = chapter._id WHERE language = :language and chapter._id in (:azkarIds)")
    @Nullable
    public List<AzkarChapter> getAzkarChapters(@NotNull String var1, @NotNull Integer[] var2);

    @Transaction
    @Query(value="SELECT item._id AS itemId, item.chapter_id AS chapterId, tr.language, item.item, tr.item_translation AS translation, rtr.reference FROM azkar_item as item INNER JOIN azkar_item_translation AS tr ON tr.item_id = item._id INNER JOIN azkar_reference AS ref ON ref.item_id = item._id INNER JOIN azkar_reference_translation AS rtr ON rtr.reference_id = ref._id AND rtr.language = tr.language WHERE chapterId = :chapterId AND tr.language = :language")
    @Nullable
    public List<AzkarItem> getAzkarItems(int var1, @NotNull String var2);
}

