/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.models;

import dev.kosrat.muslimdata.extensions.DateUtilKt;
import dev.kosrat.muslimdata.models.TimeFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c2\u0003J\t\u0010 \u001a\u00020\u0003H\u00c2\u0003J\t\u0010!\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c2\u0003J\t\u0010#\u001a\u00020\u0003H\u00c2\u0003JE\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\b\b\u0002\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010-J\u0011\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0086\u0002J\t\u00101\u001a\u000200H\u00d6\u0001J\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020*J\b\u00106\u001a\u00020*H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\f\u00a8\u00067"}, d2={"Ldev/kosrat/muslimdata/models/PrayerTime;", "", "_fajr", "Ljava/util/Date;", "_sunrise", "_dhuhr", "_asr", "_maghrib", "_isha", "(Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;Ljava/util/Date;)V", "asr", "getAsr", "()Ljava/util/Date;", "dhuhr", "getDhuhr", "fajr", "getFajr", "isha", "getIsha", "maghrib", "getMaghrib", "sunrise", "getSunrise", "adjustDST", "", "adjustDST$muslim_data_release", "applyOffset", "offsets", "", "applyOffset$muslim_data_release", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "formatPrayerTime", "", "", "format", "Ldev/kosrat/muslimdata/models/TimeFormat;", "(Ldev/kosrat/muslimdata/models/TimeFormat;)[Ljava/lang/String;", "get", "i", "", "hashCode", "nextPrayerTimeIndex", "nextPrayerTimeInterval", "", "nextPrayerTimeRemaining", "toString", "muslim-data_release"})
public final class PrayerTime {
    @NotNull
    private Date _fajr;
    @NotNull
    private Date _sunrise;
    @NotNull
    private Date _dhuhr;
    @NotNull
    private Date _asr;
    @NotNull
    private Date _maghrib;
    @NotNull
    private Date _isha;

    public PrayerTime(@NotNull Date _fajr, @NotNull Date _sunrise, @NotNull Date _dhuhr, @NotNull Date _asr, @NotNull Date _maghrib, @NotNull Date _isha) {
        Intrinsics.checkNotNullParameter((Object)_fajr, (String)"_fajr");
        Intrinsics.checkNotNullParameter((Object)_sunrise, (String)"_sunrise");
        Intrinsics.checkNotNullParameter((Object)_dhuhr, (String)"_dhuhr");
        Intrinsics.checkNotNullParameter((Object)_asr, (String)"_asr");
        Intrinsics.checkNotNullParameter((Object)_maghrib, (String)"_maghrib");
        Intrinsics.checkNotNullParameter((Object)_isha, (String)"_isha");
        this._fajr = _fajr;
        this._sunrise = _sunrise;
        this._dhuhr = _dhuhr;
        this._asr = _asr;
        this._maghrib = _maghrib;
        this._isha = _isha;
    }

    @NotNull
    public final Date getFajr() {
        return this._fajr;
    }

    @NotNull
    public final Date getSunrise() {
        return this._sunrise;
    }

    @NotNull
    public final Date getDhuhr() {
        return this._dhuhr;
    }

    @NotNull
    public final Date getAsr() {
        return this._asr;
    }

    @NotNull
    public final Date getMaghrib() {
        return this._maghrib;
    }

    @NotNull
    public final Date getIsha() {
        return this._isha;
    }

    public final void applyOffset$muslim_data_release(@NotNull int[] offsets) {
        Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
        this._fajr = DateUtilKt.addMinutes(this._fajr, offsets[0]);
        this._sunrise = DateUtilKt.addMinutes(this._sunrise, offsets[1]);
        this._dhuhr = DateUtilKt.addMinutes(this._dhuhr, offsets[2]);
        this._asr = DateUtilKt.addMinutes(this._asr, offsets[3]);
        this._maghrib = DateUtilKt.addMinutes(this._maghrib, offsets[4]);
        this._isha = DateUtilKt.addMinutes(this._isha, offsets[5]);
    }

    public final void adjustDST$muslim_data_release() {
        TimeZone timeZone = TimeZone.getDefault();
        if (timeZone.inDaylightTime(new Date())) {
            this._fajr = DateUtilKt.addHours(this._fajr, 1);
            this._sunrise = DateUtilKt.addHours(this._sunrise, 1);
            this._dhuhr = DateUtilKt.addHours(this._dhuhr, 1);
            this._asr = DateUtilKt.addHours(this._asr, 1);
            this._maghrib = DateUtilKt.addHours(this._maghrib, 1);
            this._isha = DateUtilKt.addHours(this._isha, 1);
        }
    }

    @NotNull
    public final String[] formatPrayerTime(@NotNull TimeFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        String[] stringArray = new String[]{DateUtilKt.format(this._fajr, format), DateUtilKt.format(this._sunrise, format), DateUtilKt.format(this._dhuhr, format), DateUtilKt.format(this._asr, format), DateUtilKt.format(this._maghrib, format), DateUtilKt.format(this._isha, format)};
        return stringArray;
    }

    public static /* synthetic */ String[] formatPrayerTime$default(PrayerTime prayerTime, TimeFormat timeFormat, int n, Object object) {
        if ((n & 1) != 0) {
            timeFormat = TimeFormat.TIME_24;
        }
        return prayerTime.formatPrayerTime(timeFormat);
    }

    /*
     * WARNING - void declaration
     */
    public final int nextPrayerTimeIndex() {
        Date[] dateArray = new Date[]{this._fajr, this._sunrise, this._dhuhr, this._asr, this._maghrib, this._isha};
        Date[] prayers = dateArray;
        Date now = new Date();
        Date[] $this$forEachIndexed$iv = prayers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Date item$iv : $this$forEachIndexed$iv) {
            void date;
            int n = index$iv++;
            Date date2 = item$iv;
            int index = n;
            boolean bl = false;
            if (!date.after(now)) continue;
            return index;
        }
        return -1;
    }

    public final long nextPrayerTimeInterval() {
        Date[] dateArray = new Date[]{this._fajr, this._sunrise, this._dhuhr, this._asr, this._maghrib, this._isha};
        Date[] prayers = dateArray;
        int index = this.nextPrayerTimeIndex();
        if (index == -1) {
            return DateUtilKt.addDays(this._fajr, 1).getTime() - new Date().getTime();
        }
        return prayers[index].getTime() - new Date().getTime();
    }

    @NotNull
    public final String nextPrayerTimeRemaining() {
        long time = this.nextPrayerTimeInterval();
        long hour = time / (long)3600000;
        long minute = (time -= hour * (long)3600000) / (long)60000;
        long second = (time -= minute * (long)60000) / (long)1000;
        String string = "%02d:%02d:%02d";
        Object[] objectArray = new Object[]{hour, minute, second};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @NotNull
    public final Date get(int i) {
        Date[] dateArray = new Date[]{this._fajr, this._sunrise, this._dhuhr, this._asr, this._maghrib, this._isha};
        Date[] prayers = dateArray;
        return i < 0 ? prayers[5] : prayers[i];
    }

    @NotNull
    public String toString() {
        return "PrayerTime(fajr=" + this._fajr + ", sunrise=" + this._sunrise + ", dhuhr=" + this._dhuhr + ", asr=" + this._asr + ", maghrib=" + this._maghrib + ", ish=" + this._isha + ')';
    }

    private final Date component1() {
        return this._fajr;
    }

    private final Date component2() {
        return this._sunrise;
    }

    private final Date component3() {
        return this._dhuhr;
    }

    private final Date component4() {
        return this._asr;
    }

    private final Date component5() {
        return this._maghrib;
    }

    private final Date component6() {
        return this._isha;
    }

    @NotNull
    public final PrayerTime copy(@NotNull Date _fajr, @NotNull Date _sunrise, @NotNull Date _dhuhr, @NotNull Date _asr, @NotNull Date _maghrib, @NotNull Date _isha) {
        Intrinsics.checkNotNullParameter((Object)_fajr, (String)"_fajr");
        Intrinsics.checkNotNullParameter((Object)_sunrise, (String)"_sunrise");
        Intrinsics.checkNotNullParameter((Object)_dhuhr, (String)"_dhuhr");
        Intrinsics.checkNotNullParameter((Object)_asr, (String)"_asr");
        Intrinsics.checkNotNullParameter((Object)_maghrib, (String)"_maghrib");
        Intrinsics.checkNotNullParameter((Object)_isha, (String)"_isha");
        return new PrayerTime(_fajr, _sunrise, _dhuhr, _asr, _maghrib, _isha);
    }

    public static /* synthetic */ PrayerTime copy$default(PrayerTime prayerTime, Date date, Date date2, Date date3, Date date4, Date date5, Date date6, int n, Object object) {
        if ((n & 1) != 0) {
            date = prayerTime._fajr;
        }
        if ((n & 2) != 0) {
            date2 = prayerTime._sunrise;
        }
        if ((n & 4) != 0) {
            date3 = prayerTime._dhuhr;
        }
        if ((n & 8) != 0) {
            date4 = prayerTime._asr;
        }
        if ((n & 0x10) != 0) {
            date5 = prayerTime._maghrib;
        }
        if ((n & 0x20) != 0) {
            date6 = prayerTime._isha;
        }
        return prayerTime.copy(date, date2, date3, date4, date5, date6);
    }

    public int hashCode() {
        int result = this._fajr.hashCode();
        result = result * 31 + this._sunrise.hashCode();
        result = result * 31 + this._dhuhr.hashCode();
        result = result * 31 + this._asr.hashCode();
        result = result * 31 + this._maghrib.hashCode();
        result = result * 31 + this._isha.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrayerTime)) {
            return false;
        }
        PrayerTime prayerTime = (PrayerTime)other;
        if (!Intrinsics.areEqual((Object)this._fajr, (Object)prayerTime._fajr)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this._sunrise, (Object)prayerTime._sunrise)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this._dhuhr, (Object)prayerTime._dhuhr)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this._asr, (Object)prayerTime._asr)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this._maghrib, (Object)prayerTime._maghrib)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this._isha, (Object)prayerTime._isha);
    }
}

