/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database.tables.prayertimes;

import dev.kosrat.muslimdata.extensions.DateUtilKt;
import dev.kosrat.muslimdata.models.CalculationMethod;
import dev.kosrat.muslimdata.models.HigherLatitudeMethod;
import dev.kosrat.muslimdata.models.Location;
import dev.kosrat.muslimdata.models.PrayerAttribute;
import dev.kosrat.muslimdata.models.PrayerTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002J\u0018\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0002J\u0010\u00100\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0002J\u0010\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\bH\u0002J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J \u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0010H\u0002J\u0010\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\bH\u0002J\u0010\u0010?\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0002J\u0010\u0010@\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\bH\u0002J\u0018\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Ldev/kosrat/muslimdata/database/tables/prayertimes/CalculatedPrayerTime;", "", "attribute", "Ldev/kosrat/muslimdata/models/PrayerAttribute;", "(Ldev/kosrat/muslimdata/models/PrayerAttribute;)V", "invalidTime", "", "jDate", "", "lat", "lng", "methodParams", "Ljava/util/HashMap;", "Ldev/kosrat/muslimdata/models/CalculationMethod;", "", "numIterations", "", "timeZone", "adjustHighLatTimes", "times", "adjustTimes", "adjustTimesFormat", "Ljava/util/ArrayList;", "computeAsr", "step", "t", "computeDayTimes", "computeMidDay", "computeTime", "G", "computeTimes", "dArcCos", "x", "dArcCot", "dArcSin", "dArcTan2", "y", "dCos", "d", "dSin", "dTan", "dayPortion", "degreesToRadians", "alpha", "equationOfTime", "jd", "fixAngle", "a", "fixHour", "floatToTime24", "time", "getPrayerTimes", "Ldev/kosrat/muslimdata/models/PrayerTime;", "location", "Ldev/kosrat/muslimdata/models/Location;", "date", "Ljava/util/Date;", "julianDate", "year", "month", "day", "nightPortion", "angle", "radiansToDegrees", "sunDeclination", "sunPosition", "timeDiff", "time1", "time2", "muslim-data_release"})
public final class CalculatedPrayerTime {
    @NotNull
    private final PrayerAttribute attribute;
    private double lat;
    private double lng;
    private double timeZone;
    private double jDate;
    @NotNull
    private final String invalidTime;
    private int numIterations;
    @NotNull
    private final HashMap<CalculationMethod, double[]> methodParams;

    public CalculatedPrayerTime(@NotNull PrayerAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.attribute = attribute;
        this.invalidTime = "-----";
        this.numIterations = 1;
        this.methodParams = CalculationMethod.Companion.methodList();
    }

    private final double fixAngle(double a) {
        double a2 = a;
        return (a2 -= (double)360 * Math.floor(a2 / 360.0)) < 0.0 ? a2 + (double)360 : a2;
    }

    private final double fixHour(double a) {
        double a2 = a;
        return (a2 -= 24.0 * Math.floor(a2 / 24.0)) < 0.0 ? a2 + (double)24 : a2;
    }

    private final double radiansToDegrees(double alpha) {
        return alpha * 180.0 / Math.PI;
    }

    private final double degreesToRadians(double alpha) {
        return alpha * Math.PI / 180.0;
    }

    private final double dSin(double d) {
        return Math.sin(this.degreesToRadians(d));
    }

    private final double dCos(double d) {
        return Math.cos(this.degreesToRadians(d));
    }

    private final double dTan(double d) {
        return Math.tan(this.degreesToRadians(d));
    }

    private final double dArcSin(double x) {
        return this.radiansToDegrees(Math.asin(x));
    }

    private final double dArcCos(double x) {
        return this.radiansToDegrees(Math.acos(x));
    }

    private final double dArcTan2(double y, double x) {
        return this.radiansToDegrees(Math.atan2(y, x));
    }

    private final double dArcCot(double x) {
        return this.radiansToDegrees(Math.atan2(1.0, x));
    }

    private final double julianDate(int year, int month, int day) {
        int year2 = year;
        int month2 = month;
        if (month2 <= 2) {
            --year2;
            month2 += 12;
        }
        double a = Math.floor((double)year2 / 100.0);
        double b = (double)2 - a + Math.floor(a / 4.0);
        return Math.floor(365.25 * (double)(year2 + 4716)) + Math.floor(30.6001 * (double)(month2 + 1)) + (double)day + b - 1524.5;
    }

    private final double[] sunPosition(double jd) {
        double d1 = jd - (double)2451545;
        double g = this.fixAngle(357.529 + 0.98560028 * d1);
        double q = this.fixAngle(280.459 + 0.98564736 * d1);
        double l = this.fixAngle(q + 1.915 * this.dSin(g) + 0.02 * this.dSin((double)2 * g));
        double e = 23.439 - 3.6E-7 * d1;
        double d2 = this.dArcSin(this.dSin(e) * this.dSin(l));
        double ra = this.dArcTan2(this.dCos(e) * this.dSin(l), this.dCos(l)) / 15.0;
        ra = this.fixHour(ra);
        double eqt = q / 15.0 - ra;
        double[] sPosition = new double[]{d2, eqt};
        return sPosition;
    }

    private final double equationOfTime(double jd) {
        return this.sunPosition(jd)[1];
    }

    private final double sunDeclination(double jd) {
        return this.sunPosition(jd)[0];
    }

    private final double computeMidDay(double t) {
        double t2 = this.equationOfTime(this.jDate + t);
        return this.fixHour((double)12 - t2);
    }

    private final double computeTime(double G, double t) {
        double d = this.sunDeclination(this.jDate + t);
        double z = this.computeMidDay(t);
        double beg = -this.dSin(G) - this.dSin(d) * this.dSin(this.lat);
        double mid = this.dCos(d) * this.dCos(this.lat);
        double v = this.dArcCos(beg / mid) / 15.0;
        return z + (G > 90.0 ? -v : v);
    }

    private final double computeAsr(double step, double t) {
        double d = this.sunDeclination(this.jDate + t);
        double g = -this.dArcCot(step + this.dTan(Math.abs(this.lat - d)));
        return this.computeTime(g, t);
    }

    private final double timeDiff(double time1, double time2) {
        return this.fixHour(time2 - time1);
    }

    @NotNull
    public final PrayerTime getPrayerTimes(@NotNull Location location, @NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        this.timeZone = (double)TimeZone.getDefault().getOffset(date.getTime()) / 3600000.0;
        this.lat = location.getLatitude();
        this.lng = location.getLongitude();
        this.jDate = this.julianDate(year, month, day);
        double lonDiff = location.getLongitude() / 360.0;
        this.jDate -= lonDiff;
        ArrayList<String> cTime = this.computeDayTimes();
        String string = cTime.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cTime[0]");
        Date date2 = DateUtilKt.toDate(string, date);
        String string2 = cTime.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cTime[1]");
        Date date3 = DateUtilKt.toDate(string2, date);
        String string3 = cTime.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cTime[2]");
        Date date4 = DateUtilKt.toDate(string3, date);
        String string4 = cTime.get(3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"cTime[3]");
        Date date5 = DateUtilKt.toDate(string4, date);
        String string5 = cTime.get(4);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"cTime[4]");
        Date date6 = DateUtilKt.toDate(string5, date);
        String string6 = cTime.get(5);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"cTime[5]");
        return new PrayerTime(date2, date3, date4, date5, date6, DateUtilKt.toDate(string6, date));
    }

    private final String floatToTime24(double time) {
        String string;
        String result;
        block2: {
            double minutes;
            int hours;
            block1: {
                double time2 = time;
                result = null;
                if (Double.isNaN(time2)) {
                    return this.invalidTime;
                }
                time2 = this.fixHour(time2 + 0.008333333333333333);
                hours = (int)Math.floor(time2);
                minutes = Math.floor((time2 - (double)hours) * 60.0);
                boolean bl = 0 <= hours ? hours < 10 : false;
                if (!bl || !(minutes >= 0.0) || !(minutes <= 9.0)) break block1;
                string = "0" + hours + ":0" + MathKt.roundToInt((double)minutes);
                break block2;
            }
            string = (0 <= hours ? hours < 10 : false) ? "0" + hours + ":" + MathKt.roundToInt((double)minutes) : ((0.0 <= minutes ? minutes <= 9.0 : false) ? hours + ":0" + MathKt.roundToInt((double)minutes) : hours + ":" + MathKt.roundToInt((double)minutes));
        }
        result = string;
        return result;
    }

    private final double[] computeTimes(double[] times) {
        double[] t = this.dayPortion(times);
        double d = 180;
        double[] dArray = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray);
        double fajr = this.computeTime(d - dArray[0], t[0]);
        double sunrise = this.computeTime(179.167, t[1]);
        double dhuhr = this.computeMidDay(t[2]);
        double asr = this.computeAsr(1.0 + (double)this.attribute.getAsrMethod().getValue(), t[3]);
        double sunset = this.computeTime(0.833, t[4]);
        double[] dArray2 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray2);
        double maghrib = this.computeTime(dArray2[2], t[5]);
        double[] dArray3 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray3);
        double isha = this.computeTime(dArray3[4], t[6]);
        double[] dArray4 = new double[]{fajr, sunrise, dhuhr, asr, sunset, maghrib, isha};
        return dArray4;
    }

    private final ArrayList<String> computeDayTimes() {
        double[] dArray = new double[]{5.0, 6.0, 12.0, 13.0, 18.0, 18.0, 18.0};
        double[] times = dArray;
        int i = 1;
        int n = this.numIterations;
        if (i <= n) {
            while (true) {
                times = this.computeTimes(times);
                if (i == n) break;
                ++i;
            }
        }
        times = this.adjustTimes(times);
        return this.adjustTimesFormat(times);
    }

    private final double[] adjustTimes(double[] times) {
        double[] times2 = times;
        int i = 0;
        int n = times2.length;
        while (i < n) {
            double[] dArray = times2;
            int n2 = i++;
            dArray[n2] = dArray[n2] + (this.timeZone - this.lng / (double)15);
        }
        double[] dArray = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray);
        if (dArray[1] == 1.0) {
            double d = times2[4];
            double[] dArray2 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
            Intrinsics.checkNotNull((Object)dArray2);
            times2[5] = d + dArray2[2] / (double)60;
        }
        double[] dArray3 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray3);
        if (dArray3[3] == 1.0) {
            double d = times2[5];
            double[] dArray4 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
            Intrinsics.checkNotNull((Object)dArray4);
            times2[6] = d + dArray4[4] / (double)60;
        }
        if (this.attribute.getHigherLatitudeMethod() != HigherLatitudeMethod.NONE) {
            times2 = this.adjustHighLatTimes(times2);
        }
        return times2;
    }

    private final ArrayList<String> adjustTimesFormat(double[] times) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < 7; ++i) {
            result.add(this.floatToTime24(times[i]));
        }
        result.remove(4);
        return result;
    }

    private final double[] adjustHighLatTimes(double[] times) {
        double d;
        double d2;
        double nightTime = this.timeDiff(times[4], times[1]);
        double[] dArray = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray);
        double fajrDiff = this.nightPortion(dArray[0]) * nightTime;
        if (Double.isNaN(times[0]) || this.timeDiff(times[0], times[1]) > fajrDiff) {
            times[0] = times[1] - fajrDiff;
        }
        double[] dArray2 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray2);
        if (dArray2[3] == 0.0) {
            double[] dArray3 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
            Intrinsics.checkNotNull((Object)dArray3);
            d2 = dArray3[4];
        } else {
            d2 = 18.0;
        }
        double ishaAngle = d2;
        double ishaDiff = this.nightPortion(ishaAngle) * nightTime;
        if (Double.isNaN(times[6]) || this.timeDiff(times[4], times[6]) > ishaDiff) {
            times[6] = times[4] + ishaDiff;
        }
        double[] dArray4 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
        Intrinsics.checkNotNull((Object)dArray4);
        if (dArray4[1] == 0.0) {
            double[] dArray5 = this.methodParams.get((Object)this.attribute.getCalculationMethod());
            Intrinsics.checkNotNull((Object)dArray5);
            d = dArray5[2];
        } else {
            d = 4.0;
        }
        double maghribAngle = d;
        double maghribDiff = this.nightPortion(maghribAngle) * nightTime;
        if (Double.isNaN(times[5]) || this.timeDiff(times[4], times[5]) > maghribDiff) {
            times[5] = times[4] + maghribDiff;
        }
        return times;
    }

    private final double nightPortion(double angle) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.attribute.getHigherLatitudeMethod().ordinal()]) {
            case 1 -> angle / 60.0;
            case 2 -> 0.5;
            case 3 -> 0.14286;
            case 4 -> 0.0;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final double[] dayPortion(double[] times) {
        int i = 0;
        int n = times.length;
        while (i < n) {
            int n2 = i++;
            times[n2] = times[n2] / 24.0;
        }
        return times;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HigherLatitudeMethod.values().length];
            try {
                nArray[HigherLatitudeMethod.ANGLE_BASED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HigherLatitudeMethod.MID_NIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HigherLatitudeMethod.ONE_SEVEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HigherLatitudeMethod.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

