/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import dev.kosrat.muslimdata.database.MuslimDataDao;
import dev.kosrat.muslimdata.database.MuslimDataDao_Impl;
import dev.kosrat.muslimdata.database.MuslimDataDatabase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MuslimDataDatabase_Impl
extends MuslimDataDatabase {
    private volatile MuslimDataDao _muslimDataDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(10){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `country` (`_id` INTEGER NOT NULL, `country_code` TEXT NOT NULL, `country_name` TEXT NOT NULL, `country_continent` TEXT NOT NULL, `country_language` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `country_code_index` ON `country` (`country_code`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `city` (`_id` INTEGER NOT NULL, `country_code` TEXT NOT NULL, `city_name` TEXT NOT NULL, `latitude` REAL NOT NULL, `longitude` REAL NOT NULL, `has_fixed_prayer_time` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `city_index` ON `city` (`city_name`)");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `lat_long_index` ON `city` (`latitude`, `longitude`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `prayer_time` (`_id` INTEGER NOT NULL, `country_code` TEXT NOT NULL, `city` TEXT NOT NULL, `date` TEXT NOT NULL, `fajr` TEXT NOT NULL, `sunrise` TEXT NOT NULL, `dhuhr` TEXT NOT NULL, `asr` TEXT NOT NULL, `maghrib` TEXT NOT NULL, `isha` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE INDEX IF NOT EXISTS `prayer_index` ON `prayer_time` (`country_code`, `city`, `date`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `name` (`_id` INTEGER NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `name_translation` (`_id` INTEGER NOT NULL, `name_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_category` (`_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_category_translation` (`_id` INTEGER NOT NULL, `category_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `category_name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_chapter` (`_id` INTEGER NOT NULL, `category_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_chapter_translation` (`_id` INTEGER NOT NULL, `chapter_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `chapter_name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_item` (`_id` INTEGER NOT NULL, `chapter_id` INTEGER NOT NULL, `item` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_item_translation` (`_id` INTEGER NOT NULL, `item_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `item_translation` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_reference` (`_id` INTEGER NOT NULL, `item_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_reference_translation` (`_id` INTEGER NOT NULL, `reference_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `reference` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '2b04b390fb2805f4939ff63976c7bf74')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `country`");
                _db.execSQL("DROP TABLE IF EXISTS `city`");
                _db.execSQL("DROP TABLE IF EXISTS `prayer_time`");
                _db.execSQL("DROP TABLE IF EXISTS `name`");
                _db.execSQL("DROP TABLE IF EXISTS `name_translation`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_category`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_category_translation`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_chapter`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_chapter_translation`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_item`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_item_translation`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_reference`");
                _db.execSQL("DROP TABLE IF EXISTS `azkar_reference_translation`");
                if (MuslimDataDatabase_Impl.this.mCallbacks != null) {
                    int _size = MuslimDataDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MuslimDataDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            public void onCreate(SupportSQLiteDatabase _db) {
                if (MuslimDataDatabase_Impl.this.mCallbacks != null) {
                    int _size = MuslimDataDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MuslimDataDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                MuslimDataDatabase_Impl.this.mDatabase = _db;
                MuslimDataDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (MuslimDataDatabase_Impl.this.mCallbacks != null) {
                    int _size = MuslimDataDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)MuslimDataDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsCountry = new HashMap<String, TableInfo.Column>(5);
                _columnsCountry.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsCountry.put("country_code", new TableInfo.Column("country_code", "TEXT", true, 0, null, 1));
                _columnsCountry.put("country_name", new TableInfo.Column("country_name", "TEXT", true, 0, null, 1));
                _columnsCountry.put("country_continent", new TableInfo.Column("country_continent", "TEXT", true, 0, null, 1));
                _columnsCountry.put("country_language", new TableInfo.Column("country_language", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysCountry = new HashSet(0);
                HashSet<TableInfo.Index> _indicesCountry = new HashSet<TableInfo.Index>(1);
                _indicesCountry.add(new TableInfo.Index("country_code_index", false, Arrays.asList("country_code"), Arrays.asList("ASC")));
                TableInfo _infoCountry = new TableInfo("country", _columnsCountry, _foreignKeysCountry, _indicesCountry);
                TableInfo _existingCountry = TableInfo.read((SupportSQLiteDatabase)_db, (String)"country");
                if (!_infoCountry.equals((Object)_existingCountry)) {
                    return new RoomOpenHelper.ValidationResult(false, "country(dev.kosrat.muslimdata.database.tables.CountryTable).\n Expected:\n" + _infoCountry + "\n Found:\n" + _existingCountry);
                }
                HashMap<String, TableInfo.Column> _columnsCity = new HashMap<String, TableInfo.Column>(6);
                _columnsCity.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsCity.put("country_code", new TableInfo.Column("country_code", "TEXT", true, 0, null, 1));
                _columnsCity.put("city_name", new TableInfo.Column("city_name", "TEXT", true, 0, null, 1));
                _columnsCity.put("latitude", new TableInfo.Column("latitude", "REAL", true, 0, null, 1));
                _columnsCity.put("longitude", new TableInfo.Column("longitude", "REAL", true, 0, null, 1));
                _columnsCity.put("has_fixed_prayer_time", new TableInfo.Column("has_fixed_prayer_time", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysCity = new HashSet(0);
                HashSet<TableInfo.Index> _indicesCity = new HashSet<TableInfo.Index>(2);
                _indicesCity.add(new TableInfo.Index("city_index", false, Arrays.asList("city_name"), Arrays.asList("ASC")));
                _indicesCity.add(new TableInfo.Index("lat_long_index", false, Arrays.asList("latitude", "longitude"), Arrays.asList("ASC", "ASC")));
                TableInfo _infoCity = new TableInfo("city", _columnsCity, _foreignKeysCity, _indicesCity);
                TableInfo _existingCity = TableInfo.read((SupportSQLiteDatabase)_db, (String)"city");
                if (!_infoCity.equals((Object)_existingCity)) {
                    return new RoomOpenHelper.ValidationResult(false, "city(dev.kosrat.muslimdata.database.tables.CityTable).\n Expected:\n" + _infoCity + "\n Found:\n" + _existingCity);
                }
                HashMap<String, TableInfo.Column> _columnsPrayerTime = new HashMap<String, TableInfo.Column>(10);
                _columnsPrayerTime.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsPrayerTime.put("country_code", new TableInfo.Column("country_code", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("city", new TableInfo.Column("city", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("date", new TableInfo.Column("date", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("fajr", new TableInfo.Column("fajr", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("sunrise", new TableInfo.Column("sunrise", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("dhuhr", new TableInfo.Column("dhuhr", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("asr", new TableInfo.Column("asr", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("maghrib", new TableInfo.Column("maghrib", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("isha", new TableInfo.Column("isha", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysPrayerTime = new HashSet(0);
                HashSet<TableInfo.Index> _indicesPrayerTime = new HashSet<TableInfo.Index>(1);
                _indicesPrayerTime.add(new TableInfo.Index("prayer_index", false, Arrays.asList("country_code", "city", "date"), Arrays.asList("ASC", "ASC", "ASC")));
                TableInfo _infoPrayerTime = new TableInfo("prayer_time", _columnsPrayerTime, _foreignKeysPrayerTime, _indicesPrayerTime);
                TableInfo _existingPrayerTime = TableInfo.read((SupportSQLiteDatabase)_db, (String)"prayer_time");
                if (!_infoPrayerTime.equals((Object)_existingPrayerTime)) {
                    return new RoomOpenHelper.ValidationResult(false, "prayer_time(dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime).\n Expected:\n" + _infoPrayerTime + "\n Found:\n" + _existingPrayerTime);
                }
                HashMap<String, TableInfo.Column> _columnsName = new HashMap<String, TableInfo.Column>(2);
                _columnsName.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsName.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysName = new HashSet(0);
                HashSet _indicesName = new HashSet(0);
                TableInfo _infoName = new TableInfo("name", _columnsName, _foreignKeysName, _indicesName);
                TableInfo _existingName = TableInfo.read((SupportSQLiteDatabase)_db, (String)"name");
                if (!_infoName.equals((Object)_existingName)) {
                    return new RoomOpenHelper.ValidationResult(false, "name(dev.kosrat.muslimdata.database.tables.NameTable).\n Expected:\n" + _infoName + "\n Found:\n" + _existingName);
                }
                HashMap<String, TableInfo.Column> _columnsNameTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsNameTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsNameTranslation.put("name_id", new TableInfo.Column("name_id", "INTEGER", true, 0, null, 1));
                _columnsNameTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsNameTranslation.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysNameTranslation = new HashSet(0);
                HashSet _indicesNameTranslation = new HashSet(0);
                TableInfo _infoNameTranslation = new TableInfo("name_translation", _columnsNameTranslation, _foreignKeysNameTranslation, _indicesNameTranslation);
                TableInfo _existingNameTranslation = TableInfo.read((SupportSQLiteDatabase)_db, (String)"name_translation");
                if (!_infoNameTranslation.equals((Object)_existingNameTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "name_translation(dev.kosrat.muslimdata.database.tables.NameTranslationTable).\n Expected:\n" + _infoNameTranslation + "\n Found:\n" + _existingNameTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarCategory = new HashMap<String, TableInfo.Column>(1);
                _columnsAzkarCategory.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysAzkarCategory = new HashSet(0);
                HashSet _indicesAzkarCategory = new HashSet(0);
                TableInfo _infoAzkarCategory = new TableInfo("azkar_category", _columnsAzkarCategory, _foreignKeysAzkarCategory, _indicesAzkarCategory);
                TableInfo _existingAzkarCategory = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_category");
                if (!_infoAzkarCategory.equals((Object)_existingAzkarCategory)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_category(dev.kosrat.muslimdata.database.tables.azkars.AzkarCategoryTable).\n Expected:\n" + _infoAzkarCategory + "\n Found:\n" + _existingAzkarCategory);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarCategoryTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarCategoryTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarCategoryTranslation.put("category_id", new TableInfo.Column("category_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarCategoryTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarCategoryTranslation.put("category_name", new TableInfo.Column("category_name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarCategoryTranslation = new HashSet(0);
                HashSet _indicesAzkarCategoryTranslation = new HashSet(0);
                TableInfo _infoAzkarCategoryTranslation = new TableInfo("azkar_category_translation", _columnsAzkarCategoryTranslation, _foreignKeysAzkarCategoryTranslation, _indicesAzkarCategoryTranslation);
                TableInfo _existingAzkarCategoryTranslation = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_category_translation");
                if (!_infoAzkarCategoryTranslation.equals((Object)_existingAzkarCategoryTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_category_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarCategoryTranslationTable).\n Expected:\n" + _infoAzkarCategoryTranslation + "\n Found:\n" + _existingAzkarCategoryTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarChapter = new HashMap<String, TableInfo.Column>(2);
                _columnsAzkarChapter.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarChapter.put("category_id", new TableInfo.Column("category_id", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysAzkarChapter = new HashSet(0);
                HashSet _indicesAzkarChapter = new HashSet(0);
                TableInfo _infoAzkarChapter = new TableInfo("azkar_chapter", _columnsAzkarChapter, _foreignKeysAzkarChapter, _indicesAzkarChapter);
                TableInfo _existingAzkarChapter = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_chapter");
                if (!_infoAzkarChapter.equals((Object)_existingAzkarChapter)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_chapter(dev.kosrat.muslimdata.database.tables.azkars.AzkarChapterTable).\n Expected:\n" + _infoAzkarChapter + "\n Found:\n" + _existingAzkarChapter);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarChapterTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarChapterTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarChapterTranslation.put("chapter_id", new TableInfo.Column("chapter_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarChapterTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarChapterTranslation.put("chapter_name", new TableInfo.Column("chapter_name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarChapterTranslation = new HashSet(0);
                HashSet _indicesAzkarChapterTranslation = new HashSet(0);
                TableInfo _infoAzkarChapterTranslation = new TableInfo("azkar_chapter_translation", _columnsAzkarChapterTranslation, _foreignKeysAzkarChapterTranslation, _indicesAzkarChapterTranslation);
                TableInfo _existingAzkarChapterTranslation = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_chapter_translation");
                if (!_infoAzkarChapterTranslation.equals((Object)_existingAzkarChapterTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_chapter_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarChapterTranslationTable).\n Expected:\n" + _infoAzkarChapterTranslation + "\n Found:\n" + _existingAzkarChapterTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarItem = new HashMap<String, TableInfo.Column>(3);
                _columnsAzkarItem.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarItem.put("chapter_id", new TableInfo.Column("chapter_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarItem.put("item", new TableInfo.Column("item", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarItem = new HashSet(0);
                HashSet _indicesAzkarItem = new HashSet(0);
                TableInfo _infoAzkarItem = new TableInfo("azkar_item", _columnsAzkarItem, _foreignKeysAzkarItem, _indicesAzkarItem);
                TableInfo _existingAzkarItem = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_item");
                if (!_infoAzkarItem.equals((Object)_existingAzkarItem)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_item(dev.kosrat.muslimdata.database.tables.azkars.AzkarItemTable).\n Expected:\n" + _infoAzkarItem + "\n Found:\n" + _existingAzkarItem);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarItemTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarItemTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarItemTranslation.put("item_id", new TableInfo.Column("item_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarItemTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarItemTranslation.put("item_translation", new TableInfo.Column("item_translation", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarItemTranslation = new HashSet(0);
                HashSet _indicesAzkarItemTranslation = new HashSet(0);
                TableInfo _infoAzkarItemTranslation = new TableInfo("azkar_item_translation", _columnsAzkarItemTranslation, _foreignKeysAzkarItemTranslation, _indicesAzkarItemTranslation);
                TableInfo _existingAzkarItemTranslation = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_item_translation");
                if (!_infoAzkarItemTranslation.equals((Object)_existingAzkarItemTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_item_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarItemTranslationTable).\n Expected:\n" + _infoAzkarItemTranslation + "\n Found:\n" + _existingAzkarItemTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarReference = new HashMap<String, TableInfo.Column>(2);
                _columnsAzkarReference.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarReference.put("item_id", new TableInfo.Column("item_id", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysAzkarReference = new HashSet(0);
                HashSet _indicesAzkarReference = new HashSet(0);
                TableInfo _infoAzkarReference = new TableInfo("azkar_reference", _columnsAzkarReference, _foreignKeysAzkarReference, _indicesAzkarReference);
                TableInfo _existingAzkarReference = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_reference");
                if (!_infoAzkarReference.equals((Object)_existingAzkarReference)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_reference(dev.kosrat.muslimdata.database.tables.azkars.AzkarReferenceTable).\n Expected:\n" + _infoAzkarReference + "\n Found:\n" + _existingAzkarReference);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarReferenceTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarReferenceTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarReferenceTranslation.put("reference_id", new TableInfo.Column("reference_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarReferenceTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarReferenceTranslation.put("reference", new TableInfo.Column("reference", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarReferenceTranslation = new HashSet(0);
                HashSet _indicesAzkarReferenceTranslation = new HashSet(0);
                TableInfo _infoAzkarReferenceTranslation = new TableInfo("azkar_reference_translation", _columnsAzkarReferenceTranslation, _foreignKeysAzkarReferenceTranslation, _indicesAzkarReferenceTranslation);
                TableInfo _existingAzkarReferenceTranslation = TableInfo.read((SupportSQLiteDatabase)_db, (String)"azkar_reference_translation");
                if (!_infoAzkarReferenceTranslation.equals((Object)_existingAzkarReferenceTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_reference_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarReferenceTranslationTable).\n Expected:\n" + _infoAzkarReferenceTranslation + "\n Found:\n" + _existingAzkarReferenceTranslation);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "2b04b390fb2805f4939ff63976c7bf74", "f14299886b5c2723ece30d64e587cb8d");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"country", "city", "prayer_time", "name", "name_translation", "azkar_category", "azkar_category_translation", "azkar_chapter", "azkar_chapter_translation", "azkar_item", "azkar_item_translation", "azkar_reference", "azkar_reference_translation"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `country`");
            _db.execSQL("DELETE FROM `city`");
            _db.execSQL("DELETE FROM `prayer_time`");
            _db.execSQL("DELETE FROM `name`");
            _db.execSQL("DELETE FROM `name_translation`");
            _db.execSQL("DELETE FROM `azkar_category`");
            _db.execSQL("DELETE FROM `azkar_category_translation`");
            _db.execSQL("DELETE FROM `azkar_chapter`");
            _db.execSQL("DELETE FROM `azkar_chapter_translation`");
            _db.execSQL("DELETE FROM `azkar_item`");
            _db.execSQL("DELETE FROM `azkar_item_translation`");
            _db.execSQL("DELETE FROM `azkar_reference`");
            _db.execSQL("DELETE FROM `azkar_reference_translation`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(MuslimDataDao.class, MuslimDataDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuslimDataDao getMuslimDataDao$muslim_data_release() {
        if (this._muslimDataDao != null) {
            return this._muslimDataDao;
        }
        MuslimDataDatabase_Impl muslimDataDatabase_Impl = this;
        synchronized (muslimDataDatabase_Impl) {
            if (this._muslimDataDao == null) {
                this._muslimDataDao = new MuslimDataDao_Impl(this);
            }
            return this._muslimDataDao;
        }
    }
}

