/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import dev.kosrat.muslimdata.database.MuslimDataDao;
import dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime;
import dev.kosrat.muslimdata.models.AzkarCategory;
import dev.kosrat.muslimdata.models.AzkarChapter;
import dev.kosrat.muslimdata.models.AzkarItem;
import dev.kosrat.muslimdata.models.Location;
import dev.kosrat.muslimdata.models.NameOfAllah;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MuslimDataDao_Impl
implements MuslimDataDao {
    private final RoomDatabase __db;

    public MuslimDataDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Location> searchLocation(String city) {
        String _sql = "SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code WHERE city_name like ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code WHERE city_name like ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, city);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<Location> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfCountryCode = false;
                boolean _cursorIndexOfCountryName = true;
                int _cursorIndexOfCityName = 2;
                int _cursorIndexOfLatitude = 3;
                int _cursorIndexOfLongitude = 4;
                int _cursorIndexOfHasFixedPrayerTime = 5;
                ArrayList<Location> _result = new ArrayList<Location>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    String _tmpCountryCode = _cursor.getString(0);
                    String _tmpCountryName = _cursor.getString(1);
                    String _tmpCityName = _cursor.getString(2);
                    double _tmpLatitude = _cursor.getDouble(3);
                    double _tmpLongitude = _cursor.getDouble(4);
                    int _tmp = _cursor.getInt(5);
                    boolean _tmpHasFixedPrayerTime = _tmp != 0;
                    Location _item = new Location(_tmpCountryCode, _tmpCountryName, _tmpCityName, _tmpLatitude, _tmpLongitude, _tmpHasFixedPrayerTime);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location geocoder(String countryCode, String city) {
        String _sql = "SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code WHERE city.country_code= ?  COLLATE NOCASE and city_name= ? COLLATE NOCASE";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code WHERE city.country_code= ?  COLLATE NOCASE and city_name= ? COLLATE NOCASE", (int)2);
        int _argIndex = 1;
        _statement.bindString(_argIndex, countryCode);
        _argIndex = 2;
        _statement.bindString(_argIndex, city);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            Location location;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                Location _result;
                boolean _cursorIndexOfCountryCode = false;
                boolean _cursorIndexOfCountryName = true;
                int _cursorIndexOfCityName = 2;
                int _cursorIndexOfLatitude = 3;
                int _cursorIndexOfLongitude = 4;
                int _cursorIndexOfHasFixedPrayerTime = 5;
                if (_cursor.moveToFirst()) {
                    String _tmpCountryCode = _cursor.getString(0);
                    String _tmpCountryName = _cursor.getString(1);
                    String _tmpCityName = _cursor.getString(2);
                    double _tmpLatitude = _cursor.getDouble(3);
                    double _tmpLongitude = _cursor.getDouble(4);
                    int _tmp = _cursor.getInt(5);
                    boolean _tmpHasFixedPrayerTime = _tmp != 0;
                    _result = new Location(_tmpCountryCode, _tmpCountryName, _tmpCityName, _tmpLatitude, _tmpLongitude, _tmpHasFixedPrayerTime);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                location = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return location;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location reverseGeocoder(double latitude, double longitude) {
        String _sql = "SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code ORDER BY abs(latitude - ?) + abs(longitude - ?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT city.country_code as countryCode, country_name as countryName, city_name as cityName, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime FROM city INNER JOIN country on city.country_code = country.country_code ORDER BY abs(latitude - ?) + abs(longitude - ?) LIMIT 1", (int)2);
        int _argIndex = 1;
        _statement.bindDouble(_argIndex, latitude);
        _argIndex = 2;
        _statement.bindDouble(_argIndex, longitude);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            Location location;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                Location _result;
                boolean _cursorIndexOfCountryCode = false;
                boolean _cursorIndexOfCountryName = true;
                int _cursorIndexOfCityName = 2;
                int _cursorIndexOfLatitude = 3;
                int _cursorIndexOfLongitude = 4;
                int _cursorIndexOfHasFixedPrayerTime = 5;
                if (_cursor.moveToFirst()) {
                    String _tmpCountryCode = _cursor.getString(0);
                    String _tmpCountryName = _cursor.getString(1);
                    String _tmpCityName = _cursor.getString(2);
                    double _tmpLatitude = _cursor.getDouble(3);
                    double _tmpLongitude = _cursor.getDouble(4);
                    int _tmp = _cursor.getInt(5);
                    boolean _tmpHasFixedPrayerTime = _tmp != 0;
                    _result = new Location(_tmpCountryCode, _tmpCountryName, _tmpCityName, _tmpLatitude, _tmpLongitude, _tmpHasFixedPrayerTime);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                location = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return location;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FixedPrayerTime getPrayerTimes(String countryCode, String city, String date) {
        String _sql = "SELECT * FROM prayer_time WHERE city = ? AND country_code = ? AND date = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM prayer_time WHERE city = ? AND country_code = ? AND date = ?", (int)3);
        int _argIndex = 1;
        _statement.bindString(_argIndex, city);
        _argIndex = 2;
        _statement.bindString(_argIndex, countryCode);
        _argIndex = 3;
        _statement.bindString(_argIndex, date);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            FixedPrayerTime _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"country_code");
            int _cursorIndexOfCity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"city");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfFajr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fajr");
            int _cursorIndexOfSunrise = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sunrise");
            int _cursorIndexOfDhuhr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dhuhr");
            int _cursorIndexOfAsr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"asr");
            int _cursorIndexOfMaghrib = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maghrib");
            int _cursorIndexOfIsha = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isha");
            if (_cursor.moveToFirst()) {
                long _tmp_id = _cursor.getLong(_cursorIndexOfId);
                String _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
                String _tmpCity = _cursor.getString(_cursorIndexOfCity);
                String _tmpDate = _cursor.getString(_cursorIndexOfDate);
                String _tmpFajr = _cursor.getString(_cursorIndexOfFajr);
                String _tmpSunrise = _cursor.getString(_cursorIndexOfSunrise);
                String _tmpDhuhr = _cursor.getString(_cursorIndexOfDhuhr);
                String _tmpAsr = _cursor.getString(_cursorIndexOfAsr);
                String _tmpMaghrib = _cursor.getString(_cursorIndexOfMaghrib);
                String _tmpIsha = _cursor.getString(_cursorIndexOfIsha);
                _result = new FixedPrayerTime(_tmp_id, _tmpCountryCode, _tmpCity, _tmpDate, _tmpFajr, _tmpSunrise, _tmpDhuhr, _tmpAsr, _tmpMaghrib, _tmpIsha);
            } else {
                _result = null;
            }
            FixedPrayerTime fixedPrayerTime = _result;
            return fixedPrayerTime;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NameOfAllah> getNames(String language) {
        String _sql = "SELECT name._id AS number, name.name , tr.name AS translation FROM name INNER JOIN name_translation as tr on tr.name_id = name._id and tr.language = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT name._id AS number, name.name , tr.name AS translation FROM name INNER JOIN name_translation as tr on tr.name_id = name._id and tr.language = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<NameOfAllah> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfNumber = false;
                boolean _cursorIndexOfName = true;
                int _cursorIndexOfTranslation = 2;
                ArrayList<NameOfAllah> _result = new ArrayList<NameOfAllah>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpNumber = _cursor.getInt(0);
                    String _tmpName = _cursor.getString(1);
                    String _tmpTranslation = _cursor.getString(2);
                    NameOfAllah _item = new NameOfAllah(_tmpNumber, _tmpName, _tmpTranslation);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarCategory> getAzkarCategories(String language) {
        String _sql = "SELECT category._id AS categoryId, category_name AS categoryName FROM azkar_category AS category INNER JOIN azkar_category_translation as tr on tr.category_id = category._id WHERE language = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT category._id AS categoryId, category_name AS categoryName FROM azkar_category AS category INNER JOIN azkar_category_translation as tr on tr.category_id = category._id WHERE language = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarCategory> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfCategoryId = false;
                boolean _cursorIndexOfCategoryName = true;
                ArrayList<AzkarCategory> _result = new ArrayList<AzkarCategory>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpCategoryId = _cursor.getInt(0);
                    String _tmpCategoryName = _cursor.getString(1);
                    AzkarCategory _item = new AzkarCategory(_tmpCategoryId, _tmpCategoryName);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarChapter> getAzkarChapters(String language, int categoryId) {
        String _sql = "SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation as tr on tr.chapter_id = chapter._id WHERE language = ? and (? = -1 OR category_id = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation as tr on tr.chapter_id = chapter._id WHERE language = ? and (? = -1 OR category_id = ?)", (int)3);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)categoryId);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)categoryId);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarChapter> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfChapterId = false;
                boolean _cursorIndexOfCategoryId = true;
                int _cursorIndexOfChapterName = 2;
                ArrayList<AzkarChapter> _result = new ArrayList<AzkarChapter>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpChapterId = _cursor.getInt(0);
                    int _tmpCategoryId = _cursor.getInt(1);
                    String _tmpChapterName = _cursor.getString(2);
                    AzkarChapter _item = new AzkarChapter(_tmpChapterId, _tmpCategoryId, _tmpChapterName);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarChapter> getAzkarChapters(String language, Integer[] azkarIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation as tr on tr.chapter_id = chapter._id WHERE language = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and chapter._id in (");
        int _inputSize = azkarIds.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        _argIndex = 2;
        Integer[] integerArray = azkarIds;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int _item = integerArray[i];
            _statement.bindLong(_argIndex, (long)_item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarChapter> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfChapterId = false;
                boolean _cursorIndexOfCategoryId = true;
                int _cursorIndexOfChapterName = 2;
                ArrayList<AzkarChapter> _result = new ArrayList<AzkarChapter>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpChapterId = _cursor.getInt(0);
                    int _tmpCategoryId = _cursor.getInt(1);
                    String _tmpChapterName = _cursor.getString(2);
                    AzkarChapter _item_1 = new AzkarChapter(_tmpChapterId, _tmpCategoryId, _tmpChapterName);
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarItem> getAzkarItems(int chapterId, String language) {
        String _sql = "SELECT item._id AS itemId, item.chapter_id AS chapterId, tr.language, item.item, tr.item_translation AS translation, rtr.reference FROM azkar_item as item INNER JOIN azkar_item_translation AS tr ON tr.item_id = item._id INNER JOIN azkar_reference AS ref ON ref.item_id = item._id INNER JOIN azkar_reference_translation AS rtr ON rtr.reference_id = ref._id AND rtr.language = tr.language WHERE chapterId = ? AND tr.language = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT item._id AS itemId, item.chapter_id AS chapterId, tr.language, item.item, tr.item_translation AS translation, rtr.reference FROM azkar_item as item INNER JOIN azkar_item_translation AS tr ON tr.item_id = item._id INNER JOIN azkar_reference AS ref ON ref.item_id = item._id INNER JOIN azkar_reference_translation AS rtr ON rtr.reference_id = ref._id AND rtr.language = tr.language WHERE chapterId = ? AND tr.language = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)chapterId);
        _argIndex = 2;
        _statement.bindString(_argIndex, language);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarItem> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfItemId = false;
                boolean _cursorIndexOfChapterId = true;
                int _cursorIndexOfItem = 3;
                int _cursorIndexOfTranslation = 4;
                int _cursorIndexOfReference = 5;
                ArrayList<AzkarItem> _result = new ArrayList<AzkarItem>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpItemId = _cursor.getInt(0);
                    int _tmpChapterId = _cursor.getInt(1);
                    String _tmpItem = _cursor.getString(3);
                    String _tmpTranslation = _cursor.getString(4);
                    String _tmpReference = _cursor.getString(5);
                    AzkarItem _item = new AzkarItem(_tmpItemId, _tmpChapterId, _tmpItem, _tmpTranslation, _tmpReference);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

