package dev.kosrat.muslimdata.database;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime;
import dev.kosrat.muslimdata.models.AzkarCategory;
import dev.kosrat.muslimdata.models.AzkarChapter;
import dev.kosrat.muslimdata.models.AzkarItem;
import dev.kosrat.muslimdata.models.Location;
import dev.kosrat.muslimdata.models.NameOfAllah;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MuslimDataDao_Impl implements MuslimDataDao {
  private final RoomDatabase __db;

  public MuslimDataDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
  }

  @Override
  public List<Location> searchLocation(final String locationName) {
    final String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE location.name like ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, locationName);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfId = 0;
        final int _cursorIndexOfCountryCode = 1;
        final int _cursorIndexOfCountryName = 2;
        final int _cursorIndexOfName = 3;
        final int _cursorIndexOfLatitude = 4;
        final int _cursorIndexOfLongitude = 5;
        final int _cursorIndexOfHasFixedPrayerTime = 6;
        final int _cursorIndexOfPrayerDependentId = 7;
        final List<Location> _result = new ArrayList<Location>(_cursor.getCount());
        while (_cursor.moveToNext()) {
          final Location _item;
          final int _tmpId;
          _tmpId = _cursor.getInt(_cursorIndexOfId);
          final String _tmpCountryCode;
          _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
          final String _tmpCountryName;
          _tmpCountryName = _cursor.getString(_cursorIndexOfCountryName);
          final String _tmpName;
          _tmpName = _cursor.getString(_cursorIndexOfName);
          final double _tmpLatitude;
          _tmpLatitude = _cursor.getDouble(_cursorIndexOfLatitude);
          final double _tmpLongitude;
          _tmpLongitude = _cursor.getDouble(_cursorIndexOfLongitude);
          final boolean _tmpHasFixedPrayerTime;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfHasFixedPrayerTime);
          _tmpHasFixedPrayerTime = _tmp != 0;
          final Integer _tmpPrayerDependentId;
          if (_cursor.isNull(_cursorIndexOfPrayerDependentId)) {
            _tmpPrayerDependentId = null;
          } else {
            _tmpPrayerDependentId = _cursor.getInt(_cursorIndexOfPrayerDependentId);
          }
          _item = new Location(_tmpId,_tmpName,_tmpLatitude,_tmpLongitude,_tmpCountryCode,_tmpCountryName,_tmpHasFixedPrayerTime,_tmpPrayerDependentId);
          _result.add(_item);
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Location geocoder(final String countryCode, final String locationName) {
    final String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE country.code= ?  COLLATE NOCASE AND location.name= ? COLLATE NOCASE";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindString(_argIndex, countryCode);
    _argIndex = 2;
    _statement.bindString(_argIndex, locationName);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfId = 0;
        final int _cursorIndexOfCountryCode = 1;
        final int _cursorIndexOfCountryName = 2;
        final int _cursorIndexOfName = 3;
        final int _cursorIndexOfLatitude = 4;
        final int _cursorIndexOfLongitude = 5;
        final int _cursorIndexOfHasFixedPrayerTime = 6;
        final int _cursorIndexOfPrayerDependentId = 7;
        final Location _result;
        if (_cursor.moveToFirst()) {
          final int _tmpId;
          _tmpId = _cursor.getInt(_cursorIndexOfId);
          final String _tmpCountryCode;
          _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
          final String _tmpCountryName;
          _tmpCountryName = _cursor.getString(_cursorIndexOfCountryName);
          final String _tmpName;
          _tmpName = _cursor.getString(_cursorIndexOfName);
          final double _tmpLatitude;
          _tmpLatitude = _cursor.getDouble(_cursorIndexOfLatitude);
          final double _tmpLongitude;
          _tmpLongitude = _cursor.getDouble(_cursorIndexOfLongitude);
          final boolean _tmpHasFixedPrayerTime;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfHasFixedPrayerTime);
          _tmpHasFixedPrayerTime = _tmp != 0;
          final Integer _tmpPrayerDependentId;
          if (_cursor.isNull(_cursorIndexOfPrayerDependentId)) {
            _tmpPrayerDependentId = null;
          } else {
            _tmpPrayerDependentId = _cursor.getInt(_cursorIndexOfPrayerDependentId);
          }
          _result = new Location(_tmpId,_tmpName,_tmpLatitude,_tmpLongitude,_tmpCountryCode,_tmpCountryName,_tmpHasFixedPrayerTime,_tmpPrayerDependentId);
        } else {
          _result = null;
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Location reverseGeocoder(final double latitude, final double longitude) {
    final String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id ORDER BY abs(latitude - ?) + abs(longitude - ?) LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindDouble(_argIndex, latitude);
    _argIndex = 2;
    _statement.bindDouble(_argIndex, longitude);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfId = 0;
        final int _cursorIndexOfCountryCode = 1;
        final int _cursorIndexOfCountryName = 2;
        final int _cursorIndexOfName = 3;
        final int _cursorIndexOfLatitude = 4;
        final int _cursorIndexOfLongitude = 5;
        final int _cursorIndexOfHasFixedPrayerTime = 6;
        final int _cursorIndexOfPrayerDependentId = 7;
        final Location _result;
        if (_cursor.moveToFirst()) {
          final int _tmpId;
          _tmpId = _cursor.getInt(_cursorIndexOfId);
          final String _tmpCountryCode;
          _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
          final String _tmpCountryName;
          _tmpCountryName = _cursor.getString(_cursorIndexOfCountryName);
          final String _tmpName;
          _tmpName = _cursor.getString(_cursorIndexOfName);
          final double _tmpLatitude;
          _tmpLatitude = _cursor.getDouble(_cursorIndexOfLatitude);
          final double _tmpLongitude;
          _tmpLongitude = _cursor.getDouble(_cursorIndexOfLongitude);
          final boolean _tmpHasFixedPrayerTime;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfHasFixedPrayerTime);
          _tmpHasFixedPrayerTime = _tmp != 0;
          final Integer _tmpPrayerDependentId;
          if (_cursor.isNull(_cursorIndexOfPrayerDependentId)) {
            _tmpPrayerDependentId = null;
          } else {
            _tmpPrayerDependentId = _cursor.getInt(_cursorIndexOfPrayerDependentId);
          }
          _result = new Location(_tmpId,_tmpName,_tmpLatitude,_tmpLongitude,_tmpCountryCode,_tmpCountryName,_tmpHasFixedPrayerTime,_tmpPrayerDependentId);
        } else {
          _result = null;
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public FixedPrayerTime getPrayerTimes(final int locationId, final String date) {
    final String _sql = "SELECT * FROM prayer_time WHERE location_id = ? AND date = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, locationId);
    _argIndex = 2;
    _statement.bindString(_argIndex, date);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "_id");
      final int _cursorIndexOfLocationId = CursorUtil.getColumnIndexOrThrow(_cursor, "location_id");
      final int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow(_cursor, "date");
      final int _cursorIndexOfFajr = CursorUtil.getColumnIndexOrThrow(_cursor, "fajr");
      final int _cursorIndexOfSunrise = CursorUtil.getColumnIndexOrThrow(_cursor, "sunrise");
      final int _cursorIndexOfDhuhr = CursorUtil.getColumnIndexOrThrow(_cursor, "dhuhr");
      final int _cursorIndexOfAsr = CursorUtil.getColumnIndexOrThrow(_cursor, "asr");
      final int _cursorIndexOfMaghrib = CursorUtil.getColumnIndexOrThrow(_cursor, "maghrib");
      final int _cursorIndexOfIsha = CursorUtil.getColumnIndexOrThrow(_cursor, "isha");
      final FixedPrayerTime _result;
      if (_cursor.moveToFirst()) {
        final long _tmp_id;
        _tmp_id = _cursor.getLong(_cursorIndexOfId);
        final int _tmpLocationId;
        _tmpLocationId = _cursor.getInt(_cursorIndexOfLocationId);
        final String _tmpDate;
        _tmpDate = _cursor.getString(_cursorIndexOfDate);
        final String _tmpFajr;
        _tmpFajr = _cursor.getString(_cursorIndexOfFajr);
        final String _tmpSunrise;
        _tmpSunrise = _cursor.getString(_cursorIndexOfSunrise);
        final String _tmpDhuhr;
        _tmpDhuhr = _cursor.getString(_cursorIndexOfDhuhr);
        final String _tmpAsr;
        _tmpAsr = _cursor.getString(_cursorIndexOfAsr);
        final String _tmpMaghrib;
        _tmpMaghrib = _cursor.getString(_cursorIndexOfMaghrib);
        final String _tmpIsha;
        _tmpIsha = _cursor.getString(_cursorIndexOfIsha);
        _result = new FixedPrayerTime(_tmp_id,_tmpLocationId,_tmpDate,_tmpFajr,_tmpSunrise,_tmpDhuhr,_tmpAsr,_tmpMaghrib,_tmpIsha);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<NameOfAllah> getNames(final String language) {
    final String _sql = "SELECT name._id AS number, name.name , transl.name AS translation FROM name INNER JOIN name_translation AS transl ON transl.name_id = name._id AND transl.language = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, language);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfNumber = 0;
        final int _cursorIndexOfName = 1;
        final int _cursorIndexOfTranslation = 2;
        final List<NameOfAllah> _result = new ArrayList<NameOfAllah>(_cursor.getCount());
        while (_cursor.moveToNext()) {
          final NameOfAllah _item;
          final int _tmpNumber;
          _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
          final String _tmpName;
          _tmpName = _cursor.getString(_cursorIndexOfName);
          final String _tmpTranslation;
          _tmpTranslation = _cursor.getString(_cursorIndexOfTranslation);
          _item = new NameOfAllah(_tmpNumber,_tmpName,_tmpTranslation);
          _result.add(_item);
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<AzkarCategory> getAzkarCategories(final String language) {
    final String _sql = "SELECT category._id AS categoryId, category_name AS categoryName FROM azkar_category AS category INNER JOIN azkar_category_translation AS transl ON transl.category_id = category._id WHERE language = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, language);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfCategoryId = 0;
        final int _cursorIndexOfCategoryName = 1;
        final List<AzkarCategory> _result = new ArrayList<AzkarCategory>(_cursor.getCount());
        while (_cursor.moveToNext()) {
          final AzkarCategory _item;
          final int _tmpCategoryId;
          _tmpCategoryId = _cursor.getInt(_cursorIndexOfCategoryId);
          final String _tmpCategoryName;
          _tmpCategoryName = _cursor.getString(_cursorIndexOfCategoryName);
          _item = new AzkarCategory(_tmpCategoryId,_tmpCategoryName);
          _result.add(_item);
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<AzkarChapter> getAzkarChapters(final String language, final int categoryId) {
    final String _sql = "SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation AS transl ON transl.chapter_id = chapter._id WHERE language = ? AND (? = -1 OR category_id = ?)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindString(_argIndex, language);
    _argIndex = 2;
    _statement.bindLong(_argIndex, categoryId);
    _argIndex = 3;
    _statement.bindLong(_argIndex, categoryId);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfChapterId = 0;
        final int _cursorIndexOfCategoryId = 1;
        final int _cursorIndexOfChapterName = 2;
        final List<AzkarChapter> _result = new ArrayList<AzkarChapter>(_cursor.getCount());
        while (_cursor.moveToNext()) {
          final AzkarChapter _item;
          final int _tmpChapterId;
          _tmpChapterId = _cursor.getInt(_cursorIndexOfChapterId);
          final int _tmpCategoryId;
          _tmpCategoryId = _cursor.getInt(_cursorIndexOfCategoryId);
          final String _tmpChapterName;
          _tmpChapterName = _cursor.getString(_cursorIndexOfChapterName);
          _item = new AzkarChapter(_tmpChapterId,_tmpCategoryId,_tmpChapterName);
          _result.add(_item);
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<AzkarChapter> getAzkarChapters(final String language, final Integer[] chapterIds) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation AS transl ON transl.chapter_id = chapter._id WHERE language = ");
    _stringBuilder.append("?");
    _stringBuilder.append(" AND chapter._id IN (");
    final int _inputSize = chapterIds.length;
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 1 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindString(_argIndex, language);
    _argIndex = 2;
    for (int _item : chapterIds) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfChapterId = 0;
        final int _cursorIndexOfCategoryId = 1;
        final int _cursorIndexOfChapterName = 2;
        final List<AzkarChapter> _result = new ArrayList<AzkarChapter>(_cursor.getCount());
        while (_cursor.moveToNext()) {
          final AzkarChapter _item_1;
          final int _tmpChapterId;
          _tmpChapterId = _cursor.getInt(_cursorIndexOfChapterId);
          final int _tmpCategoryId;
          _tmpCategoryId = _cursor.getInt(_cursorIndexOfCategoryId);
          final String _tmpChapterName;
          _tmpChapterName = _cursor.getString(_cursorIndexOfChapterName);
          _item_1 = new AzkarChapter(_tmpChapterId,_tmpCategoryId,_tmpChapterName);
          _result.add(_item_1);
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<AzkarItem> getAzkarItems(final int chapterId, final String language) {
    final String _sql = "SELECT item._id AS itemId, item.chapter_id AS chapterId, item.item, transl.item_translation AS translation, ref_transl.reference FROM azkar_item AS item INNER JOIN azkar_item_translation AS transl ON transl.item_id = item._id INNER JOIN azkar_reference AS ref ON ref.item_id = item._id INNER JOIN azkar_reference_translation AS ref_transl ON ref_transl.reference_id = ref._id AND ref_transl.language = transl.language WHERE chapterId = ? AND transl.language = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, chapterId);
    _argIndex = 2;
    _statement.bindString(_argIndex, language);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfItemId = 0;
        final int _cursorIndexOfChapterId = 1;
        final int _cursorIndexOfItem = 2;
        final int _cursorIndexOfTranslation = 3;
        final int _cursorIndexOfReference = 4;
        final List<AzkarItem> _result = new ArrayList<AzkarItem>(_cursor.getCount());
        while (_cursor.moveToNext()) {
          final AzkarItem _item;
          final int _tmpItemId;
          _tmpItemId = _cursor.getInt(_cursorIndexOfItemId);
          final int _tmpChapterId;
          _tmpChapterId = _cursor.getInt(_cursorIndexOfChapterId);
          final String _tmpItem;
          _tmpItem = _cursor.getString(_cursorIndexOfItem);
          final String _tmpTranslation;
          _tmpTranslation = _cursor.getString(_cursorIndexOfTranslation);
          final String _tmpReference;
          _tmpReference = _cursor.getString(_cursorIndexOfReference);
          _item = new AzkarItem(_tmpItemId,_tmpChapterId,_tmpItem,_tmpTranslation,_tmpReference);
          _result.add(_item);
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<Location> fixedPrayerTimesList() {
    final String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE has_fixed_prayer_time = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
      try {
        final int _cursorIndexOfId = 0;
        final int _cursorIndexOfCountryCode = 1;
        final int _cursorIndexOfCountryName = 2;
        final int _cursorIndexOfName = 3;
        final int _cursorIndexOfLatitude = 4;
        final int _cursorIndexOfLongitude = 5;
        final int _cursorIndexOfHasFixedPrayerTime = 6;
        final int _cursorIndexOfPrayerDependentId = 7;
        final List<Location> _result = new ArrayList<Location>(_cursor.getCount());
        while (_cursor.moveToNext()) {
          final Location _item;
          final int _tmpId;
          _tmpId = _cursor.getInt(_cursorIndexOfId);
          final String _tmpCountryCode;
          _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
          final String _tmpCountryName;
          _tmpCountryName = _cursor.getString(_cursorIndexOfCountryName);
          final String _tmpName;
          _tmpName = _cursor.getString(_cursorIndexOfName);
          final double _tmpLatitude;
          _tmpLatitude = _cursor.getDouble(_cursorIndexOfLatitude);
          final double _tmpLongitude;
          _tmpLongitude = _cursor.getDouble(_cursorIndexOfLongitude);
          final boolean _tmpHasFixedPrayerTime;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfHasFixedPrayerTime);
          _tmpHasFixedPrayerTime = _tmp != 0;
          final Integer _tmpPrayerDependentId;
          if (_cursor.isNull(_cursorIndexOfPrayerDependentId)) {
            _tmpPrayerDependentId = null;
          } else {
            _tmpPrayerDependentId = _cursor.getInt(_cursorIndexOfPrayerDependentId);
          }
          _item = new Location(_tmpId,_tmpName,_tmpLatitude,_tmpLongitude,_tmpCountryCode,_tmpCountryName,_tmpHasFixedPrayerTime,_tmpPrayerDependentId);
          _result.add(_item);
        }
        __db.setTransactionSuccessful();
        return _result;
      } finally {
        _cursor.close();
        _statement.release();
      }
    } finally {
      __db.endTransaction();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
