package dev.kosrat.muslimdata.database;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MuslimDataDatabase_Impl extends MuslimDataDatabase {
  private volatile MuslimDataDao _muslimDataDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(16) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `country` (`_id` INTEGER NOT NULL, `code` TEXT NOT NULL, `name` TEXT NOT NULL, `continent` TEXT NOT NULL, `language` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE INDEX IF NOT EXISTS `country_index` ON `country` (`code`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `location` (`_id` INTEGER NOT NULL, `country_id` INTEGER NOT NULL, `name` TEXT NOT NULL, `latitude` REAL NOT NULL, `longitude` REAL NOT NULL, `has_fixed_prayer_time` INTEGER NOT NULL DEFAULT 0, `prayer_dependent_id` INTEGER, PRIMARY KEY(`_id`), FOREIGN KEY(`country_id`) REFERENCES `country`(`_id`) ON UPDATE NO ACTION ON DELETE NO ACTION , FOREIGN KEY(`prayer_dependent_id`) REFERENCES `location`(`_id`) ON UPDATE NO ACTION ON DELETE NO ACTION )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `location_country_id_index` ON `location` (`country_id`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `location_prayer_dependent_id_index` ON `location` (`prayer_dependent_id`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `location_name_index` ON `location` (`name`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `location_lat_long_index` ON `location` (`latitude`, `longitude`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `prayer_time` (`_id` INTEGER NOT NULL, `location_id` INTEGER NOT NULL, `date` TEXT NOT NULL, `fajr` TEXT NOT NULL, `sunrise` TEXT NOT NULL, `dhuhr` TEXT NOT NULL, `asr` TEXT NOT NULL, `maghrib` TEXT NOT NULL, `isha` TEXT NOT NULL, PRIMARY KEY(`_id`), FOREIGN KEY(`location_id`) REFERENCES `location`(`_id`) ON UPDATE NO ACTION ON DELETE NO ACTION )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `prayer_index` ON `prayer_time` (`location_id`, `date`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `name` (`_id` INTEGER NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `name_translation` (`_id` INTEGER NOT NULL, `name_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_category` (`_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_category_translation` (`_id` INTEGER NOT NULL, `category_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `category_name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_chapter` (`_id` INTEGER NOT NULL, `category_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_chapter_translation` (`_id` INTEGER NOT NULL, `chapter_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `chapter_name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_item` (`_id` INTEGER NOT NULL, `chapter_id` INTEGER NOT NULL, `item` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_item_translation` (`_id` INTEGER NOT NULL, `item_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `item_translation` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_reference` (`_id` INTEGER NOT NULL, `item_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_reference_translation` (`_id` INTEGER NOT NULL, `reference_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `reference` TEXT NOT NULL, PRIMARY KEY(`_id`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'a0e40451f9b12e79cd31d12d0a0c577e')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `country`");
        db.execSQL("DROP TABLE IF EXISTS `location`");
        db.execSQL("DROP TABLE IF EXISTS `prayer_time`");
        db.execSQL("DROP TABLE IF EXISTS `name`");
        db.execSQL("DROP TABLE IF EXISTS `name_translation`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_category`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_category_translation`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_chapter`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_chapter_translation`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_item`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_item_translation`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_reference`");
        db.execSQL("DROP TABLE IF EXISTS `azkar_reference_translation`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        db.execSQL("PRAGMA foreign_keys = ON");
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsCountry = new HashMap<String, TableInfo.Column>(5);
        _columnsCountry.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCountry.put("code", new TableInfo.Column("code", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCountry.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCountry.put("continent", new TableInfo.Column("continent", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCountry.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCountry = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCountry = new HashSet<TableInfo.Index>(1);
        _indicesCountry.add(new TableInfo.Index("country_index", false, Arrays.asList("code"), Arrays.asList("ASC")));
        final TableInfo _infoCountry = new TableInfo("country", _columnsCountry, _foreignKeysCountry, _indicesCountry);
        final TableInfo _existingCountry = TableInfo.read(db, "country");
        if (!_infoCountry.equals(_existingCountry)) {
          return new RoomOpenHelper.ValidationResult(false, "country(dev.kosrat.muslimdata.database.tables.CountryTable).\n"
                  + " Expected:\n" + _infoCountry + "\n"
                  + " Found:\n" + _existingCountry);
        }
        final HashMap<String, TableInfo.Column> _columnsLocation = new HashMap<String, TableInfo.Column>(7);
        _columnsLocation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLocation.put("country_id", new TableInfo.Column("country_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLocation.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLocation.put("latitude", new TableInfo.Column("latitude", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLocation.put("longitude", new TableInfo.Column("longitude", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLocation.put("has_fixed_prayer_time", new TableInfo.Column("has_fixed_prayer_time", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsLocation.put("prayer_dependent_id", new TableInfo.Column("prayer_dependent_id", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLocation = new HashSet<TableInfo.ForeignKey>(2);
        _foreignKeysLocation.add(new TableInfo.ForeignKey("country", "NO ACTION", "NO ACTION", Arrays.asList("country_id"), Arrays.asList("_id")));
        _foreignKeysLocation.add(new TableInfo.ForeignKey("location", "NO ACTION", "NO ACTION", Arrays.asList("prayer_dependent_id"), Arrays.asList("_id")));
        final HashSet<TableInfo.Index> _indicesLocation = new HashSet<TableInfo.Index>(4);
        _indicesLocation.add(new TableInfo.Index("location_country_id_index", false, Arrays.asList("country_id"), Arrays.asList("ASC")));
        _indicesLocation.add(new TableInfo.Index("location_prayer_dependent_id_index", false, Arrays.asList("prayer_dependent_id"), Arrays.asList("ASC")));
        _indicesLocation.add(new TableInfo.Index("location_name_index", false, Arrays.asList("name"), Arrays.asList("ASC")));
        _indicesLocation.add(new TableInfo.Index("location_lat_long_index", false, Arrays.asList("latitude", "longitude"), Arrays.asList("ASC", "ASC")));
        final TableInfo _infoLocation = new TableInfo("location", _columnsLocation, _foreignKeysLocation, _indicesLocation);
        final TableInfo _existingLocation = TableInfo.read(db, "location");
        if (!_infoLocation.equals(_existingLocation)) {
          return new RoomOpenHelper.ValidationResult(false, "location(dev.kosrat.muslimdata.database.tables.LocationTable).\n"
                  + " Expected:\n" + _infoLocation + "\n"
                  + " Found:\n" + _existingLocation);
        }
        final HashMap<String, TableInfo.Column> _columnsPrayerTime = new HashMap<String, TableInfo.Column>(9);
        _columnsPrayerTime.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("location_id", new TableInfo.Column("location_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("date", new TableInfo.Column("date", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("fajr", new TableInfo.Column("fajr", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("sunrise", new TableInfo.Column("sunrise", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("dhuhr", new TableInfo.Column("dhuhr", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("asr", new TableInfo.Column("asr", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("maghrib", new TableInfo.Column("maghrib", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPrayerTime.put("isha", new TableInfo.Column("isha", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPrayerTime = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysPrayerTime.add(new TableInfo.ForeignKey("location", "NO ACTION", "NO ACTION", Arrays.asList("location_id"), Arrays.asList("_id")));
        final HashSet<TableInfo.Index> _indicesPrayerTime = new HashSet<TableInfo.Index>(1);
        _indicesPrayerTime.add(new TableInfo.Index("prayer_index", false, Arrays.asList("location_id", "date"), Arrays.asList("ASC", "ASC")));
        final TableInfo _infoPrayerTime = new TableInfo("prayer_time", _columnsPrayerTime, _foreignKeysPrayerTime, _indicesPrayerTime);
        final TableInfo _existingPrayerTime = TableInfo.read(db, "prayer_time");
        if (!_infoPrayerTime.equals(_existingPrayerTime)) {
          return new RoomOpenHelper.ValidationResult(false, "prayer_time(dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime).\n"
                  + " Expected:\n" + _infoPrayerTime + "\n"
                  + " Found:\n" + _existingPrayerTime);
        }
        final HashMap<String, TableInfo.Column> _columnsName = new HashMap<String, TableInfo.Column>(2);
        _columnsName.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsName.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysName = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesName = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoName = new TableInfo("name", _columnsName, _foreignKeysName, _indicesName);
        final TableInfo _existingName = TableInfo.read(db, "name");
        if (!_infoName.equals(_existingName)) {
          return new RoomOpenHelper.ValidationResult(false, "name(dev.kosrat.muslimdata.database.tables.NameTable).\n"
                  + " Expected:\n" + _infoName + "\n"
                  + " Found:\n" + _existingName);
        }
        final HashMap<String, TableInfo.Column> _columnsNameTranslation = new HashMap<String, TableInfo.Column>(4);
        _columnsNameTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNameTranslation.put("name_id", new TableInfo.Column("name_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNameTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNameTranslation.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysNameTranslation = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesNameTranslation = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoNameTranslation = new TableInfo("name_translation", _columnsNameTranslation, _foreignKeysNameTranslation, _indicesNameTranslation);
        final TableInfo _existingNameTranslation = TableInfo.read(db, "name_translation");
        if (!_infoNameTranslation.equals(_existingNameTranslation)) {
          return new RoomOpenHelper.ValidationResult(false, "name_translation(dev.kosrat.muslimdata.database.tables.NameTranslationTable).\n"
                  + " Expected:\n" + _infoNameTranslation + "\n"
                  + " Found:\n" + _existingNameTranslation);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarCategory = new HashMap<String, TableInfo.Column>(1);
        _columnsAzkarCategory.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarCategory = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarCategory = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarCategory = new TableInfo("azkar_category", _columnsAzkarCategory, _foreignKeysAzkarCategory, _indicesAzkarCategory);
        final TableInfo _existingAzkarCategory = TableInfo.read(db, "azkar_category");
        if (!_infoAzkarCategory.equals(_existingAzkarCategory)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_category(dev.kosrat.muslimdata.database.tables.azkars.AzkarCategoryTable).\n"
                  + " Expected:\n" + _infoAzkarCategory + "\n"
                  + " Found:\n" + _existingAzkarCategory);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarCategoryTranslation = new HashMap<String, TableInfo.Column>(4);
        _columnsAzkarCategoryTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarCategoryTranslation.put("category_id", new TableInfo.Column("category_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarCategoryTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarCategoryTranslation.put("category_name", new TableInfo.Column("category_name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarCategoryTranslation = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarCategoryTranslation = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarCategoryTranslation = new TableInfo("azkar_category_translation", _columnsAzkarCategoryTranslation, _foreignKeysAzkarCategoryTranslation, _indicesAzkarCategoryTranslation);
        final TableInfo _existingAzkarCategoryTranslation = TableInfo.read(db, "azkar_category_translation");
        if (!_infoAzkarCategoryTranslation.equals(_existingAzkarCategoryTranslation)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_category_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarCategoryTranslationTable).\n"
                  + " Expected:\n" + _infoAzkarCategoryTranslation + "\n"
                  + " Found:\n" + _existingAzkarCategoryTranslation);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarChapter = new HashMap<String, TableInfo.Column>(2);
        _columnsAzkarChapter.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarChapter.put("category_id", new TableInfo.Column("category_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarChapter = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarChapter = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarChapter = new TableInfo("azkar_chapter", _columnsAzkarChapter, _foreignKeysAzkarChapter, _indicesAzkarChapter);
        final TableInfo _existingAzkarChapter = TableInfo.read(db, "azkar_chapter");
        if (!_infoAzkarChapter.equals(_existingAzkarChapter)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_chapter(dev.kosrat.muslimdata.database.tables.azkars.AzkarChapterTable).\n"
                  + " Expected:\n" + _infoAzkarChapter + "\n"
                  + " Found:\n" + _existingAzkarChapter);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarChapterTranslation = new HashMap<String, TableInfo.Column>(4);
        _columnsAzkarChapterTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarChapterTranslation.put("chapter_id", new TableInfo.Column("chapter_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarChapterTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarChapterTranslation.put("chapter_name", new TableInfo.Column("chapter_name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarChapterTranslation = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarChapterTranslation = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarChapterTranslation = new TableInfo("azkar_chapter_translation", _columnsAzkarChapterTranslation, _foreignKeysAzkarChapterTranslation, _indicesAzkarChapterTranslation);
        final TableInfo _existingAzkarChapterTranslation = TableInfo.read(db, "azkar_chapter_translation");
        if (!_infoAzkarChapterTranslation.equals(_existingAzkarChapterTranslation)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_chapter_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarChapterTranslationTable).\n"
                  + " Expected:\n" + _infoAzkarChapterTranslation + "\n"
                  + " Found:\n" + _existingAzkarChapterTranslation);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarItem = new HashMap<String, TableInfo.Column>(3);
        _columnsAzkarItem.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarItem.put("chapter_id", new TableInfo.Column("chapter_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarItem.put("item", new TableInfo.Column("item", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarItem = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarItem = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarItem = new TableInfo("azkar_item", _columnsAzkarItem, _foreignKeysAzkarItem, _indicesAzkarItem);
        final TableInfo _existingAzkarItem = TableInfo.read(db, "azkar_item");
        if (!_infoAzkarItem.equals(_existingAzkarItem)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_item(dev.kosrat.muslimdata.database.tables.azkars.AzkarItemTable).\n"
                  + " Expected:\n" + _infoAzkarItem + "\n"
                  + " Found:\n" + _existingAzkarItem);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarItemTranslation = new HashMap<String, TableInfo.Column>(4);
        _columnsAzkarItemTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarItemTranslation.put("item_id", new TableInfo.Column("item_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarItemTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarItemTranslation.put("item_translation", new TableInfo.Column("item_translation", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarItemTranslation = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarItemTranslation = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarItemTranslation = new TableInfo("azkar_item_translation", _columnsAzkarItemTranslation, _foreignKeysAzkarItemTranslation, _indicesAzkarItemTranslation);
        final TableInfo _existingAzkarItemTranslation = TableInfo.read(db, "azkar_item_translation");
        if (!_infoAzkarItemTranslation.equals(_existingAzkarItemTranslation)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_item_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarItemTranslationTable).\n"
                  + " Expected:\n" + _infoAzkarItemTranslation + "\n"
                  + " Found:\n" + _existingAzkarItemTranslation);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarReference = new HashMap<String, TableInfo.Column>(2);
        _columnsAzkarReference.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarReference.put("item_id", new TableInfo.Column("item_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarReference = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarReference = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarReference = new TableInfo("azkar_reference", _columnsAzkarReference, _foreignKeysAzkarReference, _indicesAzkarReference);
        final TableInfo _existingAzkarReference = TableInfo.read(db, "azkar_reference");
        if (!_infoAzkarReference.equals(_existingAzkarReference)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_reference(dev.kosrat.muslimdata.database.tables.azkars.AzkarReferenceTable).\n"
                  + " Expected:\n" + _infoAzkarReference + "\n"
                  + " Found:\n" + _existingAzkarReference);
        }
        final HashMap<String, TableInfo.Column> _columnsAzkarReferenceTranslation = new HashMap<String, TableInfo.Column>(4);
        _columnsAzkarReferenceTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarReferenceTranslation.put("reference_id", new TableInfo.Column("reference_id", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarReferenceTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAzkarReferenceTranslation.put("reference", new TableInfo.Column("reference", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAzkarReferenceTranslation = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAzkarReferenceTranslation = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAzkarReferenceTranslation = new TableInfo("azkar_reference_translation", _columnsAzkarReferenceTranslation, _foreignKeysAzkarReferenceTranslation, _indicesAzkarReferenceTranslation);
        final TableInfo _existingAzkarReferenceTranslation = TableInfo.read(db, "azkar_reference_translation");
        if (!_infoAzkarReferenceTranslation.equals(_existingAzkarReferenceTranslation)) {
          return new RoomOpenHelper.ValidationResult(false, "azkar_reference_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarReferenceTranslationTable).\n"
                  + " Expected:\n" + _infoAzkarReferenceTranslation + "\n"
                  + " Found:\n" + _existingAzkarReferenceTranslation);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "a0e40451f9b12e79cd31d12d0a0c577e", "753519c062924b15c75d9a8562f416f4");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "country","location","prayer_time","name","name_translation","azkar_category","azkar_category_translation","azkar_chapter","azkar_chapter_translation","azkar_item","azkar_item_translation","azkar_reference","azkar_reference_translation");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    final boolean _supportsDeferForeignKeys = android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP;
    try {
      if (!_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA foreign_keys = FALSE");
      }
      super.beginTransaction();
      if (_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
      }
      _db.execSQL("DELETE FROM `prayer_time`");
      _db.execSQL("DELETE FROM `location`");
      _db.execSQL("DELETE FROM `country`");
      _db.execSQL("DELETE FROM `name`");
      _db.execSQL("DELETE FROM `name_translation`");
      _db.execSQL("DELETE FROM `azkar_category`");
      _db.execSQL("DELETE FROM `azkar_category_translation`");
      _db.execSQL("DELETE FROM `azkar_chapter`");
      _db.execSQL("DELETE FROM `azkar_chapter_translation`");
      _db.execSQL("DELETE FROM `azkar_item`");
      _db.execSQL("DELETE FROM `azkar_item_translation`");
      _db.execSQL("DELETE FROM `azkar_reference`");
      _db.execSQL("DELETE FROM `azkar_reference_translation`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      if (!_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA foreign_keys = TRUE");
      }
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(MuslimDataDao.class, MuslimDataDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public MuslimDataDao getMuslimDataDao$muslim_data_release() {
    if (_muslimDataDao != null) {
      return _muslimDataDao;
    } else {
      synchronized(this) {
        if(_muslimDataDao == null) {
          _muslimDataDao = new MuslimDataDao_Impl(this);
        }
        return _muslimDataDao;
      }
    }
  }
}
