/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import dev.kosrat.muslimdata.database.MuslimDataDao;
import dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime;
import dev.kosrat.muslimdata.models.AzkarCategory;
import dev.kosrat.muslimdata.models.AzkarChapter;
import dev.kosrat.muslimdata.models.AzkarItem;
import dev.kosrat.muslimdata.models.Location;
import dev.kosrat.muslimdata.models.NameOfAllah;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MuslimDataDao_Impl
implements MuslimDataDao {
    private final RoomDatabase __db;

    public MuslimDataDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Location> searchLocation(String locationName) {
        String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE location.name like ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE location.name like ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, locationName);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<Location> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfCountryCode = true;
                int _cursorIndexOfCountryName = 2;
                int _cursorIndexOfName = 3;
                int _cursorIndexOfLatitude = 4;
                int _cursorIndexOfLongitude = 5;
                int _cursorIndexOfHasFixedPrayerTime = 6;
                int _cursorIndexOfPrayerDependentId = 7;
                ArrayList<Location> _result = new ArrayList<Location>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpId = _cursor.getInt(0);
                    String _tmpCountryCode = _cursor.getString(1);
                    String _tmpCountryName = _cursor.getString(2);
                    String _tmpName = _cursor.getString(3);
                    double _tmpLatitude = _cursor.getDouble(4);
                    double _tmpLongitude = _cursor.getDouble(5);
                    int _tmp = _cursor.getInt(6);
                    boolean _tmpHasFixedPrayerTime = _tmp != 0;
                    Integer _tmpPrayerDependentId = _cursor.isNull(7) ? null : Integer.valueOf(_cursor.getInt(7));
                    Location _item = new Location(_tmpId, _tmpName, _tmpLatitude, _tmpLongitude, _tmpCountryCode, _tmpCountryName, _tmpHasFixedPrayerTime, _tmpPrayerDependentId);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location geocoder(String countryCode, String locationName) {
        String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE country.code= ?  COLLATE NOCASE AND location.name= ? COLLATE NOCASE";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE country.code= ?  COLLATE NOCASE AND location.name= ? COLLATE NOCASE", (int)2);
        int _argIndex = 1;
        _statement.bindString(_argIndex, countryCode);
        _argIndex = 2;
        _statement.bindString(_argIndex, locationName);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            Location location;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                Location _result;
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfCountryCode = true;
                int _cursorIndexOfCountryName = 2;
                int _cursorIndexOfName = 3;
                int _cursorIndexOfLatitude = 4;
                int _cursorIndexOfLongitude = 5;
                int _cursorIndexOfHasFixedPrayerTime = 6;
                int _cursorIndexOfPrayerDependentId = 7;
                if (_cursor.moveToFirst()) {
                    int _tmpId = _cursor.getInt(0);
                    String _tmpCountryCode = _cursor.getString(1);
                    String _tmpCountryName = _cursor.getString(2);
                    String _tmpName = _cursor.getString(3);
                    double _tmpLatitude = _cursor.getDouble(4);
                    double _tmpLongitude = _cursor.getDouble(5);
                    int _tmp = _cursor.getInt(6);
                    boolean _tmpHasFixedPrayerTime = _tmp != 0;
                    Integer _tmpPrayerDependentId = _cursor.isNull(7) ? null : Integer.valueOf(_cursor.getInt(7));
                    _result = new Location(_tmpId, _tmpName, _tmpLatitude, _tmpLongitude, _tmpCountryCode, _tmpCountryName, _tmpHasFixedPrayerTime, _tmpPrayerDependentId);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                location = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return location;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location reverseGeocoder(double latitude, double longitude) {
        String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id ORDER BY abs(latitude - ?) + abs(longitude - ?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id ORDER BY abs(latitude - ?) + abs(longitude - ?) LIMIT 1", (int)2);
        int _argIndex = 1;
        _statement.bindDouble(_argIndex, latitude);
        _argIndex = 2;
        _statement.bindDouble(_argIndex, longitude);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            Location location;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                Location _result;
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfCountryCode = true;
                int _cursorIndexOfCountryName = 2;
                int _cursorIndexOfName = 3;
                int _cursorIndexOfLatitude = 4;
                int _cursorIndexOfLongitude = 5;
                int _cursorIndexOfHasFixedPrayerTime = 6;
                int _cursorIndexOfPrayerDependentId = 7;
                if (_cursor.moveToFirst()) {
                    int _tmpId = _cursor.getInt(0);
                    String _tmpCountryCode = _cursor.getString(1);
                    String _tmpCountryName = _cursor.getString(2);
                    String _tmpName = _cursor.getString(3);
                    double _tmpLatitude = _cursor.getDouble(4);
                    double _tmpLongitude = _cursor.getDouble(5);
                    int _tmp = _cursor.getInt(6);
                    boolean _tmpHasFixedPrayerTime = _tmp != 0;
                    Integer _tmpPrayerDependentId = _cursor.isNull(7) ? null : Integer.valueOf(_cursor.getInt(7));
                    _result = new Location(_tmpId, _tmpName, _tmpLatitude, _tmpLongitude, _tmpCountryCode, _tmpCountryName, _tmpHasFixedPrayerTime, _tmpPrayerDependentId);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                location = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return location;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FixedPrayerTime getPrayerTimes(int locationId, String date) {
        String _sql = "SELECT * FROM prayer_time WHERE location_id = ? AND date = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM prayer_time WHERE location_id = ? AND date = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)locationId);
        _argIndex = 2;
        _statement.bindString(_argIndex, date);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            FixedPrayerTime _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfLocationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"location_id");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfFajr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fajr");
            int _cursorIndexOfSunrise = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sunrise");
            int _cursorIndexOfDhuhr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dhuhr");
            int _cursorIndexOfAsr = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"asr");
            int _cursorIndexOfMaghrib = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maghrib");
            int _cursorIndexOfIsha = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isha");
            if (_cursor.moveToFirst()) {
                long _tmp_id = _cursor.getLong(_cursorIndexOfId);
                int _tmpLocationId = _cursor.getInt(_cursorIndexOfLocationId);
                String _tmpDate = _cursor.getString(_cursorIndexOfDate);
                String _tmpFajr = _cursor.getString(_cursorIndexOfFajr);
                String _tmpSunrise = _cursor.getString(_cursorIndexOfSunrise);
                String _tmpDhuhr = _cursor.getString(_cursorIndexOfDhuhr);
                String _tmpAsr = _cursor.getString(_cursorIndexOfAsr);
                String _tmpMaghrib = _cursor.getString(_cursorIndexOfMaghrib);
                String _tmpIsha = _cursor.getString(_cursorIndexOfIsha);
                _result = new FixedPrayerTime(_tmp_id, _tmpLocationId, _tmpDate, _tmpFajr, _tmpSunrise, _tmpDhuhr, _tmpAsr, _tmpMaghrib, _tmpIsha);
            } else {
                _result = null;
            }
            FixedPrayerTime fixedPrayerTime = _result;
            return fixedPrayerTime;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NameOfAllah> getNames(String language) {
        String _sql = "SELECT name._id AS number, name.name , transl.name AS translation FROM name INNER JOIN name_translation AS transl ON transl.name_id = name._id AND transl.language = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT name._id AS number, name.name , transl.name AS translation FROM name INNER JOIN name_translation AS transl ON transl.name_id = name._id AND transl.language = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<NameOfAllah> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfNumber = false;
                boolean _cursorIndexOfName = true;
                int _cursorIndexOfTranslation = 2;
                ArrayList<NameOfAllah> _result = new ArrayList<NameOfAllah>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpNumber = _cursor.getInt(0);
                    String _tmpName = _cursor.getString(1);
                    String _tmpTranslation = _cursor.getString(2);
                    NameOfAllah _item = new NameOfAllah(_tmpNumber, _tmpName, _tmpTranslation);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarCategory> getAzkarCategories(String language) {
        String _sql = "SELECT category._id AS categoryId, category_name AS categoryName FROM azkar_category AS category INNER JOIN azkar_category_translation AS transl ON transl.category_id = category._id WHERE language = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT category._id AS categoryId, category_name AS categoryName FROM azkar_category AS category INNER JOIN azkar_category_translation AS transl ON transl.category_id = category._id WHERE language = ?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarCategory> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfCategoryId = false;
                boolean _cursorIndexOfCategoryName = true;
                ArrayList<AzkarCategory> _result = new ArrayList<AzkarCategory>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpCategoryId = _cursor.getInt(0);
                    String _tmpCategoryName = _cursor.getString(1);
                    AzkarCategory _item = new AzkarCategory(_tmpCategoryId, _tmpCategoryName);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarChapter> getAzkarChapters(String language, int categoryId) {
        String _sql = "SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation AS transl ON transl.chapter_id = chapter._id WHERE language = ? AND (? = -1 OR category_id = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation AS transl ON transl.chapter_id = chapter._id WHERE language = ? AND (? = -1 OR category_id = ?)", (int)3);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)categoryId);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)categoryId);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarChapter> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfChapterId = false;
                boolean _cursorIndexOfCategoryId = true;
                int _cursorIndexOfChapterName = 2;
                ArrayList<AzkarChapter> _result = new ArrayList<AzkarChapter>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpChapterId = _cursor.getInt(0);
                    int _tmpCategoryId = _cursor.getInt(1);
                    String _tmpChapterName = _cursor.getString(2);
                    AzkarChapter _item = new AzkarChapter(_tmpChapterId, _tmpCategoryId, _tmpChapterName);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarChapter> getAzkarChapters(String language, Integer[] chapterIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation AS transl ON transl.chapter_id = chapter._id WHERE language = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" AND chapter._id IN (");
        int _inputSize = chapterIds.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindString(_argIndex, language);
        _argIndex = 2;
        Integer[] integerArray = chapterIds;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int _item = integerArray[i];
            _statement.bindLong(_argIndex, (long)_item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarChapter> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfChapterId = false;
                boolean _cursorIndexOfCategoryId = true;
                int _cursorIndexOfChapterName = 2;
                ArrayList<AzkarChapter> _result = new ArrayList<AzkarChapter>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpChapterId = _cursor.getInt(0);
                    int _tmpCategoryId = _cursor.getInt(1);
                    String _tmpChapterName = _cursor.getString(2);
                    AzkarChapter _item_1 = new AzkarChapter(_tmpChapterId, _tmpCategoryId, _tmpChapterName);
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AzkarItem> getAzkarItems(int chapterId, String language) {
        String _sql = "SELECT item._id AS itemId, item.chapter_id AS chapterId, item.item, transl.item_translation AS translation, ref_transl.reference FROM azkar_item AS item INNER JOIN azkar_item_translation AS transl ON transl.item_id = item._id INNER JOIN azkar_reference AS ref ON ref.item_id = item._id INNER JOIN azkar_reference_translation AS ref_transl ON ref_transl.reference_id = ref._id AND ref_transl.language = transl.language WHERE chapterId = ? AND transl.language = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT item._id AS itemId, item.chapter_id AS chapterId, item.item, transl.item_translation AS translation, ref_transl.reference FROM azkar_item AS item INNER JOIN azkar_item_translation AS transl ON transl.item_id = item._id INNER JOIN azkar_reference AS ref ON ref.item_id = item._id INNER JOIN azkar_reference_translation AS ref_transl ON ref_transl.reference_id = ref._id AND ref_transl.language = transl.language WHERE chapterId = ? AND transl.language = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)chapterId);
        _argIndex = 2;
        _statement.bindString(_argIndex, language);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<AzkarItem> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfItemId = false;
                boolean _cursorIndexOfChapterId = true;
                int _cursorIndexOfItem = 2;
                int _cursorIndexOfTranslation = 3;
                int _cursorIndexOfReference = 4;
                ArrayList<AzkarItem> _result = new ArrayList<AzkarItem>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpItemId = _cursor.getInt(0);
                    int _tmpChapterId = _cursor.getInt(1);
                    String _tmpItem = _cursor.getString(2);
                    String _tmpTranslation = _cursor.getString(3);
                    String _tmpReference = _cursor.getString(4);
                    AzkarItem _item = new AzkarItem(_tmpItemId, _tmpChapterId, _tmpItem, _tmpTranslation, _tmpReference);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Location> fixedPrayerTimesList() {
        String _sql = "SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE has_fixed_prayer_time = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE has_fixed_prayer_time = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<Location> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
            try {
                boolean _cursorIndexOfId = false;
                boolean _cursorIndexOfCountryCode = true;
                int _cursorIndexOfCountryName = 2;
                int _cursorIndexOfName = 3;
                int _cursorIndexOfLatitude = 4;
                int _cursorIndexOfLongitude = 5;
                int _cursorIndexOfHasFixedPrayerTime = 6;
                int _cursorIndexOfPrayerDependentId = 7;
                ArrayList<Location> _result = new ArrayList<Location>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    int _tmpId = _cursor.getInt(0);
                    String _tmpCountryCode = _cursor.getString(1);
                    String _tmpCountryName = _cursor.getString(2);
                    String _tmpName = _cursor.getString(3);
                    double _tmpLatitude = _cursor.getDouble(4);
                    double _tmpLongitude = _cursor.getDouble(5);
                    int _tmp = _cursor.getInt(6);
                    boolean _tmpHasFixedPrayerTime = _tmp != 0;
                    Integer _tmpPrayerDependentId = _cursor.isNull(7) ? null : Integer.valueOf(_cursor.getInt(7));
                    Location _item = new Location(_tmpId, _tmpName, _tmpLatitude, _tmpLongitude, _tmpCountryCode, _tmpCountryName, _tmpHasFixedPrayerTime, _tmpPrayerDependentId);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

