/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database.tables;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import dev.kosrat.muslimdata.database.tables.CountryTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001e\b\u0081\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJV\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010%J\u0013\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001J\t\u0010)\u001a\u00020\u0007H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\r\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Ldev/kosrat/muslimdata/database/tables/LocationTable;", "", "_id", "", "countryId", "", "name", "", "latitude", "", "longitude", "hasFixedPrayerTime", "", "prayerDependentId", "(JILjava/lang/String;DDZLjava/lang/Integer;)V", "get_id", "()J", "getCountryId", "()I", "getHasFixedPrayerTime", "()Z", "getLatitude", "()D", "getLongitude", "getName", "()Ljava/lang/String;", "getPrayerDependentId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(JILjava/lang/String;DDZLjava/lang/Integer;)Ldev/kosrat/muslimdata/database/tables/LocationTable;", "equals", "other", "hashCode", "toString", "muslim-data_release"})
@Entity(tableName="location", indices={@Index(value={"country_id"}, name="location_country_id_index"), @Index(value={"prayer_dependent_id"}, name="location_prayer_dependent_id_index"), @Index(value={"name"}, name="location_name_index"), @Index(value={"latitude", "longitude"}, name="location_lat_long_index")}, foreignKeys={@ForeignKey(entity=CountryTable.class, parentColumns={"_id"}, childColumns={"country_id"}), @ForeignKey(entity=LocationTable.class, parentColumns={"_id"}, childColumns={"prayer_dependent_id"})})
public final class LocationTable {
    @PrimaryKey
    private final long _id;
    @ColumnInfo(name="country_id")
    private final int countryId;
    @NotNull
    private final String name;
    private final double latitude;
    private final double longitude;
    @ColumnInfo(name="has_fixed_prayer_time", defaultValue="0")
    private final boolean hasFixedPrayerTime;
    @ColumnInfo(name="prayer_dependent_id")
    @Nullable
    private final Integer prayerDependentId;

    public LocationTable(long _id, int countryId, @NotNull String name, double latitude, double longitude, boolean hasFixedPrayerTime, @Nullable Integer prayerDependentId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this._id = _id;
        this.countryId = countryId;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.hasFixedPrayerTime = hasFixedPrayerTime;
        this.prayerDependentId = prayerDependentId;
    }

    public final long get_id() {
        return this._id;
    }

    public final int getCountryId() {
        return this.countryId;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final boolean getHasFixedPrayerTime() {
        return this.hasFixedPrayerTime;
    }

    @Nullable
    public final Integer getPrayerDependentId() {
        return this.prayerDependentId;
    }

    public final long component1() {
        return this._id;
    }

    public final int component2() {
        return this.countryId;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    public final double component4() {
        return this.latitude;
    }

    public final double component5() {
        return this.longitude;
    }

    public final boolean component6() {
        return this.hasFixedPrayerTime;
    }

    @Nullable
    public final Integer component7() {
        return this.prayerDependentId;
    }

    @NotNull
    public final LocationTable copy(long _id, int countryId, @NotNull String name, double latitude, double longitude, boolean hasFixedPrayerTime, @Nullable Integer prayerDependentId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new LocationTable(_id, countryId, name, latitude, longitude, hasFixedPrayerTime, prayerDependentId);
    }

    public static /* synthetic */ LocationTable copy$default(LocationTable locationTable, long l, int n, String string, double d, double d2, boolean bl, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            l = locationTable._id;
        }
        if ((n3 & 2) != 0) {
            n = locationTable.countryId;
        }
        if ((n3 & 4) != 0) {
            string = locationTable.name;
        }
        if ((n3 & 8) != 0) {
            d = locationTable.latitude;
        }
        if ((n3 & 0x10) != 0) {
            d2 = locationTable.longitude;
        }
        if ((n3 & 0x20) != 0) {
            bl = locationTable.hasFixedPrayerTime;
        }
        if ((n3 & 0x40) != 0) {
            n2 = locationTable.prayerDependentId;
        }
        return locationTable.copy(l, n, string, d, d2, bl, n2);
    }

    @NotNull
    public String toString() {
        return "LocationTable(_id=" + this._id + ", countryId=" + this.countryId + ", name=" + this.name + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", hasFixedPrayerTime=" + this.hasFixedPrayerTime + ", prayerDependentId=" + this.prayerDependentId + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this._id);
        result = result * 31 + Integer.hashCode(this.countryId);
        result = result * 31 + this.name.hashCode();
        result = result * 31 + Double.hashCode(this.latitude);
        result = result * 31 + Double.hashCode(this.longitude);
        result = result * 31 + Boolean.hashCode(this.hasFixedPrayerTime);
        result = result * 31 + (this.prayerDependentId == null ? 0 : ((Object)this.prayerDependentId).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocationTable)) {
            return false;
        }
        LocationTable locationTable = (LocationTable)other;
        if (this._id != locationTable._id) {
            return false;
        }
        if (this.countryId != locationTable.countryId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)locationTable.name)) {
            return false;
        }
        if (Double.compare(this.latitude, locationTable.latitude) != 0) {
            return false;
        }
        if (Double.compare(this.longitude, locationTable.longitude) != 0) {
            return false;
        }
        if (this.hasFixedPrayerTime != locationTable.hasFixedPrayerTime) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.prayerDependentId, (Object)locationTable.prayerDependentId);
    }
}

