/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import dev.kosrat.muslimdata.database.MuslimDataDao;
import dev.kosrat.muslimdata.database.MuslimDataDao_Impl;
import dev.kosrat.muslimdata.database.MuslimDataDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MuslimDataDatabase_Impl
extends MuslimDataDatabase {
    private volatile MuslimDataDao _muslimDataDao;

    @NonNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NonNull DatabaseConfiguration config) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(17){

            public void createAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("CREATE TABLE IF NOT EXISTS `country` (`_id` INTEGER NOT NULL, `code` TEXT NOT NULL, `name` TEXT NOT NULL, `continent` TEXT NOT NULL, `language` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE INDEX IF NOT EXISTS `country_index` ON `country` (`code`)");
                db.execSQL("CREATE TABLE IF NOT EXISTS `location` (`_id` INTEGER NOT NULL, `country_id` INTEGER NOT NULL, `name` TEXT NOT NULL, `latitude` REAL NOT NULL, `longitude` REAL NOT NULL, `has_fixed_prayer_time` INTEGER NOT NULL DEFAULT 0, `prayer_dependent_id` INTEGER, PRIMARY KEY(`_id`), FOREIGN KEY(`country_id`) REFERENCES `country`(`_id`) ON UPDATE NO ACTION ON DELETE NO ACTION , FOREIGN KEY(`prayer_dependent_id`) REFERENCES `location`(`_id`) ON UPDATE NO ACTION ON DELETE NO ACTION )");
                db.execSQL("CREATE INDEX IF NOT EXISTS `location_country_id_index` ON `location` (`country_id`)");
                db.execSQL("CREATE INDEX IF NOT EXISTS `location_prayer_dependent_id_index` ON `location` (`prayer_dependent_id`)");
                db.execSQL("CREATE INDEX IF NOT EXISTS `location_name_index` ON `location` (`name`)");
                db.execSQL("CREATE INDEX IF NOT EXISTS `location_lat_long_index` ON `location` (`latitude`, `longitude`)");
                db.execSQL("CREATE TABLE IF NOT EXISTS `prayer_time` (`_id` INTEGER NOT NULL, `location_id` INTEGER NOT NULL, `date` TEXT NOT NULL, `fajr` TEXT NOT NULL, `sunrise` TEXT NOT NULL, `dhuhr` TEXT NOT NULL, `asr` TEXT NOT NULL, `maghrib` TEXT NOT NULL, `isha` TEXT NOT NULL, PRIMARY KEY(`_id`), FOREIGN KEY(`location_id`) REFERENCES `location`(`_id`) ON UPDATE NO ACTION ON DELETE NO ACTION )");
                db.execSQL("CREATE INDEX IF NOT EXISTS `prayer_index` ON `prayer_time` (`location_id`, `date`)");
                db.execSQL("CREATE TABLE IF NOT EXISTS `name` (`_id` INTEGER NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `name_translation` (`_id` INTEGER NOT NULL, `name_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_category` (`_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_category_translation` (`_id` INTEGER NOT NULL, `category_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `category_name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_chapter` (`_id` INTEGER NOT NULL, `category_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_chapter_translation` (`_id` INTEGER NOT NULL, `chapter_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `chapter_name` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_item` (`_id` INTEGER NOT NULL, `chapter_id` INTEGER NOT NULL, `item` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_item_translation` (`_id` INTEGER NOT NULL, `item_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `item_translation` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_reference` (`_id` INTEGER NOT NULL, `item_id` INTEGER NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS `azkar_reference_translation` (`_id` INTEGER NOT NULL, `reference_id` INTEGER NOT NULL, `language` TEXT NOT NULL, `reference` TEXT NOT NULL, PRIMARY KEY(`_id`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'a0e40451f9b12e79cd31d12d0a0c577e')");
            }

            public void dropAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("DROP TABLE IF EXISTS `country`");
                db.execSQL("DROP TABLE IF EXISTS `location`");
                db.execSQL("DROP TABLE IF EXISTS `prayer_time`");
                db.execSQL("DROP TABLE IF EXISTS `name`");
                db.execSQL("DROP TABLE IF EXISTS `name_translation`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_category`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_category_translation`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_chapter`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_chapter_translation`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_item`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_item_translation`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_reference`");
                db.execSQL("DROP TABLE IF EXISTS `azkar_reference_translation`");
                List _callbacks = MuslimDataDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onDestructiveMigration(db);
                    }
                }
            }

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                List _callbacks = MuslimDataDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onCreate(db);
                    }
                }
            }

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                MuslimDataDatabase_Impl.this.mDatabase = db;
                db.execSQL("PRAGMA foreign_keys = ON");
                MuslimDataDatabase_Impl.this.internalInitInvalidationTracker(db);
                List _callbacks = MuslimDataDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onOpen(db);
                    }
                }
            }

            public void onPreMigrate(@NonNull SupportSQLiteDatabase db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)db);
            }

            public void onPostMigrate(@NonNull SupportSQLiteDatabase db) {
            }

            @NonNull
            public RoomOpenHelper.ValidationResult onValidateSchema(@NonNull SupportSQLiteDatabase db) {
                HashMap<String, TableInfo.Column> _columnsCountry = new HashMap<String, TableInfo.Column>(5);
                _columnsCountry.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsCountry.put("code", new TableInfo.Column("code", "TEXT", true, 0, null, 1));
                _columnsCountry.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsCountry.put("continent", new TableInfo.Column("continent", "TEXT", true, 0, null, 1));
                _columnsCountry.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysCountry = new HashSet(0);
                HashSet<TableInfo.Index> _indicesCountry = new HashSet<TableInfo.Index>(1);
                _indicesCountry.add(new TableInfo.Index("country_index", false, Arrays.asList("code"), Arrays.asList("ASC")));
                TableInfo _infoCountry = new TableInfo("country", _columnsCountry, _foreignKeysCountry, _indicesCountry);
                TableInfo _existingCountry = TableInfo.read((SupportSQLiteDatabase)db, (String)"country");
                if (!_infoCountry.equals((Object)_existingCountry)) {
                    return new RoomOpenHelper.ValidationResult(false, "country(dev.kosrat.muslimdata.database.tables.CountryTable).\n Expected:\n" + _infoCountry + "\n Found:\n" + _existingCountry);
                }
                HashMap<String, TableInfo.Column> _columnsLocation = new HashMap<String, TableInfo.Column>(7);
                _columnsLocation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsLocation.put("country_id", new TableInfo.Column("country_id", "INTEGER", true, 0, null, 1));
                _columnsLocation.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsLocation.put("latitude", new TableInfo.Column("latitude", "REAL", true, 0, null, 1));
                _columnsLocation.put("longitude", new TableInfo.Column("longitude", "REAL", true, 0, null, 1));
                _columnsLocation.put("has_fixed_prayer_time", new TableInfo.Column("has_fixed_prayer_time", "INTEGER", true, 0, "0", 1));
                _columnsLocation.put("prayer_dependent_id", new TableInfo.Column("prayer_dependent_id", "INTEGER", false, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysLocation = new HashSet<TableInfo.ForeignKey>(2);
                _foreignKeysLocation.add(new TableInfo.ForeignKey("country", "NO ACTION", "NO ACTION", Arrays.asList("country_id"), Arrays.asList("_id")));
                _foreignKeysLocation.add(new TableInfo.ForeignKey("location", "NO ACTION", "NO ACTION", Arrays.asList("prayer_dependent_id"), Arrays.asList("_id")));
                HashSet<TableInfo.Index> _indicesLocation = new HashSet<TableInfo.Index>(4);
                _indicesLocation.add(new TableInfo.Index("location_country_id_index", false, Arrays.asList("country_id"), Arrays.asList("ASC")));
                _indicesLocation.add(new TableInfo.Index("location_prayer_dependent_id_index", false, Arrays.asList("prayer_dependent_id"), Arrays.asList("ASC")));
                _indicesLocation.add(new TableInfo.Index("location_name_index", false, Arrays.asList("name"), Arrays.asList("ASC")));
                _indicesLocation.add(new TableInfo.Index("location_lat_long_index", false, Arrays.asList("latitude", "longitude"), Arrays.asList("ASC", "ASC")));
                TableInfo _infoLocation = new TableInfo("location", _columnsLocation, _foreignKeysLocation, _indicesLocation);
                TableInfo _existingLocation = TableInfo.read((SupportSQLiteDatabase)db, (String)"location");
                if (!_infoLocation.equals((Object)_existingLocation)) {
                    return new RoomOpenHelper.ValidationResult(false, "location(dev.kosrat.muslimdata.database.tables.LocationTable).\n Expected:\n" + _infoLocation + "\n Found:\n" + _existingLocation);
                }
                HashMap<String, TableInfo.Column> _columnsPrayerTime = new HashMap<String, TableInfo.Column>(9);
                _columnsPrayerTime.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsPrayerTime.put("location_id", new TableInfo.Column("location_id", "INTEGER", true, 0, null, 1));
                _columnsPrayerTime.put("date", new TableInfo.Column("date", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("fajr", new TableInfo.Column("fajr", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("sunrise", new TableInfo.Column("sunrise", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("dhuhr", new TableInfo.Column("dhuhr", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("asr", new TableInfo.Column("asr", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("maghrib", new TableInfo.Column("maghrib", "TEXT", true, 0, null, 1));
                _columnsPrayerTime.put("isha", new TableInfo.Column("isha", "TEXT", true, 0, null, 1));
                HashSet<TableInfo.ForeignKey> _foreignKeysPrayerTime = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysPrayerTime.add(new TableInfo.ForeignKey("location", "NO ACTION", "NO ACTION", Arrays.asList("location_id"), Arrays.asList("_id")));
                HashSet<TableInfo.Index> _indicesPrayerTime = new HashSet<TableInfo.Index>(1);
                _indicesPrayerTime.add(new TableInfo.Index("prayer_index", false, Arrays.asList("location_id", "date"), Arrays.asList("ASC", "ASC")));
                TableInfo _infoPrayerTime = new TableInfo("prayer_time", _columnsPrayerTime, _foreignKeysPrayerTime, _indicesPrayerTime);
                TableInfo _existingPrayerTime = TableInfo.read((SupportSQLiteDatabase)db, (String)"prayer_time");
                if (!_infoPrayerTime.equals((Object)_existingPrayerTime)) {
                    return new RoomOpenHelper.ValidationResult(false, "prayer_time(dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime).\n Expected:\n" + _infoPrayerTime + "\n Found:\n" + _existingPrayerTime);
                }
                HashMap<String, TableInfo.Column> _columnsName = new HashMap<String, TableInfo.Column>(2);
                _columnsName.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsName.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysName = new HashSet(0);
                HashSet _indicesName = new HashSet(0);
                TableInfo _infoName = new TableInfo("name", _columnsName, _foreignKeysName, _indicesName);
                TableInfo _existingName = TableInfo.read((SupportSQLiteDatabase)db, (String)"name");
                if (!_infoName.equals((Object)_existingName)) {
                    return new RoomOpenHelper.ValidationResult(false, "name(dev.kosrat.muslimdata.database.tables.NameTable).\n Expected:\n" + _infoName + "\n Found:\n" + _existingName);
                }
                HashMap<String, TableInfo.Column> _columnsNameTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsNameTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsNameTranslation.put("name_id", new TableInfo.Column("name_id", "INTEGER", true, 0, null, 1));
                _columnsNameTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsNameTranslation.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysNameTranslation = new HashSet(0);
                HashSet _indicesNameTranslation = new HashSet(0);
                TableInfo _infoNameTranslation = new TableInfo("name_translation", _columnsNameTranslation, _foreignKeysNameTranslation, _indicesNameTranslation);
                TableInfo _existingNameTranslation = TableInfo.read((SupportSQLiteDatabase)db, (String)"name_translation");
                if (!_infoNameTranslation.equals((Object)_existingNameTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "name_translation(dev.kosrat.muslimdata.database.tables.NameTranslationTable).\n Expected:\n" + _infoNameTranslation + "\n Found:\n" + _existingNameTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarCategory = new HashMap<String, TableInfo.Column>(1);
                _columnsAzkarCategory.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysAzkarCategory = new HashSet(0);
                HashSet _indicesAzkarCategory = new HashSet(0);
                TableInfo _infoAzkarCategory = new TableInfo("azkar_category", _columnsAzkarCategory, _foreignKeysAzkarCategory, _indicesAzkarCategory);
                TableInfo _existingAzkarCategory = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_category");
                if (!_infoAzkarCategory.equals((Object)_existingAzkarCategory)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_category(dev.kosrat.muslimdata.database.tables.azkars.AzkarCategoryTable).\n Expected:\n" + _infoAzkarCategory + "\n Found:\n" + _existingAzkarCategory);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarCategoryTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarCategoryTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarCategoryTranslation.put("category_id", new TableInfo.Column("category_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarCategoryTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarCategoryTranslation.put("category_name", new TableInfo.Column("category_name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarCategoryTranslation = new HashSet(0);
                HashSet _indicesAzkarCategoryTranslation = new HashSet(0);
                TableInfo _infoAzkarCategoryTranslation = new TableInfo("azkar_category_translation", _columnsAzkarCategoryTranslation, _foreignKeysAzkarCategoryTranslation, _indicesAzkarCategoryTranslation);
                TableInfo _existingAzkarCategoryTranslation = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_category_translation");
                if (!_infoAzkarCategoryTranslation.equals((Object)_existingAzkarCategoryTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_category_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarCategoryTranslationTable).\n Expected:\n" + _infoAzkarCategoryTranslation + "\n Found:\n" + _existingAzkarCategoryTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarChapter = new HashMap<String, TableInfo.Column>(2);
                _columnsAzkarChapter.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarChapter.put("category_id", new TableInfo.Column("category_id", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysAzkarChapter = new HashSet(0);
                HashSet _indicesAzkarChapter = new HashSet(0);
                TableInfo _infoAzkarChapter = new TableInfo("azkar_chapter", _columnsAzkarChapter, _foreignKeysAzkarChapter, _indicesAzkarChapter);
                TableInfo _existingAzkarChapter = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_chapter");
                if (!_infoAzkarChapter.equals((Object)_existingAzkarChapter)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_chapter(dev.kosrat.muslimdata.database.tables.azkars.AzkarChapterTable).\n Expected:\n" + _infoAzkarChapter + "\n Found:\n" + _existingAzkarChapter);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarChapterTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarChapterTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarChapterTranslation.put("chapter_id", new TableInfo.Column("chapter_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarChapterTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarChapterTranslation.put("chapter_name", new TableInfo.Column("chapter_name", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarChapterTranslation = new HashSet(0);
                HashSet _indicesAzkarChapterTranslation = new HashSet(0);
                TableInfo _infoAzkarChapterTranslation = new TableInfo("azkar_chapter_translation", _columnsAzkarChapterTranslation, _foreignKeysAzkarChapterTranslation, _indicesAzkarChapterTranslation);
                TableInfo _existingAzkarChapterTranslation = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_chapter_translation");
                if (!_infoAzkarChapterTranslation.equals((Object)_existingAzkarChapterTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_chapter_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarChapterTranslationTable).\n Expected:\n" + _infoAzkarChapterTranslation + "\n Found:\n" + _existingAzkarChapterTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarItem = new HashMap<String, TableInfo.Column>(3);
                _columnsAzkarItem.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarItem.put("chapter_id", new TableInfo.Column("chapter_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarItem.put("item", new TableInfo.Column("item", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarItem = new HashSet(0);
                HashSet _indicesAzkarItem = new HashSet(0);
                TableInfo _infoAzkarItem = new TableInfo("azkar_item", _columnsAzkarItem, _foreignKeysAzkarItem, _indicesAzkarItem);
                TableInfo _existingAzkarItem = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_item");
                if (!_infoAzkarItem.equals((Object)_existingAzkarItem)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_item(dev.kosrat.muslimdata.database.tables.azkars.AzkarItemTable).\n Expected:\n" + _infoAzkarItem + "\n Found:\n" + _existingAzkarItem);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarItemTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarItemTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarItemTranslation.put("item_id", new TableInfo.Column("item_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarItemTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarItemTranslation.put("item_translation", new TableInfo.Column("item_translation", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarItemTranslation = new HashSet(0);
                HashSet _indicesAzkarItemTranslation = new HashSet(0);
                TableInfo _infoAzkarItemTranslation = new TableInfo("azkar_item_translation", _columnsAzkarItemTranslation, _foreignKeysAzkarItemTranslation, _indicesAzkarItemTranslation);
                TableInfo _existingAzkarItemTranslation = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_item_translation");
                if (!_infoAzkarItemTranslation.equals((Object)_existingAzkarItemTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_item_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarItemTranslationTable).\n Expected:\n" + _infoAzkarItemTranslation + "\n Found:\n" + _existingAzkarItemTranslation);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarReference = new HashMap<String, TableInfo.Column>(2);
                _columnsAzkarReference.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarReference.put("item_id", new TableInfo.Column("item_id", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysAzkarReference = new HashSet(0);
                HashSet _indicesAzkarReference = new HashSet(0);
                TableInfo _infoAzkarReference = new TableInfo("azkar_reference", _columnsAzkarReference, _foreignKeysAzkarReference, _indicesAzkarReference);
                TableInfo _existingAzkarReference = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_reference");
                if (!_infoAzkarReference.equals((Object)_existingAzkarReference)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_reference(dev.kosrat.muslimdata.database.tables.azkars.AzkarReferenceTable).\n Expected:\n" + _infoAzkarReference + "\n Found:\n" + _existingAzkarReference);
                }
                HashMap<String, TableInfo.Column> _columnsAzkarReferenceTranslation = new HashMap<String, TableInfo.Column>(4);
                _columnsAzkarReferenceTranslation.put("_id", new TableInfo.Column("_id", "INTEGER", true, 1, null, 1));
                _columnsAzkarReferenceTranslation.put("reference_id", new TableInfo.Column("reference_id", "INTEGER", true, 0, null, 1));
                _columnsAzkarReferenceTranslation.put("language", new TableInfo.Column("language", "TEXT", true, 0, null, 1));
                _columnsAzkarReferenceTranslation.put("reference", new TableInfo.Column("reference", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysAzkarReferenceTranslation = new HashSet(0);
                HashSet _indicesAzkarReferenceTranslation = new HashSet(0);
                TableInfo _infoAzkarReferenceTranslation = new TableInfo("azkar_reference_translation", _columnsAzkarReferenceTranslation, _foreignKeysAzkarReferenceTranslation, _indicesAzkarReferenceTranslation);
                TableInfo _existingAzkarReferenceTranslation = TableInfo.read((SupportSQLiteDatabase)db, (String)"azkar_reference_translation");
                if (!_infoAzkarReferenceTranslation.equals((Object)_existingAzkarReferenceTranslation)) {
                    return new RoomOpenHelper.ValidationResult(false, "azkar_reference_translation(dev.kosrat.muslimdata.database.tables.azkars.AzkarReferenceTranslationTable).\n Expected:\n" + _infoAzkarReferenceTranslation + "\n Found:\n" + _existingAzkarReferenceTranslation);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "a0e40451f9b12e79cd31d12d0a0c577e", "753519c062924b15c75d9a8562f416f4");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    @NonNull
    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"country", "location", "prayer_time", "name", "name_translation", "azkar_category", "azkar_category_translation", "azkar_chapter", "azkar_chapter_translation", "azkar_item", "azkar_item_translation", "azkar_reference", "azkar_reference_translation"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `prayer_time`");
            _db.execSQL("DELETE FROM `location`");
            _db.execSQL("DELETE FROM `country`");
            _db.execSQL("DELETE FROM `name`");
            _db.execSQL("DELETE FROM `name_translation`");
            _db.execSQL("DELETE FROM `azkar_category`");
            _db.execSQL("DELETE FROM `azkar_category_translation`");
            _db.execSQL("DELETE FROM `azkar_chapter`");
            _db.execSQL("DELETE FROM `azkar_chapter_translation`");
            _db.execSQL("DELETE FROM `azkar_item`");
            _db.execSQL("DELETE FROM `azkar_item_translation`");
            _db.execSQL("DELETE FROM `azkar_reference`");
            _db.execSQL("DELETE FROM `azkar_reference_translation`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    @NonNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(MuslimDataDao.class, MuslimDataDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    @NonNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    @NonNull
    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        ArrayList<Migration> _autoMigrations = new ArrayList<Migration>();
        return _autoMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuslimDataDao getMuslimDataDao$muslim_data_release() {
        if (this._muslimDataDao != null) {
            return this._muslimDataDao;
        }
        MuslimDataDatabase_Impl muslimDataDatabase_Impl = this;
        synchronized (muslimDataDatabase_Impl) {
            if (this._muslimDataDao == null) {
                this._muslimDataDao = new MuslimDataDao_Impl(this);
            }
            return this._muslimDataDao;
        }
    }
}

