/*
 * Decompiled with CFR 0.152.
 */
package dev.kosrat.muslimdata.database;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import dev.kosrat.muslimdata.database.tables.prayertimes.FixedPrayerTime;
import dev.kosrat.muslimdata.models.AzkarCategory;
import dev.kosrat.muslimdata.models.AzkarChapter;
import dev.kosrat.muslimdata.models.AzkarItem;
import dev.kosrat.muslimdata.models.Location;
import dev.kosrat.muslimdata.models.NameOfAllah;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\ba\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J \u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010\f\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\rJ,\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u00a7@\u00a2\u0006\u0002\u0010\u0013J&\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0012H\u00a7@\u00a2\u0006\u0002\u0010\u0015J&\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u0010\f\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u0019J \u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u00a7@\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\r\u00a8\u0006&"}, d2={"Ldev/kosrat/muslimdata/database/MuslimDataDao;", "", "fixedPrayerTimesList", "", "Ldev/kosrat/muslimdata/models/Location;", "geocoder", "countryCode", "", "locationName", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAzkarCategories", "Ldev/kosrat/muslimdata/models/AzkarCategory;", "language", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAzkarChapters", "Ldev/kosrat/muslimdata/models/AzkarChapter;", "chapterIds", "", "", "(Ljava/lang/String;[Ljava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "categoryId", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAzkarItems", "Ldev/kosrat/muslimdata/models/AzkarItem;", "chapterId", "(ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNames", "Ldev/kosrat/muslimdata/models/NameOfAllah;", "getPrayerTimes", "Ldev/kosrat/muslimdata/database/tables/prayertimes/FixedPrayerTime;", "locationId", "date", "reverseGeocoder", "latitude", "", "longitude", "(DDLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "searchLocation", "muslim-data_release"})
@Dao
public interface MuslimDataDao {
    @Transaction
    @Query(value="SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE location.name like :locationName")
    @Nullable
    public Object searchLocation(@NotNull String var1, @NotNull Continuation<? super List<Location>> var2);

    @Transaction
    @Query(value="SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE country.code= :countryCode  COLLATE NOCASE AND location.name= :locationName COLLATE NOCASE")
    @Nullable
    public Object geocoder(@NotNull String var1, @NotNull String var2, @NotNull Continuation<? super Location> var3);

    @Transaction
    @Query(value="SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id ORDER BY abs(latitude - :latitude) + abs(longitude - :longitude) LIMIT 1")
    @Nullable
    public Object reverseGeocoder(double var1, double var3, @NotNull Continuation<? super Location> var5);

    @Query(value="SELECT * FROM prayer_time WHERE location_id = :locationId AND date = :date")
    @Nullable
    public Object getPrayerTimes(int var1, @NotNull String var2, @NotNull Continuation<? super FixedPrayerTime> var3);

    @Transaction
    @Query(value="SELECT name._id AS number, name.name , transl.name AS translation FROM name INNER JOIN name_translation AS transl ON transl.name_id = name._id AND transl.language = :language")
    @Nullable
    public Object getNames(@NotNull String var1, @NotNull Continuation<? super List<NameOfAllah>> var2);

    @Transaction
    @Query(value="SELECT category._id AS categoryId, category_name AS categoryName FROM azkar_category AS category INNER JOIN azkar_category_translation AS transl ON transl.category_id = category._id WHERE language = :language")
    @Nullable
    public Object getAzkarCategories(@NotNull String var1, @NotNull Continuation<? super List<AzkarCategory>> var2);

    @Transaction
    @Query(value="SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation AS transl ON transl.chapter_id = chapter._id WHERE language = :language AND (:categoryId = -1 OR category_id = :categoryId)")
    @Nullable
    public Object getAzkarChapters(@NotNull String var1, int var2, @NotNull Continuation<? super List<AzkarChapter>> var3);

    @Transaction
    @Query(value="SELECT chapter._id AS chapterId, category_id AS categoryId, chapter_name AS chapterName FROM azkar_chapter AS chapter INNER JOIN azkar_chapter_translation AS transl ON transl.chapter_id = chapter._id WHERE language = :language AND chapter._id IN (:chapterIds)")
    @Nullable
    public Object getAzkarChapters(@NotNull String var1, @NotNull Integer[] var2, @NotNull Continuation<? super List<AzkarChapter>> var3);

    @Transaction
    @Query(value="SELECT item._id AS itemId, item.chapter_id AS chapterId, item.item, transl.item_translation AS translation, ref_transl.reference FROM azkar_item AS item INNER JOIN azkar_item_translation AS transl ON transl.item_id = item._id INNER JOIN azkar_reference AS ref ON ref.item_id = item._id INNER JOIN azkar_reference_translation AS ref_transl ON ref_transl.reference_id = ref._id AND ref_transl.language = transl.language WHERE chapterId = :chapterId AND transl.language = :language")
    @Nullable
    public Object getAzkarItems(int var1, @NotNull String var2, @NotNull Continuation<? super List<AzkarItem>> var3);

    @Transaction
    @Query(value="SELECT location._id AS id, country.code AS countryCode, country.name AS countryName, location.name AS name, latitude, longitude, has_fixed_prayer_time AS hasFixedPrayerTime, prayer_dependent_id AS prayerDependentId FROM location INNER JOIN country ON country._id = location.country_id WHERE has_fixed_prayer_time = 1")
    @NotNull
    public List<Location> fixedPrayerTimesList();
}

