/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.internal.AsyncResponse;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record AgentExecutor(AgentInvoker agentInvoker, Object agent) {
    private static final Logger LOG = LoggerFactory.getLogger(AgentExecutor.class);

    public String agentName() {
        return this.agentInvoker.name();
    }

    public Object execute(DefaultAgenticScope agenticScope) {
        return this.execute(agenticScope, this.agentInvoker.async());
    }

    public Object syncExecute(DefaultAgenticScope agenticScope) {
        if (this.agentInvoker.async()) {
            LOG.info("Executing '{}' agent in a sync way even if declared as async", (Object)this.agentInvoker.name());
        }
        return this.execute(agenticScope, false);
    }

    private Object execute(DefaultAgenticScope agenticScope, boolean async) {
        Object object;
        Object object2 = this.agent;
        if (object2 instanceof AgenticScopeOwner) {
            AgenticScopeOwner co = (AgenticScopeOwner)object2;
            object = co.withAgenticScope(agenticScope);
        } else {
            object = this.agent;
        }
        Object invokedAgent = object;
        return this.internalExecute(agenticScope, invokedAgent, async);
    }

    private Object handleAgentFailure(AgentInvocationException e, DefaultAgenticScope agenticScope, Object invokedAgent) {
        ErrorRecoveryResult recoveryResult = agenticScope.handleError(this.agentInvoker.name(), e);
        return switch (recoveryResult.type()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorRecoveryResult.Type.THROW_EXCEPTION -> throw e;
            case ErrorRecoveryResult.Type.RETRY -> this.internalExecute(agenticScope, invokedAgent, false);
            case ErrorRecoveryResult.Type.RETURN_RESULT -> recoveryResult.result();
        };
    }

    private Object internalExecute(DefaultAgenticScope agenticScope, Object invokedAgent, boolean async) {
        try {
            Object[] args = this.agentInvoker.toInvocationArguments(agenticScope);
            Object response = async ? new AsyncResponse<Object>(() -> {
                try {
                    return this.agentInvoker.invoke(invokedAgent, args);
                }
                catch (AgentInvocationException e) {
                    return this.handleAgentFailure(e, agenticScope, invokedAgent);
                }
            }) : this.agentInvoker.invoke(invokedAgent, args);
            String outputName = this.agentInvoker.outputName();
            if (outputName != null && !outputName.isBlank()) {
                agenticScope.writeState(outputName, response);
            }
            agenticScope.registerAgentCall(this.agentInvoker.name(), invokedAgent, args, response);
            return response;
        }
        catch (AgentInvocationException e) {
            return this.handleAgentFailure(e, agenticScope, invokedAgent);
        }
    }
}

