/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.MissingArgumentException;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.MethodAgentInvoker;
import dev.langchain4j.agentic.internal.UntypedAgentInvoker;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.service.V;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;

public interface AgentInvoker {
    public String name();

    public String description();

    public String outputName();

    public boolean async();

    public Method method();

    public String toCard();

    public Object[] toInvocationArguments(AgenticScope var1) throws MissingArgumentException;

    default public Object invoke(Object agent, Object ... args) throws AgentInvocationException {
        try {
            return this.method().invoke(agent, args);
        }
        catch (Exception e) {
            throw new AgentInvocationException("Failed to invoke agent method: " + String.valueOf(this.method()), e);
        }
    }

    public static AgentInvoker fromMethod(AgentSpecification agent, Method method) {
        return AgentInvoker.fromMethodAndSpec(method, agent.name(), agent.description(), agent.outputName(), agent.async());
    }

    public static AgentInvoker fromMethodAndSpec(Method method, String name, String description, String outputName, boolean async) {
        if (method.getDeclaringClass() == UntypedAgent.class) {
            return new UntypedAgentInvoker(method, name, description, outputName, async);
        }
        return new MethodAgentInvoker(method, name, description, outputName, async, AgentUtil.argumentsFromMethod(method));
    }

    public static String parameterName(Parameter parameter) {
        return AgentInvoker.optionalParameterName(parameter).orElseThrow(() -> new IllegalArgumentException("Parameter name not specified and no @P or @V annotation present: " + String.valueOf(parameter)));
    }

    public static Optional<String> optionalParameterName(Parameter parameter) {
        P p = parameter.getAnnotation(P.class);
        if (p != null) {
            return Optional.of(p.value());
        }
        V v = parameter.getAnnotation(V.class);
        if (v != null) {
            return Optional.of(v.value());
        }
        return parameter.isNamePresent() ? Optional.of(parameter.getName()) : Optional.empty();
    }
}

