/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheControl;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolSchema;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AnthropicTool {
    public String name;
    public String description;
    public AnthropicToolSchema inputSchema;
    public AnthropicCacheControl cacheControl;

    AnthropicTool(String name, String description, AnthropicToolSchema inputSchema, AnthropicCacheControl cacheControl) {
        this.name = name;
        this.description = description;
        this.inputSchema = inputSchema;
        this.cacheControl = cacheControl;
    }

    public static AnthropicToolBuilder builder() {
        return new AnthropicToolBuilder();
    }

    public String toString() {
        return "AnthropicTool(name=" + this.name + ", description=" + this.description + ", inputSchema=" + String.valueOf(this.inputSchema) + ", cacheControl=" + String.valueOf(this.cacheControl) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnthropicTool)) {
            return false;
        }
        AnthropicTool other = (AnthropicTool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        AnthropicToolSchema this$inputSchema = this.inputSchema;
        AnthropicToolSchema other$inputSchema = other.inputSchema;
        if (this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema)) {
            return false;
        }
        AnthropicCacheControl this$cacheControl = this.cacheControl;
        AnthropicCacheControl other$cacheControl = other.cacheControl;
        return !(this$cacheControl == null ? other$cacheControl != null : !((Object)this$cacheControl).equals(other$cacheControl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnthropicTool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        AnthropicToolSchema $inputSchema = this.inputSchema;
        result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
        AnthropicCacheControl $cacheControl = this.cacheControl;
        result = result * 59 + ($cacheControl == null ? 43 : ((Object)$cacheControl).hashCode());
        return result;
    }

    public static class AnthropicToolBuilder {
        private String name;
        private String description;
        private AnthropicToolSchema inputSchema;
        private AnthropicCacheControl cacheControl;

        AnthropicToolBuilder() {
        }

        public AnthropicToolBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AnthropicToolBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AnthropicToolBuilder inputSchema(AnthropicToolSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public AnthropicToolBuilder cacheControl(AnthropicCacheControl cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public AnthropicTool build() {
            return new AnthropicTool(this.name, this.description, this.inputSchema, this.cacheControl);
        }

        public String toString() {
            return "AnthropicTool.AnthropicToolBuilder(name=" + this.name + ", description=" + this.description + ", inputSchema=" + String.valueOf(this.inputSchema) + ", cacheControl=" + String.valueOf(this.cacheControl) + ")";
        }
    }
}

