/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.InternalAnthropicHelper;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTextContent;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.anthropic.internal.sanitizer.MessageSanitizer;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnthropicChatModel
implements ChatLanguageModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnthropicChatModel.class);
    private final AnthropicClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;
    private final int maxTokens;
    private final List<String> stopSequences;
    private final boolean cacheSystemMessages;
    private final boolean cacheTools;
    private final int maxRetries;
    private final List<ChatModelListener> listeners;

    private AnthropicChatModel(String baseUrl, String apiKey, String version, String beta, String modelName, Double temperature, Double topP, Integer topK, Integer maxTokens, List<String> stopSequences, Boolean cacheSystemMessages, Boolean cacheTools, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners) {
        this.client = ((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)AnthropicClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.anthropic.com/v1/"))).apiKey(apiKey)).version((String)Utils.getOrDefault((Object)version, (Object)"2023-06-01"))).beta(beta)).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)AnthropicChatModelName.CLAUDE_3_HAIKU_20240307.toString());
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.maxTokens = (Integer)Utils.getOrDefault((Object)maxTokens, (Object)1024);
        this.stopSequences = stopSequences;
        this.cacheSystemMessages = (Boolean)Utils.getOrDefault((Object)cacheSystemMessages, (Object)false);
        this.cacheTools = (Boolean)Utils.getOrDefault((Object)cacheTools, (Object)false);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    @Deprecated(forRemoval=true)
    public static AnthropicChatModel withApiKey(String apiKey) {
        return AnthropicChatModel.builder().apiKey(apiKey).build();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        List<ChatMessage> sanitizedMessages = MessageSanitizer.sanitizeMessages(messages);
        List<AnthropicTextContent> systemPrompt = AnthropicMapper.toAnthropicSystemPrompt(messages, this.cacheSystemMessages ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE);
        AnthropicCreateMessageRequest request = AnthropicCreateMessageRequest.builder().model(this.modelName).messages(AnthropicMapper.toAnthropicMessages(sanitizedMessages)).system(systemPrompt).maxTokens(this.maxTokens).stopSequences(this.stopSequences).stream(false).temperature(this.temperature).topP(this.topP).topK(this.topK).tools(AnthropicMapper.toAnthropicTools(toolSpecifications, this.cacheTools ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE)).build();
        ChatModelRequest modelListenerRequest = InternalAnthropicHelper.createModelListenerRequest(request, messages, toolSpecifications);
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            AnthropicCreateMessageResponse response = (AnthropicCreateMessageResponse)RetryUtils.withRetry(() -> this.client.createMessage(request), (int)this.maxRetries);
            Response responseMessage = Response.from((Object)AnthropicMapper.toAiMessage(response.content), (TokenUsage)AnthropicMapper.toTokenUsage(response.usage), (FinishReason)AnthropicMapper.toFinishReason(response.stopReason));
            ChatModelResponse modelListenerResponse = InternalAnthropicHelper.createModelListenerResponse(response.id, response.model, (Response<AiMessage>)responseMessage);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            return Response.from((Object)AnthropicMapper.toAiMessage(response.content), (TokenUsage)AnthropicMapper.toTokenUsage(response.usage), (FinishReason)AnthropicMapper.toFinishReason(response.stopReason));
        }
        catch (RuntimeException e) {
            ChatModelErrorContext errorContext = InternalAnthropicHelper.createErrorContext(e, modelListenerRequest, attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    log.warn("Exception while calling model listener", (Throwable)e2);
                }
            });
            throw e;
        }
    }

    @Generated
    public static AnthropicChatModelBuilder builder() {
        return new AnthropicChatModelBuilder();
    }

    public static class AnthropicChatModelBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private String apiKey;
        @Generated
        private String version;
        @Generated
        private String beta;
        @Generated
        private String modelName;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Integer topK;
        @Generated
        private Integer maxTokens;
        @Generated
        private List<String> stopSequences;
        @Generated
        private Boolean cacheSystemMessages;
        @Generated
        private Boolean cacheTools;
        @Generated
        private Duration timeout;
        @Generated
        private Integer maxRetries;
        @Generated
        private Boolean logRequests;
        @Generated
        private Boolean logResponses;
        @Generated
        private List<ChatModelListener> listeners;

        public AnthropicChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public AnthropicChatModelBuilder modelName(AnthropicChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        @Generated
        AnthropicChatModelBuilder() {
        }

        @Generated
        public AnthropicChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder beta(String beta) {
            this.beta = beta;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder cacheSystemMessages(Boolean cacheSystemMessages) {
            this.cacheSystemMessages = cacheSystemMessages;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder cacheTools(Boolean cacheTools) {
            this.cacheTools = cacheTools;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        @Generated
        public AnthropicChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        @Generated
        public AnthropicChatModel build() {
            return new AnthropicChatModel(this.baseUrl, this.apiKey, this.version, this.beta, this.modelName, this.temperature, this.topP, this.topK, this.maxTokens, this.stopSequences, this.cacheSystemMessages, this.cacheTools, this.timeout, this.maxRetries, this.logRequests, this.logResponses, this.listeners);
        }

        @Generated
        public String toString() {
            return "AnthropicChatModel.AnthropicChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", version=" + this.version + ", beta=" + this.beta + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", maxTokens=" + this.maxTokens + ", stopSequences=" + String.valueOf(this.stopSequences) + ", cacheSystemMessages=" + this.cacheSystemMessages + ", cacheTools=" + this.cacheTools + ", timeout=" + String.valueOf(this.timeout) + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", listeners=" + String.valueOf(this.listeners) + ")";
        }
    }
}

