/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.anthropic.AnthropicTokenUsage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicApi;
import dev.langchain4j.model.anthropic.internal.api.AnthropicContentBlockType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicDelta;
import dev.langchain4j.model.anthropic.internal.api.AnthropicResponseMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicStreamingData;
import dev.langchain4j.model.anthropic.internal.api.AnthropicUsage;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.client.AnthropicHttpException;
import dev.langchain4j.model.anthropic.internal.client.AnthropicRequestLoggingInterceptor;
import dev.langchain4j.model.anthropic.internal.client.AnthropicResponseLoggingInterceptor;
import dev.langchain4j.model.anthropic.internal.client.AnthropicToolExecutionRequestBuilder;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DefaultAnthropicClient
extends AnthropicClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAnthropicClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final AnthropicApi anthropicApi;
    private final OkHttpClient okHttpClient;
    private final String apiKey;
    private final String version;
    private final String beta;
    private final boolean logResponses;

    public static Builder builder() {
        return new Builder();
    }

    DefaultAnthropicClient(Builder builder) {
        if (Utils.isNullOrBlank((String)builder.apiKey)) {
            throw new IllegalArgumentException("Anthropic API key must be defined. It can be generated here: https://console.anthropic.com/settings/keys");
        }
        this.apiKey = builder.apiKey;
        this.version = ValidationUtils.ensureNotBlank((String)builder.version, (String)"version");
        this.beta = builder.beta;
        this.logResponses = builder.logResponses;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(builder.timeout).connectTimeout(builder.timeout).readTimeout(builder.timeout).writeTimeout(builder.timeout);
        if (builder.logRequests.booleanValue()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new AnthropicRequestLoggingInterceptor());
        }
        if (this.logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new AnthropicResponseLoggingInterceptor());
        }
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)ValidationUtils.ensureNotBlank((String)builder.baseUrl, (String)"baseUrl"))).client(this.okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)OBJECT_MAPPER)).build();
        this.anthropicApi = (AnthropicApi)retrofit.create(AnthropicApi.class);
    }

    @Override
    public AnthropicCreateMessageResponse createMessage(AnthropicCreateMessageRequest request) {
        try {
            retrofit2.Response retrofitResponse = this.anthropicApi.createMessage(this.apiKey, this.version, this.beta, request).execute();
            if (retrofitResponse.isSuccessful()) {
                return (AnthropicCreateMessageResponse)retrofitResponse.body();
            }
            try (ResponseBody errorBody = retrofitResponse.errorBody();){
                if (errorBody != null) {
                    throw new AnthropicHttpException(retrofitResponse.code(), errorBody.string());
                }
            }
            throw new AnthropicHttpException(retrofitResponse.code(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createMessage(AnthropicCreateMessageRequest request, final StreamingResponseHandler<AiMessage> handler) {
        EventSourceListener eventSourceListener = new EventSourceListener(){
            final ReentrantLock lock = new ReentrantLock();
            final List<String> contents = Collections.synchronizedList(new ArrayList());
            volatile StringBuffer currentContentBuilder = new StringBuffer();
            final AtomicReference<AnthropicContentBlockType> currentContentBlockStartType = new AtomicReference();
            final Map<Integer, AnthropicToolExecutionRequestBuilder> toolExecutionRequestBuilderMap = new ConcurrentHashMap<Integer, AnthropicToolExecutionRequestBuilder>();
            final AtomicInteger inputTokenCount = new AtomicInteger();
            final AtomicInteger outputTokenCount = new AtomicInteger();
            final AtomicInteger cacheCreationInputTokens = new AtomicInteger();
            final AtomicInteger cacheReadInputTokens = new AtomicInteger();
            final AtomicReference<String> responseId = new AtomicReference();
            final AtomicReference<String> responseModel = new AtomicReference();
            volatile String stopReason;

            private StringBuffer currentContentBuilder() {
                this.lock.lock();
                try {
                    StringBuffer stringBuffer = this.currentContentBuilder;
                    return stringBuffer;
                }
                finally {
                    this.lock.unlock();
                }
            }

            private void setCurrentContentBuilder(StringBuffer stringBuffer) {
                this.lock.lock();
                try {
                    this.currentContentBuilder = stringBuffer;
                }
                finally {
                    this.lock.unlock();
                }
            }

            public void onOpen(EventSource eventSource, okhttp3.Response response) {
                if (DefaultAnthropicClient.this.logResponses) {
                    LOGGER.debug("onOpen()");
                }
            }

            public void onEvent(EventSource eventSource, String id, String type, String dataString) {
                if (DefaultAnthropicClient.this.logResponses) {
                    LOGGER.debug("onEvent() type: '{}', data: {}", (Object)type, (Object)dataString);
                }
                try {
                    AnthropicStreamingData data = (AnthropicStreamingData)OBJECT_MAPPER.readValue(dataString, AnthropicStreamingData.class);
                    if ("message_start".equals(type)) {
                        this.handleMessageStart(data);
                    } else if ("content_block_start".equals(type)) {
                        this.handleContentBlockStart(data);
                    } else if ("content_block_delta".equals(type)) {
                        this.handleContentBlockDelta(data);
                    } else if ("content_block_stop".equals(type)) {
                        this.handleContentBlockStop();
                    } else if ("message_delta".equals(type)) {
                        this.handleMessageDelta(data);
                    } else if ("message_stop".equals(type)) {
                        this.handleMessageStop();
                    } else if ("error".equals(type)) {
                        this.handleError(dataString);
                    }
                }
                catch (Exception e) {
                    handler.onError((Throwable)e);
                }
            }

            private void handleMessageStart(AnthropicStreamingData data) {
                AnthropicResponseMessage message = data.message;
                if (message != null) {
                    if (message.usage != null) {
                        this.handleUsage(message.usage);
                    }
                    if (message.id != null) {
                        this.responseId.set(message.id);
                    }
                    if (message.model != null) {
                        this.responseModel.set(message.model);
                    }
                }
            }

            private void handleUsage(AnthropicUsage usage) {
                if (usage.inputTokens != null) {
                    this.inputTokenCount.addAndGet(usage.inputTokens);
                }
                if (usage.outputTokens != null) {
                    this.outputTokenCount.addAndGet(usage.outputTokens);
                }
                if (usage.cacheCreationInputTokens != null) {
                    this.cacheCreationInputTokens.addAndGet(usage.cacheCreationInputTokens);
                }
                if (usage.cacheReadInputTokens != null) {
                    this.cacheReadInputTokens.addAndGet(usage.cacheReadInputTokens);
                }
            }

            private void handleContentBlockStart(AnthropicStreamingData data) {
                if (data.contentBlock == null) {
                    return;
                }
                this.currentContentBlockStartType.set(data.contentBlock.type);
                if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TEXT) {
                    String text = data.contentBlock.text;
                    if (Utils.isNotNullOrEmpty((String)text)) {
                        this.currentContentBuilder().append(text);
                        handler.onNext(text);
                    }
                } else if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TOOL_USE) {
                    this.toolExecutionRequestBuilderMap.putIfAbsent(data.index, new AnthropicToolExecutionRequestBuilder(data.contentBlock.id, data.contentBlock.name));
                }
            }

            private void handleContentBlockDelta(AnthropicStreamingData data) {
                Integer toolExecutionsIndex;
                String partialJson;
                if (data.delta == null) {
                    return;
                }
                if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TEXT) {
                    String text = data.delta.text;
                    if (Utils.isNotNullOrEmpty((String)text)) {
                        this.currentContentBuilder().append(text);
                        handler.onNext(text);
                    }
                } else if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TOOL_USE && Utils.isNotNullOrEmpty((String)(partialJson = data.delta.partialJson)) && (toolExecutionsIndex = data.index) != null) {
                    AnthropicToolExecutionRequestBuilder toolExecutionRequestBuilder = this.toolExecutionRequestBuilderMap.get(toolExecutionsIndex);
                    toolExecutionRequestBuilder.appendArguments(partialJson);
                }
            }

            private void handleContentBlockStop() {
                this.contents.add(this.currentContentBuilder().toString());
                this.setCurrentContentBuilder(new StringBuffer());
            }

            private void handleMessageDelta(AnthropicStreamingData data) {
                if (data.delta != null) {
                    AnthropicDelta delta = data.delta;
                    if (delta.stopReason != null) {
                        this.stopReason = delta.stopReason;
                    }
                }
                if (data.usage != null) {
                    this.handleUsage(data.usage);
                }
            }

            private void handleMessageStop() {
                Response<AiMessage> response = this.build();
                handler.onComplete(response);
            }

            private Response<AiMessage> build() {
                String text = this.contents.stream().filter(content -> !content.isEmpty()).collect(Collectors.joining("\n"));
                AnthropicTokenUsage tokenUsage = AnthropicTokenUsage.builder().inputTokenCount(this.inputTokenCount.get()).outputTokenCount(this.outputTokenCount.get()).cacheCreationInputTokens(this.cacheCreationInputTokens.get()).cacheReadInputTokens(this.cacheReadInputTokens.get()).build();
                FinishReason finishReason = AnthropicMapper.toFinishReason(this.stopReason);
                Map<String, Object> metadata = this.createMetadata();
                if (this.toolExecutionRequestBuilderMap.isEmpty()) {
                    return Response.from((Object)AiMessage.from((String)text), (TokenUsage)tokenUsage, (FinishReason)finishReason, metadata);
                }
                List toolExecutionRequests = this.toolExecutionRequestBuilderMap.values().stream().map(AnthropicToolExecutionRequestBuilder::build).collect(Collectors.toList());
                AiMessage aiMessage = Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
                return Response.from((Object)aiMessage, (TokenUsage)tokenUsage, (FinishReason)finishReason, metadata);
            }

            private Map<String, Object> createMetadata() {
                HashMap<String, Object> metadata = new HashMap<String, Object>();
                if (this.responseId.get() != null) {
                    metadata.put("id", this.responseId.get());
                }
                if (this.responseModel.get() != null) {
                    metadata.put("model", this.responseModel.get());
                }
                return metadata;
            }

            private void handleError(String dataString) {
                handler.onError((Throwable)((Object)new AnthropicHttpException(null, dataString)));
            }

            public void onFailure(EventSource eventSource, Throwable t, okhttp3.Response response) {
                if (DefaultAnthropicClient.this.logResponses) {
                    LOGGER.debug("onFailure()", t);
                }
                if (t != null) {
                    handler.onError(t);
                }
                if (response != null) {
                    try (ResponseBody responseBody = response.body();){
                        if (responseBody != null) {
                            handler.onError((Throwable)((Object)new AnthropicHttpException(response.code(), responseBody.string())));
                        } else {
                            handler.onError((Throwable)((Object)new AnthropicHttpException(response.code(), null)));
                        }
                    }
                    catch (IOException e) {
                        handler.onError((Throwable)((Object)new AnthropicHttpException(response.code(), "[error reading response body]")));
                    }
                }
            }

            public void onClosed(EventSource eventSource) {
                if (DefaultAnthropicClient.this.logResponses) {
                    LOGGER.debug("onClosed()");
                }
            }
        };
        Call<ResponseBody> call = this.anthropicApi.streamMessage(this.apiKey, this.version, this.beta, request);
        EventSources.createFactory((OkHttpClient)this.okHttpClient).newEventSource(call.request(), eventSourceListener);
    }

    public static class Builder
    extends AnthropicClient.Builder<DefaultAnthropicClient, Builder> {
        @Override
        public DefaultAnthropicClient build() {
            return new DefaultAnthropicClient(this);
        }
    }
}

