/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.mapper;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.pdf.PdfFile;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.anthropic.AnthropicTokenUsage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicContentBlockType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicImageContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessageContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicPdfContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicRole;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTextContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTool;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolChoice;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolChoiceType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolResultContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolSchema;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolUseContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicUsage;
import dev.langchain4j.model.anthropic.internal.client.Json;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public class AnthropicMapper {
    public static List<AnthropicMessage> toAnthropicMessages(List<ChatMessage> messages) {
        ArrayList<AnthropicMessage> anthropicMessages = new ArrayList<AnthropicMessage>();
        ArrayList<AnthropicMessageContent> toolContents = new ArrayList<AnthropicMessageContent>();
        for (ChatMessage message : messages) {
            List<AnthropicMessageContent> contents;
            if (message instanceof ToolExecutionResultMessage) {
                toolContents.add(AnthropicMapper.toAnthropicToolResultContent((ToolExecutionResultMessage)message));
                continue;
            }
            if (message instanceof SystemMessage) continue;
            if (!toolContents.isEmpty()) {
                anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, toolContents));
                toolContents = new ArrayList();
            }
            if (message instanceof UserMessage) {
                contents = AnthropicMapper.toAnthropicMessageContents((UserMessage)message);
                anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, contents));
                continue;
            }
            if (!(message instanceof AiMessage)) continue;
            contents = AnthropicMapper.toAnthropicMessageContents((AiMessage)message);
            anthropicMessages.add(new AnthropicMessage(AnthropicRole.ASSISTANT, contents));
        }
        if (!toolContents.isEmpty()) {
            anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, toolContents));
        }
        return anthropicMessages;
    }

    private static AnthropicToolResultContent toAnthropicToolResultContent(ToolExecutionResultMessage message) {
        return new AnthropicToolResultContent(message.id(), message.text(), null);
    }

    private static List<AnthropicMessageContent> toAnthropicMessageContents(UserMessage message) {
        return message.contents().stream().map(content -> {
            if (content instanceof TextContent) {
                TextContent textContent = (TextContent)content;
                return new AnthropicTextContent(textContent.text());
            }
            if (content instanceof ImageContent) {
                ImageContent imageContent = (ImageContent)content;
                Image image = imageContent.image();
                if (image.url() != null) {
                    throw new UnsupportedFeatureException("Anthropic does not support images as URLs, only as Base64-encoded strings");
                }
                return new AnthropicImageContent(ValidationUtils.ensureNotBlank((String)image.mimeType(), (String)"mimeType"), ValidationUtils.ensureNotBlank((String)image.base64Data(), (String)"base64Data"));
            }
            if (content instanceof PdfFileContent) {
                PdfFileContent pdfFileContent = (PdfFileContent)content;
                PdfFile pdfFile = pdfFileContent.pdfFile();
                return new AnthropicPdfContent(pdfFile.mimeType(), ValidationUtils.ensureNotBlank((String)pdfFile.base64Data(), (String)"base64Data"));
            }
            throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(content)), (Object[])new Object[0]);
        }).collect(Collectors.toList());
    }

    private static List<AnthropicMessageContent> toAnthropicMessageContents(AiMessage message) {
        ArrayList<AnthropicMessageContent> contents = new ArrayList<AnthropicMessageContent>();
        if (Utils.isNotNullOrBlank((String)message.text())) {
            contents.add(new AnthropicTextContent(message.text()));
        }
        if (message.hasToolExecutionRequests()) {
            List<AnthropicToolUseContent> toolUseContents = message.toolExecutionRequests().stream().map(toolExecutionRequest -> AnthropicToolUseContent.builder().id(toolExecutionRequest.id()).name(toolExecutionRequest.name()).input(AnthropicMapper.toAnthropicInput(toolExecutionRequest)).build()).toList();
            contents.addAll(toolUseContents);
        }
        return contents;
    }

    private static Map<String, Object> toAnthropicInput(ToolExecutionRequest toolExecutionRequest) {
        String arguments = toolExecutionRequest.arguments();
        if (Utils.isNullOrBlank((String)arguments)) {
            return Map.of();
        }
        return Json.fromJson(arguments, Map.class);
    }

    public static List<AnthropicTextContent> toAnthropicSystemPrompt(List<ChatMessage> messages, AnthropicCacheType cacheType) {
        return messages.stream().filter(message -> message instanceof SystemMessage).map(message -> {
            SystemMessage systemMessage = (SystemMessage)message;
            if (cacheType != AnthropicCacheType.NO_CACHE) {
                return new AnthropicTextContent(systemMessage.text(), cacheType.cacheControl());
            }
            return new AnthropicTextContent(systemMessage.text());
        }).collect(Collectors.toList());
    }

    public static AiMessage toAiMessage(List<AnthropicContent> contents) {
        String text = contents.stream().filter(content -> content.type == AnthropicContentBlockType.TEXT).map(content -> content.text).collect(Collectors.joining("\n"));
        List toolExecutionRequests = contents.stream().filter(content -> content.type == AnthropicContentBlockType.TOOL_USE).map(content -> ToolExecutionRequest.builder().id(content.id).name(content.name).arguments(Json.toJson(content.input)).build()).collect(Collectors.toList());
        if (Utils.isNotNullOrBlank((String)text) && !Utils.isNullOrEmpty(toolExecutionRequests)) {
            return AiMessage.from((String)text, toolExecutionRequests);
        }
        if (!Utils.isNullOrEmpty(toolExecutionRequests)) {
            return AiMessage.from(toolExecutionRequests);
        }
        return AiMessage.from((String)text);
    }

    public static TokenUsage toTokenUsage(AnthropicUsage anthropicUsage) {
        if (anthropicUsage == null) {
            return null;
        }
        return AnthropicTokenUsage.builder().inputTokenCount(anthropicUsage.inputTokens).outputTokenCount(anthropicUsage.outputTokens).cacheCreationInputTokens(anthropicUsage.cacheCreationInputTokens).cacheReadInputTokens(anthropicUsage.cacheReadInputTokens).build();
    }

    public static FinishReason toFinishReason(String anthropicStopReason) {
        if (anthropicStopReason == null) {
            return null;
        }
        return switch (anthropicStopReason) {
            case "end_turn", "stop_sequence" -> FinishReason.STOP;
            case "max_tokens" -> FinishReason.LENGTH;
            case "tool_use" -> FinishReason.TOOL_EXECUTION;
            default -> FinishReason.OTHER;
        };
    }

    public static List<AnthropicTool> toAnthropicTools(List<ToolSpecification> toolSpecifications, AnthropicCacheType cacheToolsPrompt) {
        return toolSpecifications.stream().map(toolSpecification -> AnthropicMapper.toAnthropicTool(toolSpecification, cacheToolsPrompt)).collect(Collectors.toList());
    }

    public static AnthropicTool toAnthropicTool(ToolSpecification toolSpecification, AnthropicCacheType cacheToolsPrompt) {
        JsonObjectSchema parameters = toolSpecification.parameters();
        AnthropicTool.Builder toolBuilder = AnthropicTool.builder().name(toolSpecification.name()).description(toolSpecification.description()).inputSchema(AnthropicToolSchema.builder().properties(parameters != null ? JsonSchemaElementUtils.toMap((Map)parameters.properties()) : Collections.emptyMap()).required(parameters != null ? parameters.required() : Collections.emptyList()).build());
        if (cacheToolsPrompt != AnthropicCacheType.NO_CACHE) {
            return toolBuilder.cacheControl(cacheToolsPrompt.cacheControl()).build();
        }
        return toolBuilder.build();
    }

    public static AnthropicToolChoice toAnthropicToolChoice(ToolChoice toolChoice) {
        if (toolChoice == null) {
            return null;
        }
        AnthropicToolChoiceType toolChoiceType = switch (toolChoice) {
            default -> throw new IncompatibleClassChangeError();
            case ToolChoice.AUTO -> AnthropicToolChoiceType.AUTO;
            case ToolChoice.REQUIRED -> AnthropicToolChoiceType.ANY;
        };
        return AnthropicToolChoice.from(toolChoiceType);
    }
}

