/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.client;

import dev.langchain4j.Internal;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.ToolCallBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.anthropic.AnthropicTokenUsage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicDelta;
import dev.langchain4j.model.anthropic.internal.api.AnthropicResponseMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicStreamingData;
import dev.langchain4j.model.anthropic.internal.api.AnthropicUsage;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.client.AnthropicCreateMessageOptions;
import dev.langchain4j.model.anthropic.internal.client.Json;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.PartialToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Internal
public class DefaultAnthropicClient
extends AnthropicClient {
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;
    private final String version;
    private final String beta;

    public static Builder builder() {
        return new Builder();
    }

    DefaultAnthropicClient(Builder builder) {
        HttpClientBuilder httpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)builder.httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.connectTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.connectTimeout())), (Object)Duration.ofSeconds(15L))).readTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.readTimeout())), (Object)Duration.ofSeconds(60L))).build();
        this.httpClient = builder.logRequests != null && builder.logRequests != false || builder.logResponses != null && builder.logResponses != false ? new LoggingHttpClient(httpClient, builder.logRequests, builder.logResponses) : httpClient;
        this.baseUrl = ValidationUtils.ensureNotBlank((String)builder.baseUrl, (String)"baseUrl");
        this.apiKey = ValidationUtils.ensureNotBlank((String)builder.apiKey, (String)"apiKey");
        this.version = ValidationUtils.ensureNotBlank((String)builder.version, (String)"version");
        this.beta = builder.beta;
    }

    @Override
    public AnthropicCreateMessageResponse createMessage(AnthropicCreateMessageRequest request) {
        HttpRequest httpRequest = this.toHttpRequest(request);
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return Json.fromJson(successfulHttpResponse.body(), AnthropicCreateMessageResponse.class);
    }

    @Override
    public void createMessage(AnthropicCreateMessageRequest request, final AnthropicCreateMessageOptions options, final StreamingChatResponseHandler handler) {
        ServerSentEventListener eventListener = new ServerSentEventListener(){
            final List<String> contents = Collections.synchronizedList(new ArrayList());
            final StringBuffer contentBuilder = new StringBuffer();
            final List<String> thinkings = Collections.synchronizedList(new ArrayList());
            final StringBuffer thinkingBuilder = new StringBuffer();
            final List<String> thinkingSignatures = Collections.synchronizedList(new ArrayList());
            final List<String> redactedThinkings = Collections.synchronizedList(new ArrayList());
            volatile String currentContentBlockStartType;
            final ToolCallBuilder toolCallBuilder = new ToolCallBuilder(-1);
            final AtomicInteger inputTokenCount = new AtomicInteger();
            final AtomicInteger outputTokenCount = new AtomicInteger();
            final AtomicInteger cacheCreationInputTokens = new AtomicInteger();
            final AtomicInteger cacheReadInputTokens = new AtomicInteger();
            final AtomicReference<String> responseId = new AtomicReference();
            final AtomicReference<String> responseModel = new AtomicReference();
            volatile String stopReason;

            public void onEvent(ServerSentEvent event) {
                AnthropicStreamingData data = Json.fromJson(event.data(), AnthropicStreamingData.class);
                if ("message_start".equals(event.event())) {
                    this.handleMessageStart(data);
                } else if ("content_block_start".equals(event.event())) {
                    this.handleContentBlockStart(data);
                } else if ("content_block_delta".equals(event.event())) {
                    this.handleContentBlockDelta(data);
                } else if ("content_block_stop".equals(event.event())) {
                    this.handleContentBlockStop();
                } else if ("message_delta".equals(event.event())) {
                    this.handleMessageDelta(data);
                } else if ("message_stop".equals(event.event())) {
                    this.handleMessageStop();
                } else if ("error".equals(event.event())) {
                    this.handleError(event.data());
                }
            }

            private void handleMessageStart(AnthropicStreamingData data) {
                AnthropicResponseMessage message = data.message;
                if (message != null) {
                    if (message.usage != null) {
                        this.handleUsage(message.usage);
                    }
                    if (message.id != null) {
                        this.responseId.set(message.id);
                    }
                    if (message.model != null) {
                        this.responseModel.set(message.model);
                    }
                }
            }

            private void handleUsage(AnthropicUsage usage) {
                if (usage.inputTokens != null) {
                    this.inputTokenCount.set(usage.inputTokens);
                }
                if (usage.outputTokens != null) {
                    this.outputTokenCount.set(usage.outputTokens);
                }
                if (usage.cacheCreationInputTokens != null) {
                    this.cacheCreationInputTokens.set(usage.cacheCreationInputTokens);
                }
                if (usage.cacheReadInputTokens != null) {
                    this.cacheReadInputTokens.set(usage.cacheReadInputTokens);
                }
            }

            private void handleContentBlockStart(AnthropicStreamingData data) {
                if (data.contentBlock == null) {
                    return;
                }
                this.currentContentBlockStartType = data.contentBlock.type;
                if ("text".equals(this.currentContentBlockStartType)) {
                    String text = data.contentBlock.text;
                    if (Utils.isNotNullOrEmpty((String)text)) {
                        this.contentBuilder.append(text);
                        InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)handler, (String)text);
                    }
                } else if ("thinking".equals(this.currentContentBlockStartType) && options.returnThinking()) {
                    String signature;
                    String thinking = data.contentBlock.thinking;
                    if (Utils.isNotNullOrEmpty((String)thinking)) {
                        this.thinkingBuilder.append(thinking);
                        InternalStreamingChatResponseHandlerUtils.onPartialThinking((StreamingChatResponseHandler)handler, (String)thinking);
                    }
                    if (Utils.isNotNullOrEmpty((String)(signature = data.contentBlock.signature))) {
                        this.thinkingSignatures.add(signature);
                    }
                } else if ("redacted_thinking".equals(this.currentContentBlockStartType) && options.returnThinking()) {
                    String redactedThinking = data.contentBlock.data;
                    if (Utils.isNotNullOrEmpty((String)redactedThinking)) {
                        this.redactedThinkings.add(redactedThinking);
                    }
                } else if ("tool_use".equals(this.currentContentBlockStartType)) {
                    this.toolCallBuilder.updateIndex(Integer.valueOf(this.toolCallBuilder.index() + 1));
                    this.toolCallBuilder.updateId(data.contentBlock.id);
                    this.toolCallBuilder.updateName(data.contentBlock.name);
                }
            }

            private void handleContentBlockDelta(AnthropicStreamingData data) {
                String partialJson;
                if (data.delta == null) {
                    return;
                }
                if ("text".equals(this.currentContentBlockStartType)) {
                    String text = data.delta.text;
                    if (Utils.isNotNullOrEmpty((String)text)) {
                        this.contentBuilder.append(text);
                        InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)handler, (String)text);
                    }
                } else if ("thinking".equals(this.currentContentBlockStartType) && options.returnThinking()) {
                    String signature;
                    String thinking = data.delta.thinking;
                    if (Utils.isNotNullOrEmpty((String)thinking)) {
                        this.thinkingBuilder.append(thinking);
                        InternalStreamingChatResponseHandlerUtils.onPartialThinking((StreamingChatResponseHandler)handler, (String)thinking);
                    }
                    if (Utils.isNotNullOrEmpty((String)(signature = data.delta.signature))) {
                        this.thinkingSignatures.add(signature);
                    }
                } else if ("redacted_thinking".equals(this.currentContentBlockStartType) && options.returnThinking()) {
                    String redactedThinking = data.delta.data;
                    if (Utils.isNotNullOrEmpty((String)redactedThinking)) {
                        this.redactedThinkings.add(redactedThinking);
                    }
                } else if ("tool_use".equals(this.currentContentBlockStartType) && Utils.isNotNullOrEmpty((String)(partialJson = data.delta.partialJson))) {
                    this.toolCallBuilder.appendArguments(partialJson);
                    PartialToolCall partialToolRequest = PartialToolCall.builder().index(this.toolCallBuilder.index()).id(this.toolCallBuilder.id()).name(this.toolCallBuilder.name()).partialArguments(partialJson).build();
                    InternalStreamingChatResponseHandlerUtils.onPartialToolCall((StreamingChatResponseHandler)handler, (PartialToolCall)partialToolRequest);
                }
            }

            private void handleContentBlockStop() {
                if ("text".equals(this.currentContentBlockStartType)) {
                    this.contents.add(this.contentBuilder.toString());
                    this.contentBuilder.setLength(0);
                } else if ("thinking".equals(this.currentContentBlockStartType) && options.returnThinking()) {
                    this.thinkings.add(this.thinkingBuilder.toString());
                    this.thinkingBuilder.setLength(0);
                } else if ("tool_use".equals(this.currentContentBlockStartType)) {
                    CompleteToolCall completeToolCall = this.toolCallBuilder.buildAndReset();
                    if (completeToolCall.toolExecutionRequest().arguments().equals("{}")) {
                        PartialToolCall partialToolRequest = PartialToolCall.builder().index(completeToolCall.index()).id(completeToolCall.toolExecutionRequest().id()).name(completeToolCall.toolExecutionRequest().name()).partialArguments(completeToolCall.toolExecutionRequest().arguments()).build();
                        InternalStreamingChatResponseHandlerUtils.onPartialToolCall((StreamingChatResponseHandler)handler, (PartialToolCall)partialToolRequest);
                    }
                    InternalStreamingChatResponseHandlerUtils.onCompleteToolCall((StreamingChatResponseHandler)handler, (CompleteToolCall)completeToolCall);
                }
            }

            private void handleMessageDelta(AnthropicStreamingData data) {
                if (data.delta != null) {
                    AnthropicDelta delta = data.delta;
                    if (delta.stopReason != null) {
                        this.stopReason = delta.stopReason;
                    }
                }
                if (data.usage != null) {
                    this.handleUsage(data.usage);
                }
            }

            private void handleMessageStop() {
                ChatResponse completeResponse = this.build();
                InternalStreamingChatResponseHandlerUtils.onCompleteResponse((StreamingChatResponseHandler)handler, (ChatResponse)completeResponse);
            }

            private ChatResponse build() {
                String text = this.contents.stream().filter(content -> !content.isEmpty()).collect(Collectors.joining("\n"));
                String thinking = this.thinkings.stream().filter(content -> !content.isEmpty()).collect(Collectors.joining("\n"));
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                String thinkingSignature = this.thinkingSignatures.stream().filter(content -> !content.isEmpty()).collect(Collectors.joining("\n"));
                if (Utils.isNotNullOrBlank((String)thinkingSignature)) {
                    attributes.put("thinking_signature", thinkingSignature);
                }
                if (!this.redactedThinkings.isEmpty()) {
                    attributes.put("redacted_thinking", this.redactedThinkings);
                }
                List toolExecutionRequests = List.of();
                if (this.toolCallBuilder.hasRequests()) {
                    toolExecutionRequests = this.toolCallBuilder.allRequests();
                }
                AnthropicTokenUsage tokenUsage = AnthropicTokenUsage.builder().inputTokenCount(this.inputTokenCount.get()).outputTokenCount(this.outputTokenCount.get()).cacheCreationInputTokens(this.cacheCreationInputTokens.get()).cacheReadInputTokens(this.cacheReadInputTokens.get()).build();
                FinishReason finishReason = AnthropicMapper.toFinishReason(this.stopReason);
                ChatResponseMetadata chatResponseMetadata = this.createMetadata(tokenUsage, finishReason);
                AiMessage aiMessage = AiMessage.builder().text(Utils.isNullOrEmpty((String)text) ? null : text).thinking(Utils.isNullOrEmpty((String)thinking) ? null : thinking).toolExecutionRequests(toolExecutionRequests).attributes(attributes).build();
                return ChatResponse.builder().aiMessage(aiMessage).metadata(chatResponseMetadata).build();
            }

            private ChatResponseMetadata createMetadata(AnthropicTokenUsage tokenUsage, FinishReason finishReason) {
                ChatResponseMetadata.Builder metadataBuilder = ChatResponseMetadata.builder();
                if (this.responseId.get() != null) {
                    metadataBuilder.id(this.responseId.get());
                }
                if (this.responseModel.get() != null) {
                    metadataBuilder.modelName(this.responseModel.get());
                }
                if (tokenUsage != null) {
                    metadataBuilder.tokenUsage((TokenUsage)tokenUsage);
                }
                if (finishReason != null) {
                    metadataBuilder.finishReason(finishReason);
                }
                return metadataBuilder.build();
            }

            private void handleError(String dataString) {
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)new RuntimeException(dataString)));
            }

            public void onError(Throwable error) {
                RuntimeException mappedError = ExceptionMapper.DEFAULT.mapException(error);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedError));
            }
        };
        HttpRequest httpRequest = this.toHttpRequest(request);
        this.httpClient.execute(httpRequest, eventListener);
    }

    @Override
    public void createMessage(AnthropicCreateMessageRequest request, StreamingChatResponseHandler handler) {
        this.createMessage(request, new AnthropicCreateMessageOptions(false), handler);
    }

    private HttpRequest toHttpRequest(AnthropicCreateMessageRequest request) {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "messages").addHeader("Content-Type", new String[]{"application/json"}).addHeader("x-api-key", new String[]{this.apiKey}).addHeader("anthropic-version", new String[]{this.version}).body(Json.toJson(request));
        if (this.beta != null) {
            builder.addHeader("anthropic-beta", new String[]{this.beta});
        }
        return builder.build();
    }

    public static class Builder
    extends AnthropicClient.Builder<DefaultAnthropicClient, Builder> {
        @Override
        public DefaultAnthropicClient build() {
            return new DefaultAnthropicClient(this);
        }
    }
}

