/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.completion.CompletionChoice;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.ai4j.openai4j.shared.Usage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.net.Proxy;
import java.time.Duration;

public class AzureOpenAiLanguageModel
implements LanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final Double temperature;
    private final Integer maxRetries;
    private final Tokenizer tokenizer;

    public AzureOpenAiLanguageModel(String baseUrl, String apiVersion, String apiKey, Tokenizer tokenizer, Double temperature, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses) {
        timeout = timeout == null ? Duration.ofSeconds(60L) : timeout;
        this.client = OpenAiClient.builder().baseUrl(ValidationUtils.ensureNotBlank((String)baseUrl, (String)"baseUrl")).azureApiKey(apiKey).apiVersion(apiVersion).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).build();
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.tokenizer = tokenizer;
    }

    public Response<String> generate(String prompt) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).temperature(this.temperature).build();
        CompletionResponse response = (CompletionResponse)RetryUtils.withRetry(() -> (CompletionResponse)this.client.completion(request).execute(), (int)this.maxRetries);
        CompletionChoice completionChoice = (CompletionChoice)response.choices().get(0);
        return Response.from((Object)completionChoice.text(), (TokenUsage)InternalOpenAiHelper.tokenUsageFrom((Usage)response.usage()), (FinishReason)InternalOpenAiHelper.finishReasonFrom((String)completionChoice.finishReason()));
    }

    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String baseUrl;
        private String apiVersion;
        private String apiKey;
        private Tokenizer tokenizer;
        private Double temperature;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AzureOpenAiLanguageModel build() {
            return new AzureOpenAiLanguageModel(this.baseUrl, this.apiVersion, this.apiKey, this.tokenizer, this.temperature, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses);
        }
    }
}

