/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import dev.langchain4j.model.openai.OpenAiStreamingResponseBuilder;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.net.Proxy;
import java.time.Duration;

public class AzureOpenAiStreamingLanguageModel
implements StreamingLanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final Double temperature;
    private final Tokenizer tokenizer;

    public AzureOpenAiStreamingLanguageModel(String baseUrl, String apiVersion, String apiKey, Tokenizer tokenizer, Double temperature, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = OpenAiClient.builder().baseUrl(ValidationUtils.ensureNotBlank((String)baseUrl, (String)"baseUrl")).azureApiKey(apiKey).apiVersion(apiVersion).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logStreamingResponses(logResponses).build();
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.tokenizer = tokenizer;
    }

    public void generate(String prompt, StreamingResponseHandler<String> handler) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).temperature(this.temperature).build();
        Integer inputTokenCount = this.tokenizer == null ? null : Integer.valueOf(this.tokenizer.estimateTokenCountInText(prompt));
        OpenAiStreamingResponseBuilder responseBuilder = new OpenAiStreamingResponseBuilder(inputTokenCount);
        this.client.completion(request).onPartialResponse(partialResponse -> {
            responseBuilder.append(partialResponse);
            String token = partialResponse.text();
            if (token != null) {
                handler.onNext(token);
            }
        }).onComplete(() -> {
            Response response = responseBuilder.build();
            handler.onComplete(Response.from((Object)((AiMessage)response.content()).text(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason()));
        }).onError(arg_0 -> handler.onError(arg_0)).execute();
    }

    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String baseUrl;
        private String apiVersion;
        private String apiKey;
        private Tokenizer tokenizer;
        private Double temperature;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AzureOpenAiStreamingLanguageModel build() {
            return new AzureOpenAiStreamingLanguageModel(this.baseUrl, this.apiVersion, this.apiKey, this.tokenizer, this.temperature, this.timeout, this.proxy, this.logRequests, this.logResponses);
        }
    }
}

