/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.FunctionCallConfig;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.azure.spi.AzureOpenAiChatModelBuilderFactory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.TokenCountEstimator;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public class AzureOpenAiChatModel
implements ChatLanguageModel,
TokenCountEstimator {
    private OpenAIClient client;
    private final String deploymentName;
    private final Tokenizer tokenizer;
    private final Double temperature;
    private final Double topP;
    private final Integer maxTokens;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;

    public AzureOpenAiChatModel(OpenAIClient client, String deploymentName, Tokenizer tokenizer, Double temperature, Double topP, Integer maxTokens, List<String> stop, Double presencePenalty, Double frequencyPenalty) {
        this(deploymentName, tokenizer, temperature, topP, maxTokens, stop, presencePenalty, frequencyPenalty);
        this.client = client;
    }

    public AzureOpenAiChatModel(String endpoint, String serviceVersion, String apiKey, String deploymentName, Tokenizer tokenizer, Double temperature, Double topP, Integer maxTokens, List<String> stop, Double presencePenalty, Double frequencyPenalty, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        this(deploymentName, tokenizer, temperature, topP, maxTokens, stop, presencePenalty, frequencyPenalty);
        this.client = InternalAzureOpenAiHelper.setupOpenAIClient(endpoint, serviceVersion, apiKey, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
    }

    public AzureOpenAiChatModel(String endpoint, String serviceVersion, KeyCredential keyCredential, String deploymentName, Tokenizer tokenizer, Double temperature, Double topP, Integer maxTokens, List<String> stop, Double presencePenalty, Double frequencyPenalty, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        this(deploymentName, tokenizer, temperature, topP, maxTokens, stop, presencePenalty, frequencyPenalty);
        this.client = InternalAzureOpenAiHelper.setupOpenAIClient(endpoint, serviceVersion, keyCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
    }

    public AzureOpenAiChatModel(String endpoint, String serviceVersion, TokenCredential tokenCredential, String deploymentName, Tokenizer tokenizer, Double temperature, Double topP, Integer maxTokens, List<String> stop, Double presencePenalty, Double frequencyPenalty, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        this(deploymentName, tokenizer, temperature, topP, maxTokens, stop, presencePenalty, frequencyPenalty);
        this.client = InternalAzureOpenAiHelper.setupOpenAIClient(endpoint, serviceVersion, tokenCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
    }

    private AzureOpenAiChatModel(String deploymentName, Tokenizer tokenizer, Double temperature, Double topP, Integer maxTokens, List<String> stop, Double presencePenalty, Double frequencyPenalty) {
        this.deploymentName = (String)Utils.getOrDefault((Object)deploymentName, (Object)"gpt-35-turbo");
        this.tokenizer = (Tokenizer)Utils.getOrDefault((Object)tokenizer, (Object)new OpenAiTokenizer("gpt-3.5-turbo"));
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.generate(messages, toolSpecifications, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, Collections.singletonList(toolSpecification), toolSpecification);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted) {
        ChatCompletionsOptions options = new ChatCompletionsOptions(InternalAzureOpenAiHelper.toOpenAiMessages(messages)).setModel(this.deploymentName).setTemperature(this.temperature).setTopP(this.topP).setMaxTokens(this.maxTokens).setStop(this.stop).setPresencePenalty(this.presencePenalty).setFrequencyPenalty(this.frequencyPenalty);
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            options.setFunctions(InternalAzureOpenAiHelper.toFunctions(toolSpecifications));
        }
        if (toolThatMustBeExecuted != null) {
            options.setFunctionCall(new FunctionCallConfig(toolThatMustBeExecuted.name()));
        }
        ChatCompletions chatCompletions = this.client.getChatCompletions(this.deploymentName, options);
        return Response.from((Object)InternalAzureOpenAiHelper.aiMessageFrom(((ChatChoice)chatCompletions.getChoices().get(0)).getMessage()), (TokenUsage)InternalAzureOpenAiHelper.tokenUsageFrom(chatCompletions.getUsage()), (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(((ChatChoice)chatCompletions.getChoices().get(0)).getFinishReason()));
    }

    public int estimateTokenCount(List<ChatMessage> messages) {
        return this.tokenizer.estimateTokenCountInMessages(messages);
    }

    public static Builder builder() {
        return (Builder)ServiceHelper.loadFactoryService(AzureOpenAiChatModelBuilderFactory.class, Builder::new);
    }

    public static class Builder {
        private String endpoint;
        private String serviceVersion;
        private String apiKey;
        private KeyCredential keyCredential;
        private TokenCredential tokenCredential;
        private String deploymentName;
        private Tokenizer tokenizer;
        private Double temperature;
        private Double topP;
        private Integer maxTokens;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Duration timeout;
        private Integer maxRetries;
        private ProxyOptions proxyOptions;
        private boolean logRequestsAndResponses;
        private OpenAIClient openAIClient;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder nonAzureApiKey(String nonAzureApiKey) {
            this.keyCredential = new KeyCredential(nonAzureApiKey);
            this.endpoint = "https://api.openai.com/v1";
            return this;
        }

        public Builder tokenCredential(TokenCredential tokenCredential) {
            this.tokenCredential = tokenCredential;
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public Builder openAIClient(OpenAIClient openAIClient) {
            this.openAIClient = openAIClient;
            return this;
        }

        public AzureOpenAiChatModel build() {
            if (this.openAIClient == null) {
                if (this.tokenCredential != null) {
                    return new AzureOpenAiChatModel(this.endpoint, this.serviceVersion, this.tokenCredential, this.deploymentName, this.tokenizer, this.temperature, this.topP, this.maxTokens, this.stop, this.presencePenalty, this.frequencyPenalty, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses);
                }
                if (this.keyCredential != null) {
                    return new AzureOpenAiChatModel(this.endpoint, this.serviceVersion, this.keyCredential, this.deploymentName, this.tokenizer, this.temperature, this.topP, this.maxTokens, this.stop, this.presencePenalty, this.frequencyPenalty, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses);
                }
                return new AzureOpenAiChatModel(this.endpoint, this.serviceVersion, this.apiKey, this.deploymentName, this.tokenizer, this.temperature, this.topP, this.maxTokens, this.stop, this.presencePenalty, this.frequencyPenalty, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses);
            }
            return new AzureOpenAiChatModel(this.openAIClient, this.deploymentName, this.tokenizer, this.temperature, this.topP, this.maxTokens, this.stop, this.presencePenalty, this.frequencyPenalty);
        }
    }
}

