/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.EmbeddingItem;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.azure.spi.AzureOpenAiEmbeddingModelBuilderFactory;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class AzureOpenAiEmbeddingModel
implements EmbeddingModel,
TokenCountEstimator {
    private static final int BATCH_SIZE = 16;
    private OpenAIClient client;
    private final String deploymentName;
    private final Tokenizer tokenizer;

    private AzureOpenAiEmbeddingModel(OpenAIClient client, String deploymentName, Tokenizer tokenizer) {
        this(deploymentName, tokenizer);
        this.client = client;
    }

    public AzureOpenAiEmbeddingModel(String endpoint, String serviceVersion, String apiKey, String deploymentName, Tokenizer tokenizer, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        this(deploymentName, tokenizer);
        this.client = InternalAzureOpenAiHelper.setupOpenAIClient(endpoint, serviceVersion, apiKey, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
    }

    public AzureOpenAiEmbeddingModel(String endpoint, String serviceVersion, KeyCredential keyCredential, String deploymentName, Tokenizer tokenizer, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        this(deploymentName, tokenizer);
        this.client = InternalAzureOpenAiHelper.setupOpenAIClient(endpoint, serviceVersion, keyCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
    }

    public AzureOpenAiEmbeddingModel(String endpoint, String serviceVersion, TokenCredential tokenCredential, String deploymentName, Tokenizer tokenizer, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        this(deploymentName, tokenizer);
        this.client = InternalAzureOpenAiHelper.setupOpenAIClient(endpoint, serviceVersion, tokenCredential, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
    }

    private AzureOpenAiEmbeddingModel(String deploymentName, Tokenizer tokenizer) {
        this.deploymentName = (String)Utils.getOrDefault((Object)deploymentName, (Object)"text-embedding-ada-002");
        this.tokenizer = tokenizer;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<String> texts = textSegments.stream().map(TextSegment::text).collect(Collectors.toList());
        return this.embedTexts(texts);
    }

    private Response<List<Embedding>> embedTexts(List<String> texts) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int inputTokenCount = 0;
        for (int i = 0; i < texts.size(); i += 16) {
            List<String> batch = texts.subList(i, Math.min(i + 16, texts.size()));
            EmbeddingsOptions options = new EmbeddingsOptions(batch);
            Embeddings response = this.client.getEmbeddings(this.deploymentName, options);
            for (EmbeddingItem embeddingItem : response.getData()) {
                Embedding embedding = AzureOpenAiEmbeddingModel.from(embeddingItem.getEmbedding());
                embeddings.add(embedding);
            }
            inputTokenCount += response.getUsage().getPromptTokens();
        }
        return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(inputTokenCount)));
    }

    private static Embedding from(List<Double> vector) {
        float[] langChainVector = new float[vector.size()];
        for (int index = 0; index < vector.size(); ++index) {
            langChainVector[index] = vector.get(index).floatValue();
        }
        return Embedding.from((float[])langChainVector);
    }

    public int estimateTokenCount(String text) {
        return this.tokenizer.estimateTokenCountInText(text);
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(AzureOpenAiEmbeddingModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            AzureOpenAiEmbeddingModelBuilderFactory factory = (AzureOpenAiEmbeddingModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public static class Builder {
        private String endpoint;
        private String serviceVersion;
        private String apiKey;
        private KeyCredential keyCredential;
        private TokenCredential tokenCredential;
        private String deploymentName;
        private Tokenizer tokenizer;
        private Duration timeout;
        private Integer maxRetries;
        private ProxyOptions proxyOptions;
        private boolean logRequestsAndResponses;
        private OpenAIClient openAIClient;

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder nonAzureApiKey(String nonAzureApiKey) {
            this.keyCredential = new KeyCredential(nonAzureApiKey);
            this.endpoint = "https://api.openai.com/v1";
            return this;
        }

        public Builder tokenCredential(TokenCredential tokenCredential) {
            this.tokenCredential = tokenCredential;
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public Builder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder proxyOptions(ProxyOptions proxyOptions) {
            this.proxyOptions = proxyOptions;
            return this;
        }

        public Builder logRequestsAndResponses(boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this;
        }

        public Builder openAIClient(OpenAIClient openAIClient) {
            this.openAIClient = openAIClient;
            return this;
        }

        public AzureOpenAiEmbeddingModel build() {
            if (this.openAIClient == null) {
                if (this.tokenCredential != null) {
                    return new AzureOpenAiEmbeddingModel(this.endpoint, this.serviceVersion, this.tokenCredential, this.deploymentName, this.tokenizer, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses);
                }
                if (this.keyCredential != null) {
                    return new AzureOpenAiEmbeddingModel(this.endpoint, this.serviceVersion, this.keyCredential, this.deploymentName, this.tokenizer, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses);
                }
                return new AzureOpenAiEmbeddingModel(this.endpoint, this.serviceVersion, this.apiKey, this.deploymentName, this.tokenizer, this.timeout, this.maxRetries, this.proxyOptions, this.logRequestsAndResponses);
            }
            return new AzureOpenAiEmbeddingModel(this.openAIClient, this.deploymentName, this.tokenizer);
        }
    }
}

