/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.OpenAIServiceVersion;
import com.azure.ai.openai.models.ChatMessageImageContentItem;
import com.azure.ai.openai.models.ChatMessageImageUrl;
import com.azure.ai.openai.models.ChatMessageTextContentItem;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestFunctionMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.ai.openai.models.CompletionsUsage;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.ai.openai.models.ImageGenerationData;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientProvider;
import com.azure.core.http.policy.ExponentialBackoffOptions;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Header;
import com.azure.core.util.HttpClientOptions;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalAzureOpenAiHelper {
    private static final Logger logger = LoggerFactory.getLogger(InternalAzureOpenAiHelper.class);
    public static final String DEFAULT_USER_AGENT = "langchain4j-azure-openai";
    private static final Map<String, Object> NO_PARAMETER_DATA = new HashMap<String, Object>();

    InternalAzureOpenAiHelper() {
    }

    public static OpenAIClient setupOpenAIClient(String endpoint, String serviceVersion, String apiKey, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        OpenAIClientBuilder openAIClientBuilder = InternalAzureOpenAiHelper.setupOpenAIClientBuilder(endpoint, serviceVersion, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
        return openAIClientBuilder.credential((KeyCredential)new AzureKeyCredential(apiKey)).buildClient();
    }

    public static OpenAIClient setupOpenAIClient(String endpoint, String serviceVersion, KeyCredential keyCredential, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        OpenAIClientBuilder openAIClientBuilder = InternalAzureOpenAiHelper.setupOpenAIClientBuilder(endpoint, serviceVersion, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
        return openAIClientBuilder.credential(keyCredential).buildClient();
    }

    public static OpenAIClient setupOpenAIClient(String endpoint, String serviceVersion, TokenCredential tokenCredential, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        OpenAIClientBuilder openAIClientBuilder = InternalAzureOpenAiHelper.setupOpenAIClientBuilder(endpoint, serviceVersion, timeout, maxRetries, proxyOptions, logRequestsAndResponses);
        return openAIClientBuilder.credential(tokenCredential).buildClient();
    }

    private static OpenAIClientBuilder setupOpenAIClientBuilder(String endpoint, String serviceVersion, Duration timeout, Integer maxRetries, ProxyOptions proxyOptions, boolean logRequestsAndResponses) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        HttpClientOptions clientOptions = new HttpClientOptions();
        clientOptions.setConnectTimeout(timeout);
        clientOptions.setResponseTimeout(timeout);
        clientOptions.setReadTimeout(timeout);
        clientOptions.setWriteTimeout(timeout);
        clientOptions.setProxyOptions(proxyOptions);
        Header header = new Header("User-Agent", DEFAULT_USER_AGENT);
        clientOptions.setHeaders(Collections.singletonList(header));
        HttpClient httpClient = new NettyAsyncHttpClientProvider().createInstance(clientOptions);
        HttpLogOptions httpLogOptions = new HttpLogOptions();
        if (logRequestsAndResponses) {
            httpLogOptions.setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS);
        }
        maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        ExponentialBackoffOptions exponentialBackoffOptions = new ExponentialBackoffOptions();
        exponentialBackoffOptions.setMaxRetries(maxRetries);
        RetryOptions retryOptions = new RetryOptions(exponentialBackoffOptions);
        return new OpenAIClientBuilder().endpoint(ValidationUtils.ensureNotBlank((String)endpoint, (String)"endpoint")).serviceVersion(InternalAzureOpenAiHelper.getOpenAIServiceVersion(serviceVersion)).httpClient(httpClient).clientOptions((ClientOptions)clientOptions).httpLogOptions(httpLogOptions).retryOptions(retryOptions);
    }

    private static OpenAIClientBuilder authenticate(TokenCredential tokenCredential) {
        return new OpenAIClientBuilder().credential(tokenCredential);
    }

    public static OpenAIServiceVersion getOpenAIServiceVersion(String serviceVersion) {
        for (OpenAIServiceVersion version : OpenAIServiceVersion.values()) {
            if (!version.getVersion().equals(serviceVersion)) continue;
            return version;
        }
        return OpenAIServiceVersion.getLatest();
    }

    public static List<ChatRequestMessage> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(InternalAzureOpenAiHelper::toOpenAiMessage).collect(Collectors.toList());
    }

    public static ChatRequestMessage toOpenAiMessage(ChatMessage message) {
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            ChatRequestAssistantMessage chatRequestAssistantMessage = new ChatRequestAssistantMessage((String)Utils.getOrDefault((Object)aiMessage.text(), (Object)""));
            chatRequestAssistantMessage.setFunctionCall(InternalAzureOpenAiHelper.functionCallFrom(message));
            return chatRequestAssistantMessage;
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            return new ChatRequestFunctionMessage(InternalAzureOpenAiHelper.nameFrom(message), toolExecutionResultMessage.text());
        }
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            return new ChatRequestSystemMessage(systemMessage.text());
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            ChatRequestUserMessage chatRequestUserMessage = userMessage.hasSingleText() ? new ChatRequestUserMessage(((TextContent)userMessage.contents().get(0)).text()) : new ChatRequestUserMessage(userMessage.contents().stream().map(content -> {
                if (content instanceof TextContent) {
                    String text = ((TextContent)content).text();
                    return new ChatMessageTextContentItem(text);
                }
                if (content instanceof ImageContent) {
                    ImageContent imageContent = (ImageContent)content;
                    if (imageContent.image().url() == null) {
                        throw new IllegalArgumentException("Image URL is not present. Base64 encoded images are not supported at the moment.");
                    }
                    ChatMessageImageUrl imageUrl = new ChatMessageImageUrl(imageContent.image().url().toString());
                    return new ChatMessageImageContentItem(imageUrl);
                }
                throw new IllegalArgumentException("Unsupported content type: " + content.type());
            }).collect(Collectors.toList()));
            chatRequestUserMessage.setName(InternalAzureOpenAiHelper.nameFrom(message));
            return chatRequestUserMessage;
        }
        throw new IllegalArgumentException("Unsupported message type: " + message.type());
    }

    private static String nameFrom(ChatMessage message) {
        if (message instanceof UserMessage) {
            return ((UserMessage)message).name();
        }
        if (message instanceof ToolExecutionResultMessage) {
            return ((ToolExecutionResultMessage)message).toolName();
        }
        return null;
    }

    private static FunctionCall functionCallFrom(ChatMessage message) {
        AiMessage aiMessage;
        if (message instanceof AiMessage && (aiMessage = (AiMessage)message).hasToolExecutionRequests()) {
            ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
            return new FunctionCall(toolExecutionRequest.name(), toolExecutionRequest.arguments());
        }
        return null;
    }

    public static List<FunctionDefinition> toFunctions(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(InternalAzureOpenAiHelper::toFunction).collect(Collectors.toList());
    }

    private static FunctionDefinition toFunction(ToolSpecification toolSpecification) {
        FunctionDefinition functionDefinition = new FunctionDefinition(toolSpecification.name());
        functionDefinition.setDescription(toolSpecification.description());
        functionDefinition.setParameters(InternalAzureOpenAiHelper.toOpenAiParameters(toolSpecification.parameters()));
        return functionDefinition;
    }

    private static BinaryData toOpenAiParameters(ToolParameters toolParameters) {
        Parameters parameters = new Parameters();
        if (toolParameters == null) {
            return BinaryData.fromObject(NO_PARAMETER_DATA);
        }
        parameters.setProperties(toolParameters.properties());
        parameters.setRequired(toolParameters.required());
        return BinaryData.fromObject((Object)parameters);
    }

    public static AiMessage aiMessageFrom(ChatResponseMessage chatResponseMessage) {
        if (chatResponseMessage.getContent() != null) {
            return AiMessage.aiMessage((String)chatResponseMessage.getContent());
        }
        FunctionCall functionCall = chatResponseMessage.getFunctionCall();
        ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(functionCall.getName()).arguments(functionCall.getArguments()).build();
        return AiMessage.aiMessage((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest});
    }

    public static Image imageFrom(ImageGenerationData imageGenerationData) {
        Image.Builder imageBuilder = Image.builder().revisedPrompt(imageGenerationData.getRevisedPrompt());
        String urlString = imageGenerationData.getUrl();
        String imageData = imageGenerationData.getBase64Data();
        if (urlString != null) {
            try {
                URI uri = new URI(urlString);
                imageBuilder.url(uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else if (imageData != null) {
            imageBuilder.base64Data(imageData);
        }
        return imageBuilder.build();
    }

    public static TokenUsage tokenUsageFrom(CompletionsUsage openAiUsage) {
        if (openAiUsage == null) {
            return null;
        }
        return new TokenUsage(Integer.valueOf(openAiUsage.getPromptTokens()), Integer.valueOf(openAiUsage.getCompletionTokens()), Integer.valueOf(openAiUsage.getTotalTokens()));
    }

    public static FinishReason finishReasonFrom(CompletionsFinishReason openAiFinishReason) {
        if (openAiFinishReason == null) {
            return null;
        }
        if (openAiFinishReason == CompletionsFinishReason.STOPPED) {
            return FinishReason.STOP;
        }
        if (openAiFinishReason == CompletionsFinishReason.TOKEN_LIMIT_REACHED) {
            return FinishReason.LENGTH;
        }
        if (openAiFinishReason == CompletionsFinishReason.CONTENT_FILTERED) {
            return FinishReason.CONTENT_FILTER;
        }
        if (openAiFinishReason == CompletionsFinishReason.FUNCTION_CALL) {
            return FinishReason.TOOL_EXECUTION;
        }
        return null;
    }

    public static FinishReason contentFilterManagement(HttpResponseException httpResponseException, String contentFilterCode) {
        FinishReason exceptionFinishReason = FinishReason.OTHER;
        if (httpResponseException.getValue() instanceof Map) {
            try {
                String code;
                Map errorDetails;
                Object errorCode;
                Map error = (Map)httpResponseException.getValue();
                Object errorMap = error.get("error");
                if (errorMap instanceof Map && (errorCode = (errorDetails = (Map)errorMap).get("code")) instanceof String && contentFilterCode.equals(code = (String)errorCode)) {
                    exceptionFinishReason = FinishReason.CONTENT_FILTER;
                }
            }
            catch (ClassCastException classCastException) {
                logger.error("Error parsing error response from Azure OpenAI", (Throwable)classCastException);
            }
        }
        return exceptionFinishReason;
    }

    static {
        NO_PARAMETER_DATA.put("type", "object");
        NO_PARAMETER_DATA.put("properties", new HashMap());
    }

    private static class Parameters {
        private final String type = "object";
        private Map<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        private List<String> required = new ArrayList<String>();

        private Parameters() {
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Map<String, Object>> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Map<String, Object>> properties) {
            this.properties = properties;
        }

        public List<String> getRequired() {
            return this.required;
        }

        public void setRequired(List<String> required) {
            this.required = required;
        }
    }
}

