/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.Choice;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsFinishReason;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.azure.InternalAzureOpenAiHelper;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureOpenAiStreamingResponseBuilder {
    Logger logger = LoggerFactory.getLogger(AzureOpenAiStreamingResponseBuilder.class);
    private final StringBuffer contentBuilder = new StringBuffer();
    private final StringBuffer toolNameBuilder = new StringBuffer();
    private final StringBuffer toolArgumentsBuilder = new StringBuffer();
    private String toolExecutionsIndex = "call_undefined";
    private final Map<String, ToolExecutionRequestBuilder> toolExecutionRequestBuilderHashMap = new HashMap<String, ToolExecutionRequestBuilder>();
    private volatile CompletionsFinishReason finishReason;
    private final Integer inputTokenCount;

    public AzureOpenAiStreamingResponseBuilder(Integer inputTokenCount) {
        this.inputTokenCount = inputTokenCount;
    }

    public void append(ChatCompletions completions) {
        ChatResponseMessage delta;
        if (completions == null) {
            return;
        }
        List choices = completions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        ChatChoice chatCompletionChoice = (ChatChoice)choices.get(0);
        if (chatCompletionChoice == null) {
            return;
        }
        CompletionsFinishReason finishReason = chatCompletionChoice.getFinishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((delta = chatCompletionChoice.getDelta()) == null) {
            return;
        }
        String content = delta.getContent();
        if (content != null) {
            this.contentBuilder.append(content);
            return;
        }
        if (delta.getToolCalls() != null && !delta.getToolCalls().isEmpty()) {
            for (ChatCompletionsToolCall toolCall : delta.getToolCalls()) {
                ToolExecutionRequestBuilder toolExecutionRequestBuilder;
                if (toolCall.getId() != null) {
                    this.toolExecutionsIndex = toolCall.getId();
                    toolExecutionRequestBuilder = new ToolExecutionRequestBuilder();
                    toolExecutionRequestBuilder.idBuilder.append(this.toolExecutionsIndex);
                    this.toolExecutionRequestBuilderHashMap.put(this.toolExecutionsIndex, toolExecutionRequestBuilder);
                } else {
                    toolExecutionRequestBuilder = this.toolExecutionRequestBuilderHashMap.get(this.toolExecutionsIndex);
                    if (toolExecutionRequestBuilder == null) {
                        throw new IllegalStateException("Function without an id defined in the tool call");
                    }
                }
                if (!(toolCall instanceof ChatCompletionsFunctionToolCall)) continue;
                ChatCompletionsFunctionToolCall functionCall = (ChatCompletionsFunctionToolCall)toolCall;
                if (functionCall.getFunction().getName() != null) {
                    toolExecutionRequestBuilder.nameBuilder.append(functionCall.getFunction().getName());
                }
                if (functionCall.getFunction().getArguments() == null) continue;
                toolExecutionRequestBuilder.argumentsBuilder.append(functionCall.getFunction().getArguments());
            }
        }
    }

    public void append(Completions completions) {
        String token;
        if (completions == null) {
            return;
        }
        List choices = completions.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        Choice completionChoice = (Choice)choices.get(0);
        if (completionChoice == null) {
            return;
        }
        CompletionsFinishReason completionsFinishReason = completionChoice.getFinishReason();
        if (completionsFinishReason != null) {
            this.finishReason = completionsFinishReason;
        }
        if ((token = completionChoice.getText()) != null) {
            this.contentBuilder.append(token);
        }
    }

    public Response<AiMessage> build(Tokenizer tokenizer, boolean forcefulToolExecution) {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return Response.from((Object)AiMessage.from((String)content), (TokenUsage)this.tokenUsage(content, tokenizer), (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(this.finishReason));
        }
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            return Response.from((Object)AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest}), (TokenUsage)this.tokenUsage(Collections.singletonList(toolExecutionRequest), tokenizer, forcefulToolExecution), (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(this.finishReason));
        }
        if (!this.toolExecutionRequestBuilderHashMap.isEmpty()) {
            List<ToolExecutionRequest> toolExecutionRequests = this.toolExecutionRequestBuilderHashMap.values().stream().map(it -> ToolExecutionRequest.builder().id(((ToolExecutionRequestBuilder)it).idBuilder.toString()).name(((ToolExecutionRequestBuilder)it).nameBuilder.toString()).arguments(((ToolExecutionRequestBuilder)it).argumentsBuilder.toString()).build()).collect(Collectors.toList());
            return Response.from((Object)AiMessage.from(toolExecutionRequests), (TokenUsage)this.tokenUsage(toolExecutionRequests, tokenizer, forcefulToolExecution), (FinishReason)InternalAzureOpenAiHelper.finishReasonFrom(this.finishReason));
        }
        return null;
    }

    private TokenUsage tokenUsage(String content, Tokenizer tokenizer) {
        if (tokenizer == null) {
            return null;
        }
        int outputTokenCount = tokenizer.estimateTokenCountInText(content);
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
    }

    private TokenUsage tokenUsage(List<ToolExecutionRequest> toolExecutionRequests, Tokenizer tokenizer, boolean forcefulToolExecution) {
        if (tokenizer == null) {
            return null;
        }
        int outputTokenCount = 0;
        if (forcefulToolExecution) {
            for (ToolExecutionRequest toolExecutionRequest : toolExecutionRequests) {
                outputTokenCount += tokenizer.estimateTokenCountInForcefulToolExecutionRequest(toolExecutionRequest);
            }
        } else {
            outputTokenCount = tokenizer.estimateTokenCountInToolExecutionRequests(toolExecutionRequests);
        }
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuffer idBuilder = new StringBuffer();
        private final StringBuffer nameBuilder = new StringBuffer();
        private final StringBuffer argumentsBuilder = new StringBuffer();

        private ToolExecutionRequestBuilder() {
        }
    }
}

