/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.azure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.azure.AzureOpenAiChatModelName;
import dev.langchain4j.model.azure.AzureOpenAiEmbeddingModelName;
import dev.langchain4j.model.azure.AzureOpenAiLanguageModelName;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class AzureOpenAiTokenCountEstimator
implements TokenCountEstimator {
    private final String modelName;
    private final Optional<Encoding> encoding;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Deprecated(forRemoval=true)
    public AzureOpenAiTokenCountEstimator() {
        this(AzureOpenAiChatModelName.GPT_3_5_TURBO.modelType());
    }

    public AzureOpenAiTokenCountEstimator(AzureOpenAiChatModelName modelName) {
        this(modelName.modelType());
    }

    public AzureOpenAiTokenCountEstimator(AzureOpenAiEmbeddingModelName modelName) {
        this(modelName.modelType());
    }

    public AzureOpenAiTokenCountEstimator(AzureOpenAiLanguageModelName modelName) {
        this(modelName.modelType());
    }

    public AzureOpenAiTokenCountEstimator(String modelName) {
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.encoding = Encodings.newLazyEncodingRegistry().getEncodingForModel(modelName);
    }

    public int estimateTokenCountInText(String text) {
        return this.encoding.orElseThrow(this.unknownModelException()).countTokensOrdinary(text);
    }

    public int estimateTokenCountInMessage(ChatMessage message) {
        int tokenCount = 1;
        tokenCount += this.extraTokensPerMessage();
        if (message instanceof SystemMessage) {
            tokenCount += this.estimateTokenCountIn((SystemMessage)message);
        } else if (message instanceof UserMessage) {
            tokenCount += this.estimateTokenCountIn((UserMessage)message);
        } else if (message instanceof AiMessage) {
            tokenCount += this.estimateTokenCountIn((AiMessage)message);
        } else if (message instanceof ToolExecutionResultMessage) {
            tokenCount += this.estimateTokenCountIn((ToolExecutionResultMessage)message);
        } else {
            throw new IllegalArgumentException("Unknown message type: " + String.valueOf(message));
        }
        return tokenCount;
    }

    private int estimateTokenCountIn(SystemMessage systemMessage) {
        return this.estimateTokenCountInText(systemMessage.text());
    }

    private int estimateTokenCountIn(UserMessage userMessage) {
        int tokenCount = 0;
        for (Content content : userMessage.contents()) {
            if (content instanceof TextContent) {
                tokenCount += this.estimateTokenCountInText(((TextContent)content).text());
                continue;
            }
            if (content instanceof ImageContent) {
                tokenCount += 85;
                continue;
            }
            throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(content)), (Object[])new Object[0]);
        }
        if (userMessage.name() != null && !this.modelName.equals(AzureOpenAiChatModelName.GPT_4_VISION_PREVIEW.toString())) {
            tokenCount += this.extraTokensPerName();
            tokenCount += this.estimateTokenCountInText(userMessage.name());
        }
        return tokenCount;
    }

    private int estimateTokenCountIn(AiMessage aiMessage) {
        int tokenCount = 0;
        if (aiMessage.text() != null) {
            tokenCount += this.estimateTokenCountInText(aiMessage.text());
        }
        if (aiMessage.hasToolExecutionRequests()) {
            tokenCount = this.isOneOfLatestModels() ? (tokenCount += 6) : (tokenCount += 3);
            if (aiMessage.toolExecutionRequests().size() == 1) {
                --tokenCount;
                ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
                tokenCount += this.estimateTokenCountInText(toolExecutionRequest.name()) * 2;
                tokenCount += this.estimateTokenCountInText(toolExecutionRequest.arguments());
            } else {
                tokenCount += 15;
                for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                    Map arguments;
                    tokenCount += 7;
                    tokenCount += this.estimateTokenCountInText(toolExecutionRequest.name());
                    try {
                        arguments = (Map)OBJECT_MAPPER.readValue(toolExecutionRequest.arguments(), Map.class);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                    for (Map.Entry argument : arguments.entrySet()) {
                        tokenCount += 2;
                        tokenCount += this.estimateTokenCountInText(argument.getKey().toString());
                        tokenCount += this.estimateTokenCountInText(argument.getValue().toString());
                    }
                }
            }
        }
        return tokenCount;
    }

    private int estimateTokenCountIn(ToolExecutionResultMessage toolExecutionResultMessage) {
        return this.estimateTokenCountInText(toolExecutionResultMessage.text());
    }

    private int extraTokensPerMessage() {
        if (this.modelName.equals(AzureOpenAiChatModelName.GPT_3_5_TURBO_0301.modelName())) {
            return 4;
        }
        return 3;
    }

    private int extraTokensPerName() {
        if (this.modelName.equals(AzureOpenAiChatModelName.GPT_3_5_TURBO_0301.toString())) {
            return -1;
        }
        return 1;
    }

    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        int tokenCount = 3;
        for (ChatMessage message : messages) {
            tokenCount += this.estimateTokenCountInMessage(message);
        }
        return tokenCount;
    }

    private Supplier<IllegalArgumentException> unknownModelException() {
        return () -> Exceptions.illegalArgument((String)"Model '%s' is unknown to jtokkit", (Object[])new Object[]{this.modelName});
    }

    private boolean isOneOfLatestModels() {
        return this.isOneOfLatestGpt3Models() || this.isOneOfLatestGpt4Models();
    }

    private boolean isOneOfLatestGpt3Models() {
        return this.modelName.equals(AzureOpenAiChatModelName.GPT_3_5_TURBO_1106.toString()) || this.modelName.equals(AzureOpenAiChatModelName.GPT_3_5_TURBO.toString());
    }

    private boolean isOneOfLatestGpt4Models() {
        return this.modelName.equals(AzureOpenAiChatModelName.GPT_4_TURBO.toString()) || this.modelName.equals(AzureOpenAiChatModelName.GPT_4_1106_PREVIEW.toString()) || this.modelName.equals(AzureOpenAiChatModelName.GPT_4_0125_PREVIEW.toString());
    }
}

