/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Json;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.bedrock.BedrockAnthropicContent;
import dev.langchain4j.model.bedrock.BedrockAnthropicImageSource;
import dev.langchain4j.model.bedrock.BedrockAnthropicMessage;
import dev.langchain4j.model.bedrock.BedrockAnthropicMessageChatModelResponse;
import dev.langchain4j.model.bedrock.internal.AbstractBedrockChatModel;
import dev.langchain4j.model.output.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public class BedrockAnthropicMessageChatModel
extends AbstractBedrockChatModel<BedrockAnthropicMessageChatModelResponse> {
    private static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";
    private final int topK;
    private final String anthropicVersion;
    private final String model;

    @Override
    protected String getModelId() {
        return this.model;
    }

    @Override
    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(9);
        parameters.put("max_tokens", this.getMaxTokens());
        parameters.put("temperature", Float.valueOf(this.getTemperature()));
        parameters.put("top_k", this.topK);
        parameters.put("top_p", Float.valueOf(this.getTopP()));
        parameters.put("stop_sequences", this.getStopSequences());
        parameters.put("anthropic_version", this.anthropicVersion);
        return parameters;
    }

    @Override
    public Response<AiMessage> generate(List<ChatMessage> messages) {
        String system = this.getAnthropicSystemPrompt(messages);
        List<BedrockAnthropicMessage> formattedMessages = this.getAnthropicMessages(messages);
        Map<String, Object> parameters = this.getRequestParameters(null);
        parameters.put("messages", formattedMessages);
        parameters.put("system", system);
        String body = Json.toJson(parameters);
        InvokeModelResponse invokeModelResponse = (InvokeModelResponse)RetryUtils.withRetry(() -> this.invoke(body), (int)this.getMaxRetries());
        String response = invokeModelResponse.body().asUtf8String();
        BedrockAnthropicMessageChatModelResponse result = (BedrockAnthropicMessageChatModelResponse)Json.fromJson((String)response, this.getResponseClassType());
        return new Response((Object)new AiMessage(result.getOutputText()), result.getTokenUsage(), result.getFinishReason());
    }

    private List<BedrockAnthropicMessage> getAnthropicMessages(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message.type() != ChatMessageType.SYSTEM).map(message -> new BedrockAnthropicMessage(this.getAnthropicRole((ChatMessage)message), this.getAnthropicContent((ChatMessage)message))).collect(Collectors.toList());
    }

    private List<BedrockAnthropicContent> getAnthropicContent(ChatMessage message) {
        if (message instanceof AiMessage) {
            return Collections.singletonList(new BedrockAnthropicContent("text", ((AiMessage)message).text()));
        }
        if (message instanceof UserMessage) {
            return ((UserMessage)message).contents().stream().map(BedrockAnthropicMessageChatModel::mapContentToAnthropic).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Unknown message type: " + message.type());
    }

    private static BedrockAnthropicContent mapContentToAnthropic(Content content) {
        if (content instanceof TextContent) {
            return new BedrockAnthropicContent("text", ((TextContent)content).text());
        }
        if (content instanceof ImageContent) {
            ImageContent imageContent = (ImageContent)content;
            if (imageContent.image().url() != null) {
                throw new IllegalArgumentException("Anthropic does not support images as URLs, only as Base64-encoded strings");
            }
            BedrockAnthropicImageSource imageSource = new BedrockAnthropicImageSource("base64", ValidationUtils.ensureNotBlank((String)imageContent.image().mimeType(), (String)"mimeType"), ValidationUtils.ensureNotBlank((String)imageContent.image().base64Data(), (String)"base64Data"));
            return new BedrockAnthropicContent("image", imageSource);
        }
        throw new IllegalArgumentException("Unknown content type: " + content);
    }

    private String getAnthropicSystemPrompt(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message.type() == ChatMessageType.SYSTEM).map(ChatMessage::text).collect(Collectors.joining("\n"));
    }

    private String getAnthropicRole(ChatMessage message) {
        return message.type() == ChatMessageType.AI ? "assistant" : "user";
    }

    @Override
    public Class<BedrockAnthropicMessageChatModelResponse> getResponseClassType() {
        return BedrockAnthropicMessageChatModelResponse.class;
    }

    private static int $default$topK() {
        return 250;
    }

    private static String $default$anthropicVersion() {
        return DEFAULT_ANTHROPIC_VERSION;
    }

    private static String $default$model() {
        return Types.AnthropicClaude3SonnetV1.getValue();
    }

    protected BedrockAnthropicMessageChatModel(BedrockAnthropicMessageChatModelBuilder<?, ?> b) {
        super(b);
        this.topK = ((BedrockAnthropicMessageChatModelBuilder)b).topK$set ? ((BedrockAnthropicMessageChatModelBuilder)b).topK$value : BedrockAnthropicMessageChatModel.$default$topK();
        this.anthropicVersion = ((BedrockAnthropicMessageChatModelBuilder)b).anthropicVersion$set ? ((BedrockAnthropicMessageChatModelBuilder)b).anthropicVersion$value : BedrockAnthropicMessageChatModel.$default$anthropicVersion();
        this.model = ((BedrockAnthropicMessageChatModelBuilder)b).model$set ? ((BedrockAnthropicMessageChatModelBuilder)b).model$value : BedrockAnthropicMessageChatModel.$default$model();
    }

    public static BedrockAnthropicMessageChatModelBuilder<?, ?> builder() {
        return new BedrockAnthropicMessageChatModelBuilderImpl();
    }

    public int getTopK() {
        return this.topK;
    }

    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    public String getModel() {
        return this.model;
    }

    public static enum Types {
        AnthropicClaudeInstantV1("anthropic.claude-instant-v1"),
        AnthropicClaudeV2("anthropic.claude-v2"),
        AnthropicClaudeV2_1("anthropic.claude-v2:1"),
        AnthropicClaude3SonnetV1("anthropic.claude-3-sonnet-20240229-v1:0"),
        AnthropicClaude3HaikuV1("anthropic.claude-3-haiku-20240307-v1:0");

        private final String value;

        private Types(String modelID) {
            this.value = modelID;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class BedrockAnthropicMessageChatModelBuilder<C extends BedrockAnthropicMessageChatModel, B extends BedrockAnthropicMessageChatModelBuilder<C, B>>
    extends AbstractBedrockChatModel.AbstractBedrockChatModelBuilder<BedrockAnthropicMessageChatModelResponse, C, B> {
        private boolean topK$set;
        private int topK$value;
        private boolean anthropicVersion$set;
        private String anthropicVersion$value;
        private boolean model$set;
        private String model$value;

        public B topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return (B)this.self();
        }

        public B anthropicVersion(String anthropicVersion) {
            this.anthropicVersion$value = anthropicVersion;
            this.anthropicVersion$set = true;
            return (B)this.self();
        }

        public B model(String model) {
            this.model$value = model;
            this.model$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BedrockAnthropicMessageChatModel.BedrockAnthropicMessageChatModelBuilder(super=" + super.toString() + ", topK$value=" + this.topK$value + ", anthropicVersion$value=" + this.anthropicVersion$value + ", model$value=" + this.model$value + ")";
        }
    }

    private static final class BedrockAnthropicMessageChatModelBuilderImpl
    extends BedrockAnthropicMessageChatModelBuilder<BedrockAnthropicMessageChatModel, BedrockAnthropicMessageChatModelBuilderImpl> {
        private BedrockAnthropicMessageChatModelBuilderImpl() {
        }

        @Override
        protected BedrockAnthropicMessageChatModelBuilderImpl self() {
            return this;
        }

        @Override
        public BedrockAnthropicMessageChatModel build() {
            return new BedrockAnthropicMessageChatModel(this);
        }
    }
}

