/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.model.bedrock.BedrockStabilityAIChatModelResponse;
import dev.langchain4j.model.bedrock.internal.AbstractBedrockChatModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BedrockStabilityAIChatModel
extends AbstractBedrockChatModel<BedrockStabilityAIChatModelResponse> {
    private final String model;
    private final int cfgScale;
    private final int width;
    private final int height;
    private final int seed;
    private final int steps;
    private final double promptWeight;
    private final StylePreset stylePreset;

    @Override
    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> textPrompt = new HashMap<String, Object>(2);
        textPrompt.put("text", prompt);
        textPrompt.put("weight", this.promptWeight);
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("text_prompts", Collections.singletonList(textPrompt));
        parameters.put("cfg_scale", this.cfgScale);
        parameters.put("seed", this.seed);
        parameters.put("steps", this.steps);
        parameters.put("width", this.width);
        parameters.put("height", this.height);
        parameters.put("style_preset", this.stylePreset.getValue());
        return parameters;
    }

    @Override
    protected String getModelId() {
        return this.model;
    }

    @Override
    protected Class<BedrockStabilityAIChatModelResponse> getResponseClassType() {
        return BedrockStabilityAIChatModelResponse.class;
    }

    private static String $default$model() {
        return Types.StableDiffuseXlV1.getValue();
    }

    private static int $default$cfgScale() {
        return 10;
    }

    private static int $default$width() {
        return 512;
    }

    private static int $default$height() {
        return 512;
    }

    private static int $default$seed() {
        return 0;
    }

    private static int $default$steps() {
        return 50;
    }

    private static double $default$promptWeight() {
        return 0.5;
    }

    private static StylePreset $default$stylePreset() {
        return StylePreset.ThreeDModel;
    }

    protected BedrockStabilityAIChatModel(BedrockStabilityAIChatModelBuilder<?, ?> b) {
        super(b);
        this.model = ((BedrockStabilityAIChatModelBuilder)b).model$set ? ((BedrockStabilityAIChatModelBuilder)b).model$value : BedrockStabilityAIChatModel.$default$model();
        this.cfgScale = ((BedrockStabilityAIChatModelBuilder)b).cfgScale$set ? ((BedrockStabilityAIChatModelBuilder)b).cfgScale$value : BedrockStabilityAIChatModel.$default$cfgScale();
        this.width = ((BedrockStabilityAIChatModelBuilder)b).width$set ? ((BedrockStabilityAIChatModelBuilder)b).width$value : BedrockStabilityAIChatModel.$default$width();
        this.height = ((BedrockStabilityAIChatModelBuilder)b).height$set ? ((BedrockStabilityAIChatModelBuilder)b).height$value : BedrockStabilityAIChatModel.$default$height();
        this.seed = ((BedrockStabilityAIChatModelBuilder)b).seed$set ? ((BedrockStabilityAIChatModelBuilder)b).seed$value : BedrockStabilityAIChatModel.$default$seed();
        this.steps = ((BedrockStabilityAIChatModelBuilder)b).steps$set ? ((BedrockStabilityAIChatModelBuilder)b).steps$value : BedrockStabilityAIChatModel.$default$steps();
        this.promptWeight = ((BedrockStabilityAIChatModelBuilder)b).promptWeight$set ? ((BedrockStabilityAIChatModelBuilder)b).promptWeight$value : BedrockStabilityAIChatModel.$default$promptWeight();
        this.stylePreset = ((BedrockStabilityAIChatModelBuilder)b).stylePreset$set ? ((BedrockStabilityAIChatModelBuilder)b).stylePreset$value : BedrockStabilityAIChatModel.$default$stylePreset();
    }

    public static BedrockStabilityAIChatModelBuilder<?, ?> builder() {
        return new BedrockStabilityAIChatModelBuilderImpl();
    }

    public String getModel() {
        return this.model;
    }

    public int getCfgScale() {
        return this.cfgScale;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getSteps() {
        return this.steps;
    }

    public double getPromptWeight() {
        return this.promptWeight;
    }

    public StylePreset getStylePreset() {
        return this.stylePreset;
    }

    public static enum StylePreset {
        ThreeDModel("3d-model"),
        Anime("anime"),
        Cinematic("cinematic"),
        ComicBook("comic-book"),
        DigitalArt("digital-art"),
        Enhance("enhance"),
        FantasyArt("fantasy-art"),
        Isometric("isometric"),
        LineArt("line-art"),
        LowPoly("low-poly"),
        ModelingCompound("modeling-compound"),
        NeonPunk("neon-punk"),
        Origami("origami"),
        Photographic("photographic"),
        PixelArt("pixel-art"),
        TileTexture("tile-texture"),
        AnalogFilm("analog-film");

        private final String value;

        private StylePreset(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Types {
        StableDiffuseXlV0("stability.stable-diffusion-xl-v0"),
        StableDiffuseXlV1("stability.stable-diffusion-xl-v1");

        private final String value;

        private Types(String modelID) {
            this.value = modelID;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class BedrockStabilityAIChatModelBuilder<C extends BedrockStabilityAIChatModel, B extends BedrockStabilityAIChatModelBuilder<C, B>>
    extends AbstractBedrockChatModel.AbstractBedrockChatModelBuilder<BedrockStabilityAIChatModelResponse, C, B> {
        private boolean model$set;
        private String model$value;
        private boolean cfgScale$set;
        private int cfgScale$value;
        private boolean width$set;
        private int width$value;
        private boolean height$set;
        private int height$value;
        private boolean seed$set;
        private int seed$value;
        private boolean steps$set;
        private int steps$value;
        private boolean promptWeight$set;
        private double promptWeight$value;
        private boolean stylePreset$set;
        private StylePreset stylePreset$value;

        public B model(String model) {
            this.model$value = model;
            this.model$set = true;
            return (B)this.self();
        }

        public B cfgScale(int cfgScale) {
            this.cfgScale$value = cfgScale;
            this.cfgScale$set = true;
            return (B)this.self();
        }

        public B width(int width) {
            this.width$value = width;
            this.width$set = true;
            return (B)this.self();
        }

        public B height(int height) {
            this.height$value = height;
            this.height$set = true;
            return (B)this.self();
        }

        public B seed(int seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return (B)this.self();
        }

        public B steps(int steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B promptWeight(double promptWeight) {
            this.promptWeight$value = promptWeight;
            this.promptWeight$set = true;
            return (B)this.self();
        }

        public B stylePreset(StylePreset stylePreset) {
            this.stylePreset$value = stylePreset;
            this.stylePreset$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BedrockStabilityAIChatModel.BedrockStabilityAIChatModelBuilder(super=" + super.toString() + ", model$value=" + this.model$value + ", cfgScale$value=" + this.cfgScale$value + ", width$value=" + this.width$value + ", height$value=" + this.height$value + ", seed$value=" + this.seed$value + ", steps$value=" + this.steps$value + ", promptWeight$value=" + this.promptWeight$value + ", stylePreset$value=" + (Object)((Object)this.stylePreset$value) + ")";
        }
    }

    private static final class BedrockStabilityAIChatModelBuilderImpl
    extends BedrockStabilityAIChatModelBuilder<BedrockStabilityAIChatModel, BedrockStabilityAIChatModelBuilderImpl> {
        private BedrockStabilityAIChatModelBuilderImpl() {
        }

        @Override
        protected BedrockStabilityAIChatModelBuilderImpl self() {
            return this;
        }

        @Override
        public BedrockStabilityAIChatModel build() {
            return new BedrockStabilityAIChatModel(this);
        }
    }
}

