/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Json;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.bedrock.internal.AbstractSharedBedrockChatModel;
import dev.langchain4j.model.bedrock.internal.BedrockChatModelResponse;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public abstract class AbstractBedrockChatModel<T extends BedrockChatModelResponse>
extends AbstractSharedBedrockChatModel
implements ChatLanguageModel {
    private final AtomicReference<Object> client = new AtomicReference();

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        String body = this.convertMessagesToAwsBody(messages);
        InvokeModelResponse invokeModelResponse = (InvokeModelResponse)RetryUtils.withRetry(() -> this.invoke(body), (int)this.maxRetries);
        String response = invokeModelResponse.body().asUtf8String();
        BedrockChatModelResponse result = (BedrockChatModelResponse)Json.fromJson((String)response, this.getResponseClassType());
        return new Response((Object)new AiMessage(result.getOutputText()), result.getTokenUsage(), result.getFinishReason());
    }

    @Override
    protected abstract Map<String, Object> getRequestParameters(String var1);

    protected abstract Class<T> getResponseClassType();

    protected InvokeModelResponse invoke(String body) {
        InvokeModelRequest invokeModelRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.getModelId()).body(SdkBytes.fromString((String)body, (Charset)Charset.defaultCharset())).build();
        return this.getClient().invokeModel(invokeModelRequest);
    }

    protected static Map<String, Object> of(final String key, final Object value) {
        return new HashMap<String, Object>(1){
            {
                super(arg0);
                this.put(key, value);
            }
        };
    }

    private BedrockRuntimeClient initClient() {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(this.region)).credentialsProvider(this.credentialsProvider)).build();
    }

    protected AbstractBedrockChatModel(AbstractBedrockChatModelBuilder<T, ?, ?> b) {
        super(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BedrockRuntimeClient getClient() {
        Object value = this.client.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.client;
            synchronized (atomicReference) {
                value = this.client.get();
                if (value == null) {
                    BedrockRuntimeClient actualValue = this.initClient();
                    value = actualValue == null ? this.client : actualValue;
                    this.client.set(value);
                }
            }
        }
        return (BedrockRuntimeClient)(value == this.client ? null : value);
    }

    public static abstract class AbstractBedrockChatModelBuilder<T extends BedrockChatModelResponse, C extends AbstractBedrockChatModel<T>, B extends AbstractBedrockChatModelBuilder<T, C, B>>
    extends AbstractSharedBedrockChatModel.AbstractSharedBedrockChatModelBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AbstractBedrockChatModel.AbstractBedrockChatModelBuilder(super=" + super.toString() + ")";
        }
    }
}

