/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Json;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.bedrock.internal.AbstractSharedBedrockChatModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.output.Response;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponseHandler;

public abstract class AbstractBedrockStreamingChatModel
extends AbstractSharedBedrockChatModel
implements StreamingChatLanguageModel {
    private final BedrockRuntimeAsyncClient asyncClient = this.initAsyncClient();

    public void generate(String userMessage, StreamingResponseHandler<AiMessage> handler) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        messages.add((ChatMessage)new UserMessage(userMessage));
        this.generate(messages, handler);
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        InvokeModelWithResponseStreamRequest request = (InvokeModelWithResponseStreamRequest)InvokeModelWithResponseStreamRequest.builder().body(SdkBytes.fromUtf8String((String)this.convertMessagesToAwsBody(messages))).modelId(this.getModelId()).contentType("application/json").accept("application/json").build();
        StringBuffer finalCompletion = new StringBuffer();
        InvokeModelWithResponseStreamResponseHandler.Visitor visitor = InvokeModelWithResponseStreamResponseHandler.Visitor.builder().onChunk(chunk -> {
            StreamingResponse sr = (StreamingResponse)Json.fromJson((String)chunk.bytes().asUtf8String(), StreamingResponse.class);
            finalCompletion.append(sr.completion);
            handler.onNext(sr.completion);
        }).build();
        InvokeModelWithResponseStreamResponseHandler h = ((InvokeModelWithResponseStreamResponseHandler.Builder)((InvokeModelWithResponseStreamResponseHandler.Builder)((InvokeModelWithResponseStreamResponseHandler.Builder)InvokeModelWithResponseStreamResponseHandler.builder().onEventStream(stream -> stream.subscribe(event -> event.accept(visitor)))).onComplete(() -> handler.onComplete(Response.from((Object)new AiMessage(finalCompletion.toString()))))).onError(arg_0 -> handler.onError(arg_0))).build();
        this.asyncClient.invokeModelWithResponseStream(request, h).join();
    }

    private BedrockRuntimeAsyncClient initAsyncClient() {
        BedrockRuntimeAsyncClient client = (BedrockRuntimeAsyncClient)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().region(this.region)).credentialsProvider(this.credentialsProvider)).build();
        return client;
    }

    protected AbstractBedrockStreamingChatModel(AbstractBedrockStreamingChatModelBuilder<?, ?> b) {
        super(b);
    }

    public BedrockRuntimeAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    class StreamingResponse {
        public String completion;

        StreamingResponse() {
        }
    }

    public static abstract class AbstractBedrockStreamingChatModelBuilder<C extends AbstractBedrockStreamingChatModel, B extends AbstractBedrockStreamingChatModelBuilder<C, B>>
    extends AbstractSharedBedrockChatModel.AbstractSharedBedrockChatModelBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AbstractBedrockStreamingChatModel.AbstractBedrockStreamingChatModelBuilder(super=" + super.toString() + ")";
        }
    }
}

