/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.internal.Json;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public abstract class AbstractSharedBedrockChatModel {
    protected static final String HUMAN_PROMPT = "Human:";
    protected static final String ASSISTANT_PROMPT = "Assistant:";
    protected static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";
    protected final String humanPrompt;
    protected final String assistantPrompt;
    protected final Integer maxRetries;
    protected final Region region;
    protected final AwsCredentialsProvider credentialsProvider;
    protected final int maxTokens;
    protected final double temperature;
    protected final float topP;
    protected final String[] stopSequences;
    protected final int topK;
    protected final String anthropicVersion;

    protected String chatMessageToString(ChatMessage message) {
        switch (message.type()) {
            case SYSTEM: {
                return message.text();
            }
            case USER: {
                return this.humanPrompt + " " + message.text();
            }
            case AI: {
                return this.assistantPrompt + " " + message.text();
            }
            case TOOL_EXECUTION_RESULT: {
                throw new IllegalArgumentException("Tool execution results are not supported for Bedrock models");
            }
        }
        throw new IllegalArgumentException("Unknown message type: " + message.type());
    }

    protected String convertMessagesToAwsBody(List<ChatMessage> messages) {
        String context = messages.stream().filter(message -> message.type() == ChatMessageType.SYSTEM).map(ChatMessage::text).collect(Collectors.joining("\n"));
        String userMessages = messages.stream().filter(message -> message.type() != ChatMessageType.SYSTEM).map(this::chatMessageToString).collect(Collectors.joining("\n"));
        String prompt = String.format("%s\n\n%s\n%s", context, userMessages, ASSISTANT_PROMPT);
        Map<String, Object> requestParameters = this.getRequestParameters(prompt);
        String body = Json.toJson(requestParameters);
        return body;
    }

    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(7);
        parameters.put("prompt", prompt);
        parameters.put("max_tokens_to_sample", this.getMaxTokens());
        parameters.put("temperature", this.getTemperature());
        parameters.put("top_k", this.topK);
        parameters.put("top_p", Float.valueOf(this.getTopP()));
        parameters.put("stop_sequences", this.getStopSequences());
        parameters.put("anthropic_version", this.anthropicVersion);
        return parameters;
    }

    protected abstract String getModelId();

    private static String $default$humanPrompt() {
        return HUMAN_PROMPT;
    }

    private static String $default$assistantPrompt() {
        return ASSISTANT_PROMPT;
    }

    private static Integer $default$maxRetries() {
        return 5;
    }

    private static Region $default$region() {
        return Region.US_EAST_1;
    }

    private static AwsCredentialsProvider $default$credentialsProvider() {
        return DefaultCredentialsProvider.builder().build();
    }

    private static int $default$maxTokens() {
        return 300;
    }

    private static double $default$temperature() {
        return 1.0;
    }

    private static float $default$topP() {
        return 0.999f;
    }

    private static String[] $default$stopSequences() {
        return new String[0];
    }

    private static int $default$topK() {
        return 250;
    }

    private static String $default$anthropicVersion() {
        return DEFAULT_ANTHROPIC_VERSION;
    }

    protected AbstractSharedBedrockChatModel(AbstractSharedBedrockChatModelBuilder<?, ?> b) {
        this.humanPrompt = ((AbstractSharedBedrockChatModelBuilder)b).humanPrompt$set ? ((AbstractSharedBedrockChatModelBuilder)b).humanPrompt$value : AbstractSharedBedrockChatModel.$default$humanPrompt();
        this.assistantPrompt = ((AbstractSharedBedrockChatModelBuilder)b).assistantPrompt$set ? ((AbstractSharedBedrockChatModelBuilder)b).assistantPrompt$value : AbstractSharedBedrockChatModel.$default$assistantPrompt();
        this.maxRetries = ((AbstractSharedBedrockChatModelBuilder)b).maxRetries$set ? ((AbstractSharedBedrockChatModelBuilder)b).maxRetries$value : AbstractSharedBedrockChatModel.$default$maxRetries();
        this.region = ((AbstractSharedBedrockChatModelBuilder)b).region$set ? ((AbstractSharedBedrockChatModelBuilder)b).region$value : AbstractSharedBedrockChatModel.$default$region();
        this.credentialsProvider = ((AbstractSharedBedrockChatModelBuilder)b).credentialsProvider$set ? ((AbstractSharedBedrockChatModelBuilder)b).credentialsProvider$value : AbstractSharedBedrockChatModel.$default$credentialsProvider();
        this.maxTokens = ((AbstractSharedBedrockChatModelBuilder)b).maxTokens$set ? ((AbstractSharedBedrockChatModelBuilder)b).maxTokens$value : AbstractSharedBedrockChatModel.$default$maxTokens();
        this.temperature = ((AbstractSharedBedrockChatModelBuilder)b).temperature$set ? ((AbstractSharedBedrockChatModelBuilder)b).temperature$value : AbstractSharedBedrockChatModel.$default$temperature();
        this.topP = ((AbstractSharedBedrockChatModelBuilder)b).topP$set ? ((AbstractSharedBedrockChatModelBuilder)b).topP$value : AbstractSharedBedrockChatModel.$default$topP();
        this.stopSequences = ((AbstractSharedBedrockChatModelBuilder)b).stopSequences$set ? ((AbstractSharedBedrockChatModelBuilder)b).stopSequences$value : AbstractSharedBedrockChatModel.$default$stopSequences();
        this.topK = ((AbstractSharedBedrockChatModelBuilder)b).topK$set ? ((AbstractSharedBedrockChatModelBuilder)b).topK$value : AbstractSharedBedrockChatModel.$default$topK();
        this.anthropicVersion = ((AbstractSharedBedrockChatModelBuilder)b).anthropicVersion$set ? ((AbstractSharedBedrockChatModelBuilder)b).anthropicVersion$value : AbstractSharedBedrockChatModel.$default$anthropicVersion();
    }

    public String getHumanPrompt() {
        return this.humanPrompt;
    }

    public String getAssistantPrompt() {
        return this.assistantPrompt;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Region getRegion() {
        return this.region;
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public float getTopP() {
        return this.topP;
    }

    public String[] getStopSequences() {
        return this.stopSequences;
    }

    public int getTopK() {
        return this.topK;
    }

    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    public static abstract class AbstractSharedBedrockChatModelBuilder<C extends AbstractSharedBedrockChatModel, B extends AbstractSharedBedrockChatModelBuilder<C, B>> {
        private boolean humanPrompt$set;
        private String humanPrompt$value;
        private boolean assistantPrompt$set;
        private String assistantPrompt$value;
        private boolean maxRetries$set;
        private Integer maxRetries$value;
        private boolean region$set;
        private Region region$value;
        private boolean credentialsProvider$set;
        private AwsCredentialsProvider credentialsProvider$value;
        private boolean maxTokens$set;
        private int maxTokens$value;
        private boolean temperature$set;
        private double temperature$value;
        private boolean topP$set;
        private float topP$value;
        private boolean stopSequences$set;
        private String[] stopSequences$value;
        private boolean topK$set;
        private int topK$value;
        private boolean anthropicVersion$set;
        private String anthropicVersion$value;

        public B humanPrompt(String humanPrompt) {
            this.humanPrompt$value = humanPrompt;
            this.humanPrompt$set = true;
            return this.self();
        }

        public B assistantPrompt(String assistantPrompt) {
            this.assistantPrompt$value = assistantPrompt;
            this.assistantPrompt$set = true;
            return this.self();
        }

        public B maxRetries(Integer maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this.self();
        }

        public B region(Region region) {
            this.region$value = region;
            this.region$set = true;
            return this.self();
        }

        public B credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider$value = credentialsProvider;
            this.credentialsProvider$set = true;
            return this.self();
        }

        public B maxTokens(int maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this.self();
        }

        public B temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this.self();
        }

        public B topP(float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this.self();
        }

        public B stopSequences(String[] stopSequences) {
            this.stopSequences$value = stopSequences;
            this.stopSequences$set = true;
            return this.self();
        }

        public B topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return this.self();
        }

        public B anthropicVersion(String anthropicVersion) {
            this.anthropicVersion$value = anthropicVersion;
            this.anthropicVersion$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractSharedBedrockChatModel.AbstractSharedBedrockChatModelBuilder(humanPrompt$value=" + this.humanPrompt$value + ", assistantPrompt$value=" + this.assistantPrompt$value + ", maxRetries$value=" + this.maxRetries$value + ", region$value=" + this.region$value + ", credentialsProvider$value=" + this.credentialsProvider$value + ", maxTokens$value=" + this.maxTokens$value + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", stopSequences$value=" + Arrays.deepToString(this.stopSequences$value) + ", topK$value=" + this.topK$value + ", anthropicVersion$value=" + this.anthropicVersion$value + ")";
        }
    }
}

