/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.model.bedrock.BedrockAnthropicContent;
import dev.langchain4j.model.bedrock.internal.BedrockChatModelResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class BedrockAnthropicMessageChatModelResponse
implements BedrockChatModelResponse {
    private String id;
    private String model;
    private String type;
    private String role;
    private List<BedrockAnthropicContent> content;
    private String stop_reason;
    private String stop_sequence;
    private BedrockAnthropicUsage usage;

    @Override
    public String getOutputText() {
        return this.content.stream().map(BedrockAnthropicContent::getText).collect(Collectors.joining("\n\n"));
    }

    @Override
    public FinishReason getFinishReason() {
        switch (this.stop_reason) {
            case "end_turn": 
            case "stop_sequence": {
                return FinishReason.STOP;
            }
            case "max_tokens": {
                return FinishReason.LENGTH;
            }
            case "tool_use": {
                return FinishReason.TOOL_EXECUTION;
            }
        }
        throw new IllegalArgumentException("Unknown stop reason: " + this.stop_reason);
    }

    @Override
    public TokenUsage getTokenUsage() {
        if (this.usage != null) {
            int totalTokenCount = this.usage.input_tokens + this.usage.output_tokens;
            return new TokenUsage(Integer.valueOf(this.usage.input_tokens), Integer.valueOf(this.usage.output_tokens), Integer.valueOf(totalTokenCount));
        }
        return null;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public List<BedrockAnthropicContent> getContent() {
        return this.content;
    }

    @Generated
    public String getStop_reason() {
        return this.stop_reason;
    }

    @Generated
    public String getStop_sequence() {
        return this.stop_sequence;
    }

    @Generated
    public BedrockAnthropicUsage getUsage() {
        return this.usage;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setContent(List<BedrockAnthropicContent> content) {
        this.content = content;
    }

    @Generated
    public void setStop_reason(String stop_reason) {
        this.stop_reason = stop_reason;
    }

    @Generated
    public void setStop_sequence(String stop_sequence) {
        this.stop_sequence = stop_sequence;
    }

    @Generated
    public void setUsage(BedrockAnthropicUsage usage) {
        this.usage = usage;
    }

    public static class BedrockAnthropicUsage {
        private int input_tokens;
        private int output_tokens;

        @Generated
        public int getInput_tokens() {
            return this.input_tokens;
        }

        @Generated
        public int getOutput_tokens() {
            return this.output_tokens;
        }

        @Generated
        public void setInput_tokens(int input_tokens) {
            this.input_tokens = input_tokens;
        }

        @Generated
        public void setOutput_tokens(int output_tokens) {
            this.output_tokens = output_tokens;
        }
    }
}

