/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.Experimental;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Experimental
public class BedrockChatRequestParameters
extends DefaultChatRequestParameters {
    private final Map<String, Object> additionalModelRequestFields;

    private BedrockChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
    }

    public BedrockChatRequestParameters overrideWith(ChatRequestParameters that) {
        return BedrockChatRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private Map<String, Object> additionalModelRequestFields = new HashMap<String, Object>();

        public Builder overrideWith(ChatRequestParameters parameters) {
            super.overrideWith(parameters);
            if (parameters instanceof BedrockChatRequestParameters) {
                BedrockChatRequestParameters bedrockRequestParameters = (BedrockChatRequestParameters)parameters;
                if (Objects.nonNull(bedrockRequestParameters.additionalModelRequestFields)) {
                    this.additionalModelRequestFields.putAll(bedrockRequestParameters.additionalModelRequestFields);
                }
            }
            return this;
        }

        public Builder additionalModelRequestFields(Map<String, Object> additionalModelRequestFields) {
            this.additionalModelRequestFields = Objects.nonNull(additionalModelRequestFields) ? additionalModelRequestFields : new HashMap<String, Object>();
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder enableReasoning(Long tokenBudget) {
            this.additionalModelRequestFields.put("reasoning_config", Map.ofEntries(Map.entry("type", "enabled"), Map.entry("budget_tokens", tokenBudget)));
            return this;
        }

        public Builder enableReasoning(Integer tokenBudget) {
            if (tokenBudget != null) {
                this.additionalModelRequestFields.put("reasoning_config", Map.ofEntries(Map.entry("type", "enabled"), Map.entry("budget_tokens", tokenBudget)));
            }
            return this;
        }

        public BedrockChatRequestParameters build() {
            return new BedrockChatRequestParameters(this);
        }
    }
}

