/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.bedrock.internal.Json;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;

public abstract class AbstractSharedBedrockChatModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSharedBedrockChatModel.class);
    protected static final String HUMAN_PROMPT = "Human:";
    protected static final String ASSISTANT_PROMPT = "Assistant:";
    protected static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";
    protected final String humanPrompt;
    protected final String assistantPrompt;
    protected final Integer maxRetries;
    protected final Region region;
    protected final AwsCredentialsProvider credentialsProvider;
    protected final int maxTokens;
    protected final double temperature;
    protected final float topP;
    protected final String[] stopSequences;
    protected final int topK;
    protected final Duration timeout;
    protected final String anthropicVersion;
    protected final List<ChatModelListener> listeners;

    protected String chatMessageToString(ChatMessage message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            return systemMessage.text();
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            return this.humanPrompt + " " + userMessage.singleText();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            return this.assistantPrompt + " " + aiMessage.text();
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.type()));
    }

    protected String convertMessagesToAwsBody(List<ChatMessage> messages) {
        String context = messages.stream().filter(message -> message.type() == ChatMessageType.SYSTEM).map(message -> ((SystemMessage)message).text()).collect(Collectors.joining("\n"));
        String userMessages = messages.stream().filter(message -> message.type() != ChatMessageType.SYSTEM).map(this::chatMessageToString).collect(Collectors.joining("\n"));
        String prompt = String.format("%s\n\n%s\n%s", context, userMessages, ASSISTANT_PROMPT);
        Map<String, Object> requestParameters = this.getRequestParameters(prompt);
        String body = Json.toJson(requestParameters);
        return body;
    }

    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(7);
        parameters.put("prompt", prompt);
        parameters.put("max_tokens_to_sample", this.getMaxTokens());
        parameters.put("temperature", this.getTemperature());
        parameters.put("top_k", this.topK);
        parameters.put("top_p", Float.valueOf(this.getTopP()));
        parameters.put("stop_sequences", this.getStopSequences());
        parameters.put("anthropic_version", this.anthropicVersion);
        return parameters;
    }

    protected void listenerErrorResponse(Throwable e, ChatRequest listenerRequest, ModelProvider modelProvider, Map<Object, Object> attributes) {
        Throwable error = e.getCause() instanceof SdkClientException ? e.getCause() : e;
        ChatModelErrorContext errorContext = new ChatModelErrorContext(error, listenerRequest, modelProvider, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onError(errorContext);
            }
            catch (Exception e2) {
                log.warn("Exception while calling model listener", (Throwable)e2);
            }
        });
    }

    protected ChatRequest createListenerRequest(InvokeModelRequest invokeModelRequest, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().modelName(invokeModelRequest.modelId()).temperature(Double.valueOf(this.temperature)).topP(Double.valueOf(this.topP)).maxOutputTokens(Integer.valueOf(this.maxTokens)).toolSpecifications(toolSpecifications).build()).build();
    }

    protected ChatRequest createListenerRequest(InvokeModelWithResponseStreamRequest invokeModelRequest, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return ChatRequest.builder().messages(messages).parameters(ChatRequestParameters.builder().modelName(invokeModelRequest.modelId()).temperature(Double.valueOf(this.temperature)).topP(Double.valueOf(this.topP)).maxOutputTokens(Integer.valueOf(this.maxTokens)).toolSpecifications(toolSpecifications).build()).build();
    }

    protected ChatResponse createListenerResponse(String responseId, String responseModel, Response<AiMessage> response) {
        if (response == null) {
            return null;
        }
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().id(responseId).modelName(responseModel).tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    protected abstract String getModelId();

    @Generated
    private static String $default$humanPrompt() {
        return HUMAN_PROMPT;
    }

    @Generated
    private static String $default$assistantPrompt() {
        return ASSISTANT_PROMPT;
    }

    @Generated
    private static Integer $default$maxRetries() {
        return 2;
    }

    @Generated
    private static Region $default$region() {
        return Region.US_EAST_1;
    }

    @Generated
    private static AwsCredentialsProvider $default$credentialsProvider() {
        return DefaultCredentialsProvider.builder().build();
    }

    @Generated
    private static int $default$maxTokens() {
        return 300;
    }

    @Generated
    private static double $default$temperature() {
        return 1.0;
    }

    @Generated
    private static float $default$topP() {
        return 0.999f;
    }

    @Generated
    private static String[] $default$stopSequences() {
        return new String[0];
    }

    @Generated
    private static int $default$topK() {
        return 250;
    }

    @Generated
    private static Duration $default$timeout() {
        return Duration.ofMinutes(1L);
    }

    @Generated
    private static String $default$anthropicVersion() {
        return DEFAULT_ANTHROPIC_VERSION;
    }

    @Generated
    private static List<ChatModelListener> $default$listeners() {
        return Collections.emptyList();
    }

    @Generated
    protected AbstractSharedBedrockChatModel(AbstractSharedBedrockChatModelBuilder<?, ?> b) {
        this.humanPrompt = b.humanPrompt$set ? b.humanPrompt$value : AbstractSharedBedrockChatModel.$default$humanPrompt();
        this.assistantPrompt = b.assistantPrompt$set ? b.assistantPrompt$value : AbstractSharedBedrockChatModel.$default$assistantPrompt();
        this.maxRetries = b.maxRetries$set ? b.maxRetries$value : AbstractSharedBedrockChatModel.$default$maxRetries();
        this.region = b.region$set ? b.region$value : AbstractSharedBedrockChatModel.$default$region();
        this.credentialsProvider = b.credentialsProvider$set ? b.credentialsProvider$value : AbstractSharedBedrockChatModel.$default$credentialsProvider();
        this.maxTokens = b.maxTokens$set ? b.maxTokens$value : AbstractSharedBedrockChatModel.$default$maxTokens();
        this.temperature = b.temperature$set ? b.temperature$value : AbstractSharedBedrockChatModel.$default$temperature();
        this.topP = b.topP$set ? b.topP$value : AbstractSharedBedrockChatModel.$default$topP();
        this.stopSequences = b.stopSequences$set ? b.stopSequences$value : AbstractSharedBedrockChatModel.$default$stopSequences();
        this.topK = b.topK$set ? b.topK$value : AbstractSharedBedrockChatModel.$default$topK();
        this.timeout = b.timeout$set ? b.timeout$value : AbstractSharedBedrockChatModel.$default$timeout();
        this.anthropicVersion = b.anthropicVersion$set ? b.anthropicVersion$value : AbstractSharedBedrockChatModel.$default$anthropicVersion();
        this.listeners = b.listeners$set ? b.listeners$value : AbstractSharedBedrockChatModel.$default$listeners();
    }

    @Generated
    public String getHumanPrompt() {
        return this.humanPrompt;
    }

    @Generated
    public String getAssistantPrompt() {
        return this.assistantPrompt;
    }

    @Generated
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public Region getRegion() {
        return this.region;
    }

    @Generated
    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Generated
    public int getMaxTokens() {
        return this.maxTokens;
    }

    @Generated
    public double getTemperature() {
        return this.temperature;
    }

    @Generated
    public float getTopP() {
        return this.topP;
    }

    @Generated
    public String[] getStopSequences() {
        return this.stopSequences;
    }

    @Generated
    public int getTopK() {
        return this.topK;
    }

    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    @Generated
    public List<ChatModelListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public static abstract class AbstractSharedBedrockChatModelBuilder<C extends AbstractSharedBedrockChatModel, B extends AbstractSharedBedrockChatModelBuilder<C, B>> {
        @Generated
        private boolean humanPrompt$set;
        @Generated
        private String humanPrompt$value;
        @Generated
        private boolean assistantPrompt$set;
        @Generated
        private String assistantPrompt$value;
        @Generated
        private boolean maxRetries$set;
        @Generated
        private Integer maxRetries$value;
        @Generated
        private boolean region$set;
        @Generated
        private Region region$value;
        @Generated
        private boolean credentialsProvider$set;
        @Generated
        private AwsCredentialsProvider credentialsProvider$value;
        @Generated
        private boolean maxTokens$set;
        @Generated
        private int maxTokens$value;
        @Generated
        private boolean temperature$set;
        @Generated
        private double temperature$value;
        @Generated
        private boolean topP$set;
        @Generated
        private float topP$value;
        @Generated
        private boolean stopSequences$set;
        @Generated
        private String[] stopSequences$value;
        @Generated
        private boolean topK$set;
        @Generated
        private int topK$value;
        @Generated
        private boolean timeout$set;
        @Generated
        private Duration timeout$value;
        @Generated
        private boolean anthropicVersion$set;
        @Generated
        private String anthropicVersion$value;
        @Generated
        private boolean listeners$set;
        @Generated
        private List<ChatModelListener> listeners$value;

        @Generated
        public B humanPrompt(String humanPrompt) {
            this.humanPrompt$value = humanPrompt;
            this.humanPrompt$set = true;
            return this.self();
        }

        @Generated
        public B assistantPrompt(String assistantPrompt) {
            this.assistantPrompt$value = assistantPrompt;
            this.assistantPrompt$set = true;
            return this.self();
        }

        @Generated
        public B maxRetries(Integer maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this.self();
        }

        @Generated
        public B region(Region region) {
            this.region$value = region;
            this.region$set = true;
            return this.self();
        }

        @Generated
        public B credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider$value = credentialsProvider;
            this.credentialsProvider$set = true;
            return this.self();
        }

        @Generated
        public B maxTokens(int maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this.self();
        }

        @Generated
        public B temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this.self();
        }

        @Generated
        public B topP(float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this.self();
        }

        @Generated
        public B stopSequences(String[] stopSequences) {
            this.stopSequences$value = stopSequences;
            this.stopSequences$set = true;
            return this.self();
        }

        @Generated
        public B topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return this.self();
        }

        @Generated
        public B timeout(Duration timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this.self();
        }

        @Generated
        public B anthropicVersion(String anthropicVersion) {
            this.anthropicVersion$value = anthropicVersion;
            this.anthropicVersion$set = true;
            return this.self();
        }

        @Generated
        public B listeners(List<ChatModelListener> listeners) {
            this.listeners$value = listeners;
            this.listeners$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractSharedBedrockChatModel.AbstractSharedBedrockChatModelBuilder(humanPrompt$value=" + this.humanPrompt$value + ", assistantPrompt$value=" + this.assistantPrompt$value + ", maxRetries$value=" + this.maxRetries$value + ", region$value=" + String.valueOf(this.region$value) + ", credentialsProvider$value=" + String.valueOf(this.credentialsProvider$value) + ", maxTokens$value=" + this.maxTokens$value + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", stopSequences$value=" + Arrays.deepToString(this.stopSequences$value) + ", topK$value=" + this.topK$value + ", timeout$value=" + String.valueOf(this.timeout$value) + ", anthropicVersion$value=" + this.anthropicVersion$value + ", listeners$value=" + String.valueOf(this.listeners$value) + ")";
        }
    }
}

