/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.Internal;
import dev.langchain4j.exception.LangChain4jException;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.internal.ExceptionMapper;
import software.amazon.awssdk.core.exception.ApiCallTimeoutException;
import software.amazon.awssdk.core.exception.SdkServiceException;

@Internal
class BedrockExceptionMapper
extends ExceptionMapper.DefaultExceptionMapper {
    static final BedrockExceptionMapper INSTANCE = new BedrockExceptionMapper();

    BedrockExceptionMapper() {
    }

    public RuntimeException mapException(Throwable t) {
        Object object;
        if (t instanceof SdkServiceException) {
            SdkServiceException sdkServiceException = (SdkServiceException)t;
            return this.mapHttpStatusCode((Throwable)sdkServiceException, sdkServiceException.statusCode());
        }
        Throwable throwable = t.getCause();
        if (throwable instanceof SdkServiceException) {
            SdkServiceException sdkServiceException = (SdkServiceException)throwable;
            return this.mapHttpStatusCode((Throwable)sdkServiceException, sdkServiceException.statusCode());
        }
        if (t instanceof ApiCallTimeoutException) {
            return new TimeoutException(t);
        }
        if (t.getCause() instanceof ApiCallTimeoutException) {
            return new TimeoutException(t.getCause());
        }
        if (t instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)t;
            object = re;
        } else {
            object = new LangChain4jException(t);
        }
        return object;
    }
}

