/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.cohere;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.cohere.CohereClient;
import dev.langchain4j.model.cohere.RerankRequest;
import dev.langchain4j.model.cohere.RerankResponse;
import dev.langchain4j.model.cohere.Result;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.scoring.ScoringModel;
import java.net.Proxy;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class CohereScoringModel
implements ScoringModel {
    private static final String DEFAULT_BASE_URL = "https://api.cohere.ai/v1/";
    private final CohereClient client;
    private final String modelName;
    private final Integer maxRetries;

    public CohereScoringModel(String baseUrl, String apiKey, String modelName, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses) {
        this.client = CohereClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)DEFAULT_BASE_URL)).apiKey(ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey")).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).proxy(proxy).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.modelName = modelName;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    @Deprecated(forRemoval=true)
    public static CohereScoringModel withApiKey(String apiKey) {
        return CohereScoringModel.builder().apiKey(apiKey).build();
    }

    public Response<List<Double>> scoreAll(List<TextSegment> segments, String query) {
        RerankRequest request = RerankRequest.builder().model(this.modelName).query(query).documents(segments.stream().map(TextSegment::text).collect(Collectors.toList())).build();
        RerankResponse response = (RerankResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.rerank(request), (int)this.maxRetries);
        List scores = response.getResults().stream().sorted(Comparator.comparingInt(Result::getIndex)).map(Result::getRelevanceScore).collect(Collectors.toList());
        return Response.from(scores, (TokenUsage)new TokenUsage(response.getMeta().getBilledUnits().getSearchUnits()));
    }

    @Generated
    public static CohereScoringModelBuilder builder() {
        return new CohereScoringModelBuilder();
    }

    @Generated
    public static class CohereScoringModelBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private String apiKey;
        @Generated
        private String modelName;
        @Generated
        private Duration timeout;
        @Generated
        private Integer maxRetries;
        @Generated
        private Proxy proxy;
        @Generated
        private Boolean logRequests;
        @Generated
        private Boolean logResponses;

        @Generated
        CohereScoringModelBuilder() {
        }

        @Generated
        public CohereScoringModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public CohereScoringModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public CohereScoringModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Generated
        public CohereScoringModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public CohereScoringModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public CohereScoringModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @Generated
        public CohereScoringModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        @Generated
        public CohereScoringModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        @Generated
        public CohereScoringModel build() {
            return new CohereScoringModel(this.baseUrl, this.apiKey, this.modelName, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses);
        }

        @Generated
        public String toString() {
            return "CohereScoringModel.CohereScoringModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", timeout=" + String.valueOf(this.timeout) + ", maxRetries=" + this.maxRetries + ", proxy=" + String.valueOf(this.proxy) + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }
}

