/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.alloydb.filter;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.ContainsString;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;

public class AlloyDBFilterMapper {
    public String map(Filter filter) {
        if (filter == null) {
            return "";
        }
        if (filter instanceof IsEqualTo) {
            IsEqualTo isEqualTo = (IsEqualTo)filter;
            return this.mapEqual(isEqualTo);
        }
        if (filter instanceof IsNotEqualTo) {
            IsNotEqualTo isNotEqualTo = (IsNotEqualTo)filter;
            return this.mapNotEqual(isNotEqualTo);
        }
        if (filter instanceof IsGreaterThan) {
            IsGreaterThan isGreaterThan = (IsGreaterThan)filter;
            return this.mapGreaterThan(isGreaterThan);
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            IsGreaterThanOrEqualTo isGreaterThanOrEqualTo = (IsGreaterThanOrEqualTo)filter;
            return this.mapGreaterThanOrEqual(isGreaterThanOrEqualTo);
        }
        if (filter instanceof IsLessThan) {
            IsLessThan isLessThan = (IsLessThan)filter;
            return this.mapLessThan(isLessThan);
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            IsLessThanOrEqualTo isLessThanOrEqualTo = (IsLessThanOrEqualTo)filter;
            return this.mapLessThanOrEqual(isLessThanOrEqualTo);
        }
        if (filter instanceof IsIn) {
            IsIn isIn = (IsIn)filter;
            return this.mapIn(isIn);
        }
        if (filter instanceof IsNotIn) {
            IsNotIn isNotIn = (IsNotIn)filter;
            return this.mapNotIn(isNotIn);
        }
        if (filter instanceof ContainsString) {
            ContainsString containsString = (ContainsString)filter;
            return this.mapContainsString(containsString);
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return this.mapAnd(and);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return this.mapNot(not);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return this.mapOr(or);
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getName());
    }

    private String mapEqual(IsEqualTo isEqualTo) {
        String key = isEqualTo.key();
        return String.format("\"%s\" IS NOT NULL AND \"%s\" = %s", key, key, this.formatValue(isEqualTo.comparisonValue()));
    }

    private String mapNotEqual(IsNotEqualTo isNotEqualTo) {
        String key = isNotEqualTo.key();
        return String.format("\"%s\" IS NULL OR \"%s\" != %s", key, key, this.formatValue(isNotEqualTo.comparisonValue()));
    }

    private String mapGreaterThan(IsGreaterThan isGreaterThan) {
        return String.format("\"%s\" > %s", isGreaterThan.key(), this.formatValue(isGreaterThan.comparisonValue()));
    }

    private String mapGreaterThanOrEqual(IsGreaterThanOrEqualTo isGreaterThanOrEqualTo) {
        return String.format("\"%s\" >= %s", isGreaterThanOrEqualTo.key(), this.formatValue(isGreaterThanOrEqualTo.comparisonValue()));
    }

    private String mapLessThan(IsLessThan isLessThan) {
        return String.format("\"%s\" < %s", isLessThan.key(), this.formatValue(isLessThan.comparisonValue()));
    }

    private String mapLessThanOrEqual(IsLessThanOrEqualTo isLessThanOrEqualTo) {
        return String.format("\"%s\" <= %s", isLessThanOrEqualTo.key(), this.formatValue(isLessThanOrEqualTo.comparisonValue()));
    }

    private String mapIn(IsIn isIn) {
        return String.format("\"%s\" IN %s", isIn.key(), this.formatValuesAsString(isIn.comparisonValues()));
    }

    private String mapNotIn(IsNotIn isNotIn) {
        String key = isNotIn.key();
        return String.format("\"%s\" IS NULL OR \"%s\" NOT IN %s", key, key, this.formatValuesAsString(isNotIn.comparisonValues()));
    }

    private String mapContainsString(ContainsString containsString) {
        return String.format("\"%s\" ILIKE '%%%s%%'", containsString.key(), this.formatValue(containsString.comparisonValue()));
    }

    private String mapAnd(And and) {
        return String.format("%s AND %s", this.map(and.left()), this.map(and.right()));
    }

    private String mapNot(Not not) {
        return String.format("NOT(%s)", this.map(not.expression()));
    }

    private String mapOr(Or or) {
        return String.format("(%s OR %s)", this.map(or.left()), this.map(or.right()));
    }

    String formatValue(Object value) {
        if (value instanceof String || value instanceof UUID) {
            return "'" + String.valueOf(value) + "'";
        }
        return value.toString();
    }

    String formatValuesAsString(Collection<?> values) {
        return "(" + values.stream().map((? super T v) -> String.format("'%s'", v)).collect(Collectors.joining(",")) + ")";
    }
}

