/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.chatglm;

import dev.langchain4j.community.model.chatglm.ChatCompletionRequest;
import dev.langchain4j.community.model.chatglm.ChatCompletionResponse;
import dev.langchain4j.community.model.chatglm.ChatGlmApi;
import dev.langchain4j.community.model.chatglm.ChatGlmRequestLoggingInterceptor;
import dev.langchain4j.community.model.chatglm.ChatGlmResponseLoggingInterceptor;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

class ChatGlmClient {
    private final ChatGlmApi chatGLMApi;

    public ChatGlmClient(String baseUrl, Duration timeout, boolean logRequests, boolean logResponses) {
        baseUrl = (String)ValidationUtils.ensureNotNull((Object)baseUrl, (String)"baseUrl");
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        if (logRequests) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ChatGlmRequestLoggingInterceptor());
        }
        if (logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ChatGlmResponseLoggingInterceptor());
        }
        OkHttpClient okHttpClient = okHttpClientBuilder.build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.chatGLMApi = (ChatGlmApi)retrofit.create(ChatGlmApi.class);
    }

    public ChatCompletionResponse chatCompletion(ChatCompletionRequest request) {
        try {
            Response retrofitResponse = this.chatGLMApi.chatCompletion(request).execute();
            if (retrofitResponse.isSuccessful() && retrofitResponse.body() != null && ((ChatCompletionResponse)retrofitResponse.body()).getStatus() == 200) {
                return (ChatCompletionResponse)retrofitResponse.body();
            }
            throw this.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String baseUrl;
        private Duration timeout;
        private boolean logRequests;
        private boolean logResponses;

        Builder() {
        }

        Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        ChatGlmClient build() {
            return new ChatGlmClient(this.baseUrl, this.timeout, this.logRequests, this.logResponses);
        }
    }
}

