/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.rag.content.aggregator.strategy;

import dev.langchain4j.community.rag.content.aggregator.strategy.EmbeddingStrategy;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.rag.content.ContentMetadata;
import dev.langchain4j.rag.query.Query;
import dev.langchain4j.store.embedding.CosineSimilarity;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenerateEmbeddings
implements EmbeddingStrategy {
    private static final Logger log = LoggerFactory.getLogger(GenerateEmbeddings.class);
    private static final String TEMP_EMBEDDING_ID_PREFIX = "mmr-content-";

    @Override
    public Embedding processQueryEmbedding(Query query, List<Content> contents, EmbeddingModel embeddingModel) {
        log.debug("Generating query embedding for: {}", (Object)query.text().substring(0, Math.min(50, query.text().length())));
        return (Embedding)embeddingModel.embed(query.text()).content();
    }

    @Override
    public List<EmbeddingMatch<Content>> processContents(List<Content> contents, Embedding queryEmbedding, EmbeddingModel embeddingModel) {
        log.debug("Generating embeddings for {} contents using embedAll", (Object)contents.size());
        List textSegments = contents.stream().map(Content::textSegment).collect(Collectors.toList());
        List embeddings = (List)embeddingModel.embedAll(textSegments).content();
        ArrayList<EmbeddingMatch<Content>> matches = new ArrayList<EmbeddingMatch<Content>>();
        for (int i = 0; i < contents.size(); ++i) {
            Content content = contents.get(i);
            Embedding embedding = (Embedding)embeddings.get(i);
            double score = CosineSimilarity.between((Embedding)embedding, (Embedding)queryEmbedding);
            String embeddingId = this.getEmbeddingId(content);
            matches.add((EmbeddingMatch<Content>)new EmbeddingMatch(Double.valueOf(score), embeddingId, embedding, (Object)content));
        }
        return matches;
    }

    private String getEmbeddingId(Content content) {
        Object embeddingId = content.metadata().get(ContentMetadata.EMBEDDING_ID);
        if (embeddingId instanceof String && !((String)embeddingId).isBlank()) {
            return (String)embeddingId;
        }
        return TEMP_EMBEDDING_ID_PREFIX + Math.abs(content.hashCode());
    }
}

