/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.GenerationUsage;
import com.alibaba.dashscope.aigc.generation.SearchInfo;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationUsage;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.community.model.dashscope.QwenChatResponseMetadata;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class QwenStreamingResponseBuilder {
    private final StringBuilder generatedContent = new StringBuilder();
    private final Map<Integer, ToolExecutionRequestBuilder> indexToToolExecutionRequestBuilder = new ConcurrentHashMap<Integer, ToolExecutionRequestBuilder>();
    private final String modelName;
    private String id;
    private Integer inputTokenCount;
    private Integer outputTokenCount;
    private FinishReason finishReason;
    private SearchInfo searchInfo;
    private boolean incrementalOutput;

    public QwenStreamingResponseBuilder(String modelName, boolean incrementalOutput) {
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.incrementalOutput = incrementalOutput;
    }

    public String append(GenerationResult partialResponse) {
        FinishReason latestFinishReason;
        GenerationUsage usage;
        if (partialResponse == null) {
            return null;
        }
        if (!Utils.isNullOrBlank((String)partialResponse.getRequestId())) {
            this.id = partialResponse.getRequestId();
        }
        if (partialResponse.getOutput().getSearchInfo() != null) {
            this.searchInfo = partialResponse.getOutput().getSearchInfo();
        }
        if ((usage = partialResponse.getUsage()) != null) {
            this.inputTokenCount = usage.getInputTokens();
            this.outputTokenCount = usage.getOutputTokens();
        }
        if ((latestFinishReason = QwenHelper.finishReasonFrom(partialResponse)) != null) {
            this.finishReason = latestFinishReason;
        }
        if (QwenHelper.hasAnswer(partialResponse)) {
            String partialContent = QwenHelper.answerFrom(partialResponse);
            if (!this.incrementalOutput) {
                partialContent = partialContent.substring(this.generatedContent.length());
            }
            this.generatedContent.append(partialContent);
            return partialContent;
        }
        if (QwenHelper.isFunctionToolCalls(partialResponse)) {
            List<ToolCallBase> toolCalls = QwenHelper.toolCallsFrom(partialResponse);
            for (int index = 0; index < toolCalls.size(); ++index) {
                ToolCallFunction.CallFunction functionCall;
                ToolCallBase toolCallBase = toolCalls.get(index);
                if (!(toolCallBase instanceof ToolCallFunction)) continue;
                ToolCallFunction toolCall = (ToolCallFunction)toolCallBase;
                ToolExecutionRequestBuilder toolExecutionRequestBuilder = this.indexToToolExecutionRequestBuilder.computeIfAbsent(index, idx -> new ToolExecutionRequestBuilder());
                if (toolCall.getId() != null) {
                    toolExecutionRequestBuilder.idBuilder.append(toolCall.getId());
                }
                if ((functionCall = toolCall.getFunction()).getName() != null) {
                    toolExecutionRequestBuilder.nameBuilder.append(functionCall.getName());
                }
                if (functionCall.getArguments() == null) continue;
                toolExecutionRequestBuilder.argumentsBuilder.append(functionCall.getArguments());
            }
        }
        return null;
    }

    public String append(MultiModalConversationResult partialResponse) {
        FinishReason latestFinishReason;
        MultiModalConversationUsage usage;
        if (partialResponse == null) {
            return null;
        }
        if (!Utils.isNullOrBlank((String)partialResponse.getRequestId())) {
            this.id = partialResponse.getRequestId();
        }
        if ((usage = partialResponse.getUsage()) != null) {
            this.inputTokenCount = usage.getInputTokens();
            this.outputTokenCount = usage.getOutputTokens();
        }
        if ((latestFinishReason = QwenHelper.finishReasonFrom(partialResponse)) != null) {
            this.finishReason = latestFinishReason;
        }
        if (QwenHelper.hasAnswer(partialResponse)) {
            String partialContent = QwenHelper.answerFrom(partialResponse);
            if (!this.incrementalOutput) {
                partialContent = partialContent.substring(this.generatedContent.length());
            }
            this.generatedContent.append(partialContent);
            return partialContent;
        }
        return null;
    }

    public ChatResponse build() {
        String text = this.generatedContent.toString();
        if (!this.indexToToolExecutionRequestBuilder.isEmpty()) {
            List toolExecutionRequests = this.indexToToolExecutionRequestBuilder.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
            AiMessage aiMessage = Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
            return ChatResponse.builder().aiMessage(aiMessage).metadata((ChatResponseMetadata)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)QwenChatResponseMetadata.builder().id(this.id)).modelName(this.modelName)).tokenUsage(new TokenUsage(this.inputTokenCount, this.outputTokenCount))).finishReason(this.finishReason)).searchInfo(QwenHelper.convertSearchInfo(this.searchInfo)).build()).build();
        }
        if (!Utils.isNullOrBlank((String)text)) {
            return ChatResponse.builder().aiMessage(AiMessage.from((String)text)).metadata((ChatResponseMetadata)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)QwenChatResponseMetadata.builder().id(this.id)).modelName(this.modelName)).tokenUsage(new TokenUsage(this.inputTokenCount, this.outputTokenCount))).finishReason(this.finishReason)).searchInfo(QwenHelper.convertSearchInfo(this.searchInfo)).build()).build();
        }
        return null;
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuilder idBuilder = new StringBuilder();
        private final StringBuilder nameBuilder = new StringBuilder();
        private final StringBuilder argumentsBuilder = new StringBuilder();

        private ToolExecutionRequestBuilder() {
        }
    }
}

